@extends('layouts.app')
@section('content')
<div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 py-4 sm:py-6 lg:py-8">
    <h2 class="text-xl sm:text-2xl font-bold mb-4 sm:mb-6 text-center sm:text-left">Galeri Kegiatan Desa</h2>
    <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 gap-3 sm:gap-4 lg:gap-6">
        @foreach($galeri as $item)
            <div class="bg-white rounded-lg shadow-md p-2 sm:p-3 flex flex-col items-center hover:shadow-lg transition-shadow">
                <img src="{{ $item->gambar ? asset($item->gambar) : 'https://storage.googleapis.com/a1aa/image/752879b4-785b-4f86-832c-0ff3f174167a.jpg' }}" alt="{{ $item->judul }}" class="rounded-lg mb-2 h-24 sm:h-32 w-full object-cover">
                <p class="font-semibold text-xs sm:text-sm mb-1 text-center line-clamp-2">{{ $item->judul }}</p>
                <a href="{{ route('galeri.detail', $item->id) }}" class="text-[#1dbf4a] hover:text-[#0f9d58] text-xs font-semibold">Lihat Detail →</a>
            </div>
        @endforeach
    </div>
    <div class="mt-6 sm:mt-8 flex justify-center">{{ $galeri->links() }}</div>
</div>
@endsection 