@extends('layouts.app')
@section('content')
<div class="max-w-2xl mx-auto px-4 sm:px-6 lg:px-8 py-4 sm:py-6 lg:py-8">
    <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold mb-3 sm:mb-4 text-center sm:text-left">{{ $galeri->judul }}</h1>
    @if($galeri->gambar)
        <img src="{{ asset($galeri->gambar) }}" alt="{{ $galeri->judul }}" class="rounded-lg mb-4 sm:mb-6 w-full h-48 sm:h-64 lg:h-96 object-cover shadow-md">
    @else
        <div class="rounded-lg mb-4 sm:mb-6 w-full h-48 sm:h-64 lg:h-96 bg-gray-200 flex items-center justify-center">
            <i class="fas fa-image text-gray-400 text-4xl sm:text-6xl"></i>
        </div>
    @endif
    <div class="prose prose-sm sm:prose-base max-w-none mb-4 sm:mb-6 text-sm sm:text-base leading-relaxed">
        {{ $galeri->deskripsi ?? '' }}
    </div>
    <div class="text-center sm:text-left">
        <a href="{{ route('galeri.list') }}" class="inline-flex items-center gap-2 text-[#1dbf4a] hover:text-[#0f9d58] font-semibold text-sm sm:text-base">
            <i class="fas fa-arrow-left"></i>
            Kembali ke Galeri
        </a>
    </div>
</div>
@endsection 