@extends('layouts.app')
@section('content')
<div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 py-4 sm:py-6 lg:py-8">
    <h2 class="text-xl sm:text-2xl font-bold mb-4 sm:mb-6 text-center sm:text-left">Daftar Pengumuman</h2>
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-6">
        @foreach($pengumuman as $item)
            <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 flex flex-col hover:shadow-lg transition-shadow">
                @if($item->gambar)
                    <img src="{{ asset($item->gambar) }}" alt="{{ $item->judul }}" class="rounded mb-3 h-32 sm:h-40 object-cover w-full">
                @endif
                <h3 class="font-semibold text-sm sm:text-lg mb-2 line-clamp-2">{{ $item->judul }}</h3>
                <p class="text-xs sm:text-sm text-gray-600 mb-3 flex-grow">{{ Str::limit($item->isi, 100) }}</p>
                <div class="flex justify-between items-center">
                    <div class="text-xs text-gray-400 flex items-center gap-1">
                        <i class="far fa-calendar-alt"></i> 
                        {{ $item->published_at ? $item->published_at->format('d/m/Y') : $item->created_at->format('d/m/Y') }}
                    </div>
                    <a href="{{ route('pengumuman.detail', $item->id) }}" class="text-xs sm:text-sm text-[#1dbf4a] hover:text-[#0f9d58] font-semibold">Baca Selengkapnya →</a>
                </div>
            </div>
        @endforeach
    </div>
    <div class="mt-6 sm:mt-8 flex justify-center">{{ $pengumuman->links() }}</div>
</div>
@endsection 