@extends('layouts.app')
@section('content')
<div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8 py-4 sm:py-6 lg:py-8">
    <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold mb-3 sm:mb-4 text-center sm:text-left">{{ $pengumuman->judul }}</h1>
    <div class="mb-4 sm:mb-6 text-gray-500 text-xs sm:text-sm flex flex-col sm:flex-row sm:items-center gap-2 sm:gap-4 justify-center sm:justify-start">
        <span class="flex items-center gap-1"><i class="fas fa-user"></i> {{ $pengumuman->author }}</span>
        <span class="hidden sm:inline">|</span>
        <span class="flex items-center gap-1"><i class="far fa-calendar-alt"></i> {{ $pengumuman->published_at ? $pengumuman->published_at->format('d/m/Y') : $pengumuman->created_at->format('d/m/Y') }}</span>
    </div>
    <div class="prose prose-sm sm:prose-base max-w-none mb-4 sm:mb-6 text-sm sm:text-base leading-relaxed">
        {!! nl2br(e($pengumuman->isi)) !!}
    </div>
    <div class="text-center sm:text-left">
        <a href="{{ route('pengumuman.list') }}" class="inline-flex items-center gap-2 text-[#1dbf4a] hover:text-[#0f9d58] font-semibold text-sm sm:text-base">
            <i class="fas fa-arrow-left"></i>
            Kembali ke Daftar Pengumuman
        </a>
    </div>
</div>
@endsection 