<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Admin Panel - RRDesa</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet"/>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600&display=swap" rel="stylesheet"/>
    <link href="/css/app.css" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; }
    </style>
</head>
<body class="bg-gray-100">
    <div class="min-h-screen flex">
        <!-- Sidebar -->
        <div class="bg-[#1dbf4a] text-white w-64 min-h-screen flex-shrink-0">
            <div class="p-4">
                <div class="flex items-center space-x-2">
                    <img alt="RRDesa logo" class="w-8 h-8" src="{{ \App\Models\HomeSetting::where('key', 'logo_url')->first()->value ?? 'https://storage.googleapis.com/a1aa/image/90702b93-e752-47cf-0b6e-36dcb93e8d1d.jpg' }}" />
                    <span class="font-semibold text-lg">RRDesa Admin</span>
                </div>
            </div>
            <nav class="mt-8">
                <a href="{{ route('admin.dashboard') }}" class="flex items-center px-4 py-3 text-white hover:bg-[#0f9d58] {{ request()->routeIs('admin.dashboard') ? 'bg-[#0f9d58]' : '' }}">
                    <i class="fas fa-tachometer-alt mr-3"></i>
                    Dashboard
                </a>
                <a href="{{ route('admin.pengumuman.index') }}" class="flex items-center px-4 py-3 text-white hover:bg-[#0f9d58] {{ request()->routeIs('admin.pengumuman.*') ? 'bg-[#0f9d58]' : '' }}">
                    <i class="fas fa-bullhorn mr-3"></i>
                    Pengumuman
                </a>
                <a href="{{ route('admin.berita.index') }}" class="flex items-center px-4 py-3 text-white hover:bg-[#0f9d58] {{ request()->routeIs('admin.berita.*') ? 'bg-[#0f9d58]' : '' }}">
                    <i class="fas fa-newspaper mr-3"></i>
                    Berita
                </a>
                <a href="{{ route('admin.aparatur.index') }}" class="flex items-center px-4 py-3 text-white hover:bg-[#0f9d58] {{ request()->routeIs('admin.aparatur.*') ? 'bg-[#0f9d58]' : '' }}">
                    <i class="fas fa-users mr-3"></i>
                    Aparatur
                </a>
                <a href="{{ route('admin.pengaduan.index') }}" class="flex items-center px-4 py-3 text-white hover:bg-[#0f9d58] {{ request()->routeIs('admin.pengaduan.*') ? 'bg-[#0f9d58]' : '' }}">
                    <i class="fas fa-comment-alt mr-3"></i>
                    Pengaduan
                </a>
                <a href="{{ route('admin.galeri.index') }}" class="flex items-center px-4 py-3 text-white hover:bg-[#0f9d58] {{ request()->routeIs('admin.galeri.*') ? 'bg-[#0f9d58]' : '' }}">
                    <i class="fas fa-images mr-3"></i>
                    Galeri
                </a>
                <a href="{{ route('admin.anggaran.index') }}" class="flex items-center px-4 py-3 text-white hover:bg-[#0f9d58] {{ request()->routeIs('admin.anggaran.*') ? 'bg-[#0f9d58]' : '' }}">
                    <i class="fas fa-chart-pie mr-3"></i>
                    Anggaran
                </a>
            </nav>
        </div>

        <!-- Main Content -->
        <div class="flex-1 flex flex-col">
            <!-- Top Navbar -->
            <header class="bg-white shadow-sm border-b">
                <div class="flex items-center justify-between px-6 py-4">
                    <h1 class="text-xl font-semibold text-gray-800">@yield('title', 'Dashboard')</h1>
                    <div class="flex items-center space-x-4">
                        <a href="{{ route('home') }}" class="text-gray-600 hover:text-gray-800">
                            <i class="fas fa-home"></i> Lihat Website
                        </a>
                        <div class="w-8 h-8 bg-gray-300 rounded-full"></div>
                    </div>
                </div>
            </header>

            <!-- Page Content -->
            <main class="flex-1 p-6">
                @if(session('success'))
                    <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                        {{ session('success') }}
                    </div>
                @endif

                @if(session('error'))
                    <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                        {{ session('error') }}
                    </div>
                @endif

                @yield('content')
            </main>
        </div>
    </div>
</body>
</html> 