<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\PengumumanController;
use App\Http\Controllers\BeritaController;
use App\Http\Controllers\AparaturController;
use App\Http\Controllers\PengaduanController;
use App\Http\Controllers\GaleriController;
use App\Http\Controllers\AnggaranController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\Frontend\BeritaFrontendController;
use App\Http\Controllers\Frontend\PengumumanFrontendController;
use App\Http\Controllers\Frontend\GaleriFrontendController;
use App\Http\Controllers\Frontend\AparaturFrontendController;

// Frontend routes
Route::get('/', [HomeController::class, 'index'])->name('home');

// Frontend public routes
Route::get('/berita', [BeritaFrontendController::class, 'index'])->name('berita.list');
Route::get('/berita/{id}', [BeritaFrontendController::class, 'show'])->name('berita.detail');

Route::get('/pengumuman', [PengumumanFrontendController::class, 'index'])->name('pengumuman.list');
Route::get('/pengumuman/{id}', [PengumumanFrontendController::class, 'show'])->name('pengumuman.detail');

Route::get('/galeri', [GaleriFrontendController::class, 'index'])->name('galeri.list');
Route::get('/galeri/{id}', [GaleriFrontendController::class, 'show'])->name('galeri.detail');

Route::get('/aparatur', [AparaturFrontendController::class, 'index'])->name('aparatur.list');
Route::get('/aparatur/{id}', [AparaturFrontendController::class, 'show'])->name('aparatur.detail');

// Admin authentication routes
Route::get('/admin/login', [AuthController::class, 'showLogin'])->name('admin.login');
Route::post('/admin/login', [AuthController::class, 'login'])->name('admin.login.post');
Route::post('/admin/logout', [AuthController::class, 'logout'])->name('admin.logout');

// Protected admin routes
Route::middleware(['auth'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', [AdminController::class, 'dashboard'])->name('dashboard');
    
    // Pengumuman routes
    Route::resource('pengumuman', PengumumanController::class);
    
    // Berita routes
    Route::resource('berita', BeritaController::class);
    
    // Aparatur routes
    Route::resource('aparatur', AparaturController::class);
    
    // Pengaduan routes
    Route::resource('pengaduan', PengaduanController::class);
    
    // Galeri routes
    Route::resource('galeri', GaleriController::class);
    
    // Anggaran routes
    Route::resource('anggaran', AnggaranController::class);

    // HomeSetting routes
    Route::resource('home-setting', App\Http\Controllers\Admin\HomeSettingController::class);
});
