

<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
  <div class="col-xl-3 col-sm-6 mb-xl-0 mb-4">
    <div class="card">
      <div class="card-body p-3">
        <div class="row">
          <div class="col-8">
            <div class="numbers">
              <p class="text-sm mb-0 text-capitalize font-weight-bold">Total Pengumuman</p>
              <h5 class="font-weight-bolder mb-0">
                <?php echo e($total_pengumuman); ?>

                <span class="text-success text-sm font-weight-bolder">+<?php echo e($total_pengumuman > 0 ? '100%' : '0%'); ?></span>
              </h5>
            </div>
          </div>
          <div class="col-4 text-end">
            <div class="icon icon-shape bg-gradient-primary shadow text-center border-radius-md">
              <i class="fas fa-bullhorn text-lg opacity-10" aria-hidden="true"></i>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-xl-3 col-sm-6 mb-xl-0 mb-4">
    <div class="card">
      <div class="card-body p-3">
        <div class="row">
          <div class="col-8">
            <div class="numbers">
              <p class="text-sm mb-0 text-capitalize font-weight-bold">Total Berita</p>
              <h5 class="font-weight-bolder mb-0">
                <?php echo e($total_berita); ?>

                <span class="text-success text-sm font-weight-bolder">+<?php echo e($total_berita > 0 ? '100%' : '0%'); ?></span>
              </h5>
            </div>
          </div>
          <div class="col-4 text-end">
            <div class="icon icon-shape bg-gradient-primary shadow text-center border-radius-md">
              <i class="fas fa-newspaper text-lg opacity-10" aria-hidden="true"></i>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-xl-3 col-sm-6 mb-xl-0 mb-4">
    <div class="card">
      <div class="card-body p-3">
        <div class="row">
          <div class="col-8">
            <div class="numbers">
              <p class="text-sm mb-0 text-capitalize font-weight-bold">Total Pengaduan</p>
              <h5 class="font-weight-bolder mb-0">
                <?php echo e($total_pengaduan); ?>

                <span class="text-danger text-sm font-weight-bolder">+<?php echo e($total_pengaduan > 0 ? '100%' : '0%'); ?></span>
              </h5>
            </div>
          </div>
          <div class="col-4 text-end">
            <div class="icon icon-shape bg-gradient-primary shadow text-center border-radius-md">
              <i class="fas fa-comments text-lg opacity-10" aria-hidden="true"></i>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-xl-3 col-sm-6">
    <div class="card">
      <div class="card-body p-3">
        <div class="row">
          <div class="col-8">
            <div class="numbers">
              <p class="text-sm mb-0 text-capitalize font-weight-bold">Total Aparatur</p>
              <h5 class="font-weight-bolder mb-0">
                <?php echo e($total_aparatur); ?>

                <span class="text-success text-sm font-weight-bolder">+<?php echo e($total_aparatur > 0 ? '100%' : '0%'); ?></span>
              </h5>
            </div>
          </div>
          <div class="col-4 text-end">
            <div class="icon icon-shape bg-gradient-primary shadow text-center border-radius-md">
              <i class="fas fa-users text-lg opacity-10" aria-hidden="true"></i>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="row mt-4">
  <div class="col-lg-7 mb-lg-0 mb-4">
    <div class="card">
      <div class="card-body p-3">
        <div class="row">
          <div class="col-lg-6">
            <div class="d-flex flex-column h-100">
              <p class="mb-1 pt-2 text-bold">Website Desa</p>
              <h5 class="font-weight-bolder">Dashboard Admin</h5>
              <p class="mb-5">Selamat datang di panel admin website desa. Kelola semua konten dan layanan warga dengan mudah.</p>
              <a class="text-body text-sm font-weight-bold mb-0 icon-move-right mt-auto" href="<?php echo e(route('home')); ?>" target="_blank">
                Lihat Website
                <i class="fas fa-arrow-right text-sm ms-1" aria-hidden="true"></i>
              </a>
            </div>
          </div>
          <div class="col-lg-5 ms-auto text-center mt-5 mt-lg-0">
            <div class="bg-gradient-primary border-radius-lg h-100">
              <img src="<?php echo e(asset('assets/img/shapes/waves-white.svg')); ?>" class="position-absolute h-100 w-50 top-0 d-lg-block d-none" alt="waves">
              <div class="position-relative d-flex align-items-center justify-content-center h-100">
                <img class="w-100 position-relative z-index-2 pt-4" src="<?php echo e(asset('assets/img/illustrations/rocket-white.png')); ?>" alt="rocket">
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-lg-5">
    <div class="card h-100 p-3">
      <div class="overflow-hidden position-relative border-radius-lg bg-cover h-100" style="background-image: url('<?php echo e(asset('assets/img/ivancik.jpg')); ?>');">
        <span class="mask bg-gradient-dark"></span>
        <div class="card-body position-relative z-index-1 d-flex flex-column h-100 p-3">
          <h5 class="text-white font-weight-bolder mb-4 pt-2">Pengaduan Terbaru</h5>
          <p class="text-white">Lihat pengaduan terbaru dari warga desa untuk ditindaklanjuti.</p>
          <a class="text-white text-sm font-weight-bold mb-0 icon-move-right mt-auto" href="<?php echo e(route('admin.pengaduan.index')); ?>">
            Lihat Semua
            <i class="fas fa-arrow-right text-sm ms-1" aria-hidden="true"></i>
          </a>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="row mt-4">
  <div class="col-lg-5 mb-lg-0 mb-4">
    <div class="card z-index-2">
      <div class="card-body p-3">
        <div class="bg-gradient-dark border-radius-lg py-3 pe-1 mb-3">
          <div class="chart">
            <canvas id="chart-bars" class="chart-canvas" height="170"></canvas>
          </div>
        </div>
        <h6 class="ms-2 mt-4 mb-0">Statistik Konten</h6>
        <p class="text-sm ms-2">Ringkasan data konten website</p>
        <div class="container border-radius-lg">
          <div class="row">
            <div class="col-3 py-3 ps-0">
              <div class="d-flex mb-2">
                <div class="icon icon-shape icon-xxs shadow border-radius-sm bg-gradient-primary text-center me-2 d-flex align-items-center justify-content-center">
                  <i class="fas fa-bullhorn text-white" style="font-size: 10px;"></i>
                </div>
                <p class="text-xs mt-1 mb-0 font-weight-bold">Pengumuman</p>
              </div>
              <h4 class="font-weight-bolder"><?php echo e($total_pengumuman); ?></h4>
              <div class="progress w-75">
                <div class="progress-bar bg-dark w-<?php echo e($total_pengumuman > 0 ? '60' : '0'); ?>" role="progressbar" aria-valuenow="<?php echo e($total_pengumuman > 0 ? '60' : '0'); ?>" aria-valuemin="0" aria-valuemax="100"></div>
              </div>
            </div>
            <div class="col-3 py-3 ps-0">
              <div class="d-flex mb-2">
                <div class="icon icon-shape icon-xxs shadow border-radius-sm bg-gradient-info text-center me-2 d-flex align-items-center justify-content-center">
                  <i class="fas fa-newspaper text-white" style="font-size: 10px;"></i>
                </div>
                <p class="text-xs mt-1 mb-0 font-weight-bold">Berita</p>
              </div>
              <h4 class="font-weight-bolder"><?php echo e($total_berita); ?></h4>
              <div class="progress w-75">
                <div class="progress-bar bg-dark w-<?php echo e($total_berita > 0 ? '90' : '0'); ?>" role="progressbar" aria-valuenow="<?php echo e($total_berita > 0 ? '90' : '0'); ?>" aria-valuemin="0" aria-valuemax="100"></div>
              </div>
            </div>
            <div class="col-3 py-3 ps-0">
              <div class="d-flex mb-2">
                <div class="icon icon-shape icon-xxs shadow border-radius-sm bg-gradient-warning text-center me-2 d-flex align-items-center justify-content-center">
                  <i class="fas fa-comments text-white" style="font-size: 10px;"></i>
                </div>
                <p class="text-xs mt-1 mb-0 font-weight-bold">Pengaduan</p>
              </div>
              <h4 class="font-weight-bolder"><?php echo e($total_pengaduan); ?></h4>
              <div class="progress w-75">
                <div class="progress-bar bg-dark w-<?php echo e($total_pengaduan > 0 ? '40' : '0'); ?>" role="progressbar" aria-valuenow="<?php echo e($total_pengaduan > 0 ? '40' : '0'); ?>" aria-valuemin="0" aria-valuemax="100"></div>
              </div>
            </div>
            <div class="col-3 py-3 ps-0">
              <div class="d-flex mb-2">
                <div class="icon icon-shape icon-xxs shadow border-radius-sm bg-gradient-success text-center me-2 d-flex align-items-center justify-content-center">
                  <i class="fas fa-users text-white" style="font-size: 10px;"></i>
                </div>
                <p class="text-xs mt-1 mb-0 font-weight-bold">Aparatur</p>
              </div>
              <h4 class="font-weight-bolder"><?php echo e($total_aparatur); ?></h4>
              <div class="progress w-75">
                <div class="progress-bar bg-dark w-<?php echo e($total_aparatur > 0 ? '80' : '0'); ?>" role="progressbar" aria-valuenow="<?php echo e($total_aparatur > 0 ? '80' : '0'); ?>" aria-valuemin="0" aria-valuemax="100"></div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-lg-7">
    <div class="card z-index-2">
      <div class="card-header pb-0">
        <h6>Pengaduan Terbaru</h6>
        <p class="text-sm">
          <i class="fa fa-arrow-up text-success"></i>
          <span class="font-weight-bold"><?php echo e($pengaduan_terbaru->count()); ?></span> pengaduan baru
        </p>
      </div>
      <div class="card-body p-3">
        <div class="timeline timeline-one-side">
          <?php $__empty_1 = true; $__currentLoopData = $pengaduan_terbaru; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pengaduan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
          <div class="timeline-block mb-3">
            <span class="timeline-step">
              <i class="fas fa-comment text-info text-gradient"></i>
            </span>
            <div class="timeline-content">
              <h6 class="text-dark text-sm font-weight-bold mb-0"><?php echo e($pengaduan->nama); ?></h6>
              <p class="text-secondary font-weight-bold text-xs mt-1 mb-0">
                <?php echo e(Str::limit($pengaduan->isi, 50)); ?>

              </p>
              <p class="text-secondary font-weight-bold text-xs mt-1 mb-0">
                <?php echo e($pengaduan->created_at->diffForHumans()); ?>

              </p>
            </div>
          </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
          <div class="timeline-block mb-3">
            <span class="timeline-step">
              <i class="fas fa-info text-secondary text-gradient"></i>
            </span>
            <div class="timeline-content">
              <h6 class="text-dark text-sm font-weight-bold mb-0">Belum ada pengaduan</h6>
              <p class="text-secondary font-weight-bold text-xs mt-1 mb-0">
                Pengaduan dari warga akan muncul di sini
              </p>
            </div>
          </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('dashboard'); ?>
<script>
  var ctx = document.getElementById("chart-bars").getContext("2d");

  new Chart(ctx, {
    type: "bar",
    data: {
      labels: ["Pengumuman", "Berita", "Pengaduan", "Aparatur", "Galeri", "Anggaran"],
      datasets: [{
        label: "Jumlah",
        tension: 0.4,
        borderWidth: 0,
        borderRadius: 4,
        borderSkipped: false,
        backgroundColor: "rgba(255, 255, 255, .8)",
        data: [<?php echo e($total_pengumuman); ?>, <?php echo e($total_berita); ?>, <?php echo e($total_pengaduan); ?>, <?php echo e($total_aparatur); ?>, <?php echo e($total_galeri); ?>, <?php echo e($total_anggaran); ?>],
        maxBarThickness: 6
      }, ],
    },
    options: {
      responsive: true,
      maintainAspectRatio: false,
      plugins: {
        legend: {
          display: false,
        }
      },
      interaction: {
        intersect: false,
        mode: 'index',
      },
      scales: {
        y: {
          grid: {
            drawBorder: false,
            display: true,
            drawOnChartArea: true,
            drawTicks: false,
            borderDash: [5, 5],
            color: 'rgba(255, 255, 255, .2)'
          },
          ticks: {
            suggestedMin: 0,
            suggestedMax: 500,
            beginAtZero: true,
            padding: 10,
            font: {
              size: 14,
              weight: 300,
              family: "Roboto",
              style: 'normal',
              lineHeight: 2
            },
            color: "#fff"
          },
        },
        x: {
          grid: {
            drawBorder: false,
            display: true,
            drawOnChartArea: true,
            drawTicks: false,
            borderDash: [5, 5],
            color: 'rgba(255, 255, 255, .2)'
          },
          ticks: {
            display: true,
            color: '#f8f9fa',
            padding: 10,
            font: {
              size: 14,
              weight: 300,
              family: "Roboto",
              style: 'normal',
              lineHeight: 2
            },
          }
        },
      },
    },
  });
</script>
<?php $__env->stopPush(); ?> 
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\website-desa\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>