
<?php $__env->startSection('content'); ?>
<div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 py-4 sm:py-6 lg:py-8">
    <h2 class="text-xl sm:text-2xl font-bold mb-4 sm:mb-6 text-center sm:text-left">Daftar Berita</h2>
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-6">
        <?php $__currentLoopData = $berita; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 flex flex-col hover:shadow-lg transition-shadow">
                <img src="<?php echo e($item->gambar ? asset($item->gambar) : 'https://storage.googleapis.com/a1aa/image/e8386500-9792-4430-6e34-b659c6470a30.jpg'); ?>" alt="<?php echo e($item->judul); ?>" class="rounded mb-3 h-32 sm:h-40 object-cover w-full">
                <h3 class="font-semibold text-sm sm:text-lg mb-2 line-clamp-2"><?php echo e($item->judul); ?></h3>
                <p class="text-xs sm:text-sm text-gray-600 mb-3 flex-grow"><?php echo e(Str::limit($item->isi, 100)); ?></p>
                <div class="flex justify-between items-center">
                    <span class="text-xs text-gray-500"><?php echo e($item->created_at->format('d/m/Y')); ?></span>
                    <a href="<?php echo e(route('berita.detail', $item->id)); ?>" class="text-xs sm:text-sm text-[#1dbf4a] hover:text-[#0f9d58] font-semibold">Baca Selengkapnya →</a>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <div class="mt-6 sm:mt-8 flex justify-center"><?php echo e($berita->links()); ?></div>
</div>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\website-desa\resources\views/frontend/berita/index.blade.php ENDPATH**/ ?>