

<?php $__env->startSection('content'); ?>
    <!-- Top bar -->
    <div class="bg-[#1dbf4a] text-white text-xs sm:text-sm flex justify-between items-center px-4 sm:px-8 py-1">
        <div class="flex items-center space-x-2 sm:space-x-4">
            <i class="fas fa-envelope"></i>
            <span class="hidden sm:inline"><?php echo e($settings['email'] ?? 'secretariat@desarrdigital.id'); ?></span>
            <span class="sm:hidden">Email</span>
            <span class="hidden sm:inline">|</span>
            <i class="fas fa-phone-alt"></i>
            <span class="hidden sm:inline"><?php echo e($settings['wa_number'] ?? '+62 812 9496 2546'); ?></span>
            <span class="sm:hidden">WA</span>
        </div>
        <div class="flex space-x-3 text-sm sm:text-base">
            <a class="hover:text-gray-200" href="#"><i class="fab fa-whatsapp"></i></a>
            <a class="hover:text-gray-200" href="#"><i class="fab fa-facebook-f"></i></a>
            <a class="hover:text-gray-200" href="#"><i class="fab fa-twitter"></i></a>
            <a class="hover:text-gray-200" href="#"><i class="fab fa-youtube"></i></a>
        </div>
    </div>
    
    <!-- Navbar -->
    <nav class="bg-[#1dbf4a] flex items-center justify-between px-4 sm:px-8 py-3">
        <div class="flex items-center space-x-2 sm:space-x-4">
            <?php if($settings['logo_url'] ?? false): ?>
                <img alt="RRDesa logo" class="w-10 h-10 sm:w-12 sm:h-12 object-contain" src="<?php echo e(asset($settings['logo_url'])); ?>" />
            <?php else: ?>
                <div class="w-10 h-10 sm:w-12 sm:h-12 bg-white bg-opacity-20 rounded-lg flex items-center justify-center">
                    <span class="text-white font-bold text-sm sm:text-base">RR</span>
                </div>
            <?php endif; ?>
            <span class="text-white font-robotoslab font-semibold text-base sm:text-xl"><?php echo e($settings['hero_title'] ?? 'RRDesa.'); ?></span>
        </div>
        
        <!-- Desktop Navigation -->
        <ul class="hidden lg:flex space-x-6 text-white font-semibold text-sm sm:text-base">
            <li class="flex items-center space-x-1"><i class="fas fa-star text-orange-400"></i><a class="hover:text-gray-200" href="#">Profil Desa</a></li>
            <li><a class="hover:text-gray-200" href="#">Informasi Desa</a></li>
            <li><a class="hover:text-gray-200" href="#">Data Statistik</a></li>
            <li><a class="hover:text-gray-200" href="#">Kontak</a></li>
        </ul>
        
        <!-- Mobile Menu Button -->
        <button id="mobile-menu-btn" class="lg:hidden text-white p-2">
            <i class="fas fa-bars text-lg"></i>
        </button>
        
        <button class="bg-orange-500 hover:bg-orange-600 text-white text-xs sm:text-sm font-semibold rounded-full px-3 sm:px-4 py-1 hidden sm:block" type="button">
            Buat Pengaduan <i class="fas fa-arrow-right ml-1"></i>
        </button>
    </nav>
    
    <!-- Mobile Navigation Menu -->
    <div id="mobile-menu" class="lg:hidden hidden bg-[#1dbf4a] text-white">
        <ul class="px-4 py-2 space-y-2">
            <li class="flex items-center space-x-1 py-2"><i class="fas fa-star text-orange-400"></i><a class="hover:text-gray-200" href="#">Profil Desa</a></li>
            <li class="py-2"><a class="hover:text-gray-200" href="#">Informasi Desa</a></li>
            <li class="py-2"><a class="hover:text-gray-200" href="#">Data Statistik</a></li>
            <li class="py-2"><a class="hover:text-gray-200" href="#">Kontak</a></li>
            <li class="py-2">
                <button class="bg-orange-500 hover:bg-orange-600 text-white text-sm font-semibold rounded-full px-4 py-2 w-full" type="button">
                    Buat Pengaduan <i class="fas fa-arrow-right ml-1"></i>
                </button>
            </li>
        </ul>
    </div>
    
    <!-- Hero Section -->
    <section class="relative">
        <img alt="Village background" class="w-full h-48 sm:h-64 md:h-[28rem] object-cover" src="<?php echo e($settings['background_url'] ?? 'https://storage.googleapis.com/a1aa/image/5c5557dc-83c0-4629-736c-4b7f4debd7fd.jpg'); ?>" />
        <div class="absolute inset-0 bg-black bg-opacity-40 flex flex-col items-center justify-center px-4">

            <h2 class="text-white text-center text-xs sm:text-sm md:text-base font-semibold mb-4 sm:mb-6 px-2"><?php echo e($settings['hero_subtitle'] ?? 'Kel. Kalibaru Kec. Cilodong Kota Depok'); ?></h2>
            <input class="w-full max-w-xl rounded-full py-2 px-4 text-sm sm:text-base placeholder:text-gray-400 focus:outline-none focus:ring-2 focus:ring-orange-400" placeholder="Cari informasi yang anda butuhkan disini..." type="text"/>
            <div class="mt-6 sm:mt-8 w-full max-w-4xl flex flex-wrap justify-center gap-2 sm:gap-4 text-xs sm:text-sm">
                <a class="bg-white rounded-lg shadow-md w-16 sm:w-20 md:w-24 py-2 sm:py-3 text-center font-semibold text-gray-700 hover:bg-gray-100" href="<?php echo e(route('galeri.list')); ?>">Galeri</a>
                <a class="bg-white rounded-lg shadow-md w-16 sm:w-20 md:w-24 py-2 sm:py-3 text-center font-semibold text-gray-700 hover:bg-gray-100" href="<?php echo e(route('berita.list')); ?>">Berita</a>
                <a class="bg-white rounded-lg shadow-md w-16 sm:w-20 md:w-24 py-2 sm:py-3 text-center font-semibold text-gray-700 hover:bg-gray-100" href="#pengaduan">Pengaduan</a>
                <a class="bg-white rounded-lg shadow-md w-16 sm:w-20 md:w-24 py-2 sm:py-3 text-center font-semibold text-gray-700 hover:bg-gray-100" href="#produk">Produk</a>
                <a class="bg-white rounded-lg shadow-md w-16 sm:w-20 md:w-24 py-2 sm:py-3 text-center font-semibold text-gray-700 hover:bg-gray-100" href="<?php echo e(route('berita.list')); ?>">Berita</a>
                <a class="bg-white rounded-lg shadow-md w-16 sm:w-20 md:w-24 py-2 sm:py-3 text-center font-semibold text-gray-700 hover:bg-gray-100 flex items-center justify-center gap-1" href="<?php echo e(route('pengumuman.list')); ?>"><i class="fas fa-bullhorn text-gray-600"></i>Pengumuman</a>
                <a class="bg-white rounded-lg shadow-md w-16 sm:w-20 md:w-24 py-2 sm:py-3 text-center font-semibold text-gray-700 hover:bg-gray-100 flex items-center justify-center gap-1" href="<?php echo e(route('aparatur.list')); ?>"><img alt="Icon of a person with a hat" class="inline-block w-3 h-3 sm:w-4 sm:h-4" src="https://storage.googleapis.com/a1aa/image/fe7c2a9e-fa38-41e1-a5ae-a38731a8297d.jpg"/>Aparatur</a>
                <a class="bg-white rounded-lg shadow-md w-16 sm:w-20 md:w-24 py-2 sm:py-3 text-center font-semibold text-gray-700 hover:bg-gray-100 flex items-center justify-center gap-1" href="#peta"><img alt="Icon of a map pin" class="inline-block w-3 h-3 sm:w-4 sm:h-4" src="https://storage.googleapis.com/a1aa/image/810403ca-3d75-47ef-e686-0192c7e84c82.jpg"/>Peta</a>
            </div>
        </div>
    </section>
    
    <!-- Announcement and Pie Chart Section -->
    <section class="max-w-7xl mx-auto px-4 sm:px-8 py-4 sm:py-8 flex flex-col lg:flex-row gap-4 sm:gap-6">
        <!-- Announcement -->
        <div class="lg:w-2/3 bg-white rounded-lg shadow-md overflow-hidden relative">
            <div class="absolute top-2 left-2 bg-orange-400 text-white text-xs font-semibold px-3 py-1 rounded z-10">
                Pengumuman Desa
            </div>
            <?php if($pengumuman->count()): ?>
                <?php $__currentLoopData = $pengumuman; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="p-3 sm:p-4 border-t border-gray-200">
                        <div class="flex items-center space-x-2 mb-2">
                            <img alt="Small logo icon" class="w-5 h-5 sm:w-6 sm:h-6" src="<?php echo e($item->gambar ? asset($item->gambar) : 'https://storage.googleapis.com/a1aa/image/56bf6c35-b8b4-4e50-f31d-c52bf9814b01.jpg'); ?>"/>
                            <h3 class="text-xs sm:text-sm font-semibold"><?php echo e($item->judul); ?></h3>
                        </div>
                        <p class="text-xs text-gray-600 mb-1">
                            <?php echo e(Str::limit($item->isi, 100)); ?>

                        </p>
                        <div class="text-xs text-gray-400 flex items-center space-x-2">
                            <i class="far fa-clock"></i>
                            <span><?php echo e($item->published_at ? $item->published_at->format('d/m/Y H:i') : $item->created_at->format('d/m/Y H:i')); ?></span>
                            <span class="hidden sm:inline">|</span>
                            <span><?php echo e($item->author); ?></span>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <div class="p-4">Belum ada pengumuman.</div>
            <?php endif; ?>
        </div>
        <!-- Pie Chart -->
        <div class="lg:w-1/3 bg-white rounded-lg shadow-md p-4 flex flex-col items-center justify-center">
            <h4 class="text-xs sm:text-sm font-semibold mb-2">Data Penduduk Desa</h4>
            <div class="w-32 h-32 sm:w-40 sm:h-40 relative">
                <svg class="w-full h-full" viewbox="0 0 36 36">
                    <circle class="text-gray-300" cx="18" cy="18" fill="transparent" r="15" stroke="currentColor" stroke-width="3"></circle>
                    <circle class="text-pink-500" cx="18" cy="18" fill="transparent" r="15" stroke="currentColor" stroke-dasharray="75, 100" stroke-linecap="round" stroke-width="3" transform="rotate(-90 18 18)"></circle>
                </svg>
                <div class="absolute inset-0 flex flex-col items-center justify-center text-xs font-semibold text-gray-700">
                    <span>Laki-Laki</span>
                    <span class="text-pink-500 font-bold">Perempuan</span>
                    <span class="mt-1 text-[10px] text-gray-400">Total Penduduk : 350</span>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Jadwal Sholat Section -->
    <section class="max-w-7xl mx-auto px-4 sm:px-8 py-4">
        <div class="bg-white rounded-lg shadow-md border border-[#1dbf4a] flex flex-col sm:flex-row items-center sm:items-stretch">
            <div class="bg-[#1dbf4a] text-white rounded-t-lg sm:rounded-l-lg sm:rounded-tr-none flex items-center justify-center px-4 sm:px-6 py-3 sm:py-4 w-full sm:w-64">
                <i class="fas fa-moon text-xl sm:text-2xl mr-2"></i>
                <div>
                    <p class="text-xs">Jadwal Sholat di RRDesa.id</p>
                </div>
            </div>
            <div class="flex flex-wrap sm:flex-nowrap justify-between flex-grow px-4 py-3 gap-2 sm:gap-4 w-full">
                <div class="text-center w-14 sm:w-16 md:w-20">
                    <p class="text-xs font-semibold">Imsak</p>
                    <p class="text-sm font-bold">04:32</p>
                </div>
                <div class="text-center w-14 sm:w-16 md:w-20">
                    <p class="text-xs font-semibold">Subuh</p>
                    <p class="text-sm font-bold">04:40</p>
                </div>
                <div class="text-center w-14 sm:w-16 md:w-20">
                    <p class="text-xs font-semibold">Dzuhur</p>
                    <p class="text-sm font-bold">11:59</p>
                </div>
                <div class="text-center w-14 sm:w-16 md:w-20">
                    <p class="text-xs font-semibold">Ashar</p>
                    <p class="text-sm font-bold">15:20</p>
                </div>
                <div class="text-center w-14 sm:w-16 md:w-20">
                    <p class="text-xs font-semibold">Maghrib</p>
                    <p class="text-sm font-bold">17:56</p>
                </div>
                <div class="text-center w-14 sm:w-16 md:w-20">
                    <p class="text-xs font-semibold">Isya</p>
                    <p class="text-sm font-bold">19:07</p>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Aparatur Desa Section -->
    <section class="max-w-7xl mx-auto px-4 sm:px-8 py-6 sm:py-8 bg-[#e6f0f0] rounded-t-3xl">
        <div class="max-w-4xl mx-auto">
            <h3 class="text-xs sm:text-sm font-semibold text-[#1dbf4a] mb-1 border-l-4 border-orange-400 pl-2">
                Sekilas Pemimpin Desa
            </h3>
            <?php if($aparatur->count()): ?>
                <h2 class="font-robotoslab font-semibold text-base sm:text-lg mb-4">
                    <?php echo e($aparatur->first()->nama); ?>

                </h2>
                <p class="text-xs text-gray-700 mb-6 sm:mb-8 leading-relaxed">
                    <?php echo e($aparatur->first()->jabatan); ?>

                </p>
                <div class="mb-8 sm:mb-12">
                    <?php if($aparatur->first()->foto): ?>
                        <img alt="Signature of the village leader" class="mx-auto w-32 sm:w-40" src="<?php echo e(asset($aparatur->first()->foto)); ?>"/>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
        <div class="max-w-6xl mx-auto grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 gap-3 sm:gap-6">
            <?php $__currentLoopData = $aparatur; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="bg-[#1dbf4a] rounded-lg p-3 sm:p-4 flex flex-col items-center">
                    <?php if($item->foto): ?>
                        <img alt="Portrait of <?php echo e($item->nama); ?>" class="rounded-lg mb-2 w-20 h-24 sm:w-24 sm:h-28 md:w-28 md:h-32 lg:w-32 lg:h-36 object-cover" src="<?php echo e(asset($item->foto)); ?>"/>
                    <?php endif; ?>
                    <p class="text-xs text-center text-white font-semibold"><?php echo e($item->nama); ?></p>
                    <p class="text-[9px] text-white text-center"><?php echo e($item->jabatan); ?></p>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </section>
    
    <!-- Berita Desa Section -->
    <section class="max-w-7xl mx-auto px-4 sm:px-8 py-6 sm:py-8">
        <h3 class="text-xs sm:text-sm font-semibold text-[#1dbf4a] mb-1 border-l-4 border-orange-400 pl-2">
            Berita Desa
        </h3>
        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-3 sm:gap-4">
            <?php $__currentLoopData = $berita; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <article class="relative rounded-lg overflow-hidden shadow-md flex flex-col">
                    <img alt="News image" class="w-full h-32 sm:h-36 object-cover" src="<?php echo e($item->gambar ? asset($item->gambar) : 'https://storage.googleapis.com/a1aa/image/e8386500-9792-4430-6e34-b659c6470a30.jpg'); ?>"/>
                    <div class="absolute top-2 right-2 bg-orange-500 text-white text-xs font-semibold px-2 py-0.5 rounded">
                        NEW!!
                    </div>
                    <div class="p-3 flex flex-col flex-grow">
                        <h4 class="text-xs font-semibold text-white bg-black bg-opacity-70 p-1 rounded mb-1">
                            <?php echo e(Str::limit($item->judul, 40)); ?>

                        </h4>
                        <p class="text-[9px] text-gray-700 flex-grow overflow-hidden">
                            <?php echo e(Str::limit($item->isi, 100)); ?>

                        </p>
                        <div class="flex justify-between items-center mt-2">
                            <div class="text-[8px] text-gray-400 flex items-center space-x-1">
                                <i class="far fa-clock"></i>
                                <span><?php echo e($item->created_at->format('d/m/Y')); ?></span>
                            </div>
                            <button class="bg-orange-500 hover:bg-orange-600 text-white text-xs font-semibold rounded-full px-2 sm:px-3 py-1" type="button">
                                Baca Berita
                            </button>
                        </div>
                    </div>
                </article>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </section>
    
    <!-- Galeri Kegiatan Desa Section -->
    <section class="max-w-7xl mx-auto px-4 sm:px-8 py-6 sm:py-8">
        <h3 class="text-xs sm:text-sm font-semibold text-[#1dbf4a] mb-1 border-l-4 border-orange-400 pl-2">
            Galeri Kegiatan Desa
        </h3>
        <div class="bg-[#e6f0f0] rounded-lg h-32 sm:h-48">
        </div>
    </section>
    
    <!-- Transparansi Anggaran Section -->
    <section class="max-w-7xl mx-auto px-4 sm:px-8 py-6 sm:py-8">
        <h4 class="text-center text-xs text-gray-600 mb-4 sm:mb-6">
            Transparansi Anggaran
        </h4>
        <div class="flex flex-col sm:flex-row justify-center gap-4">
            <div class="bg-white rounded-lg shadow-md border border-orange-400 w-full sm:w-64 p-4 flex flex-col items-center">
                <p class="text-xs font-semibold mb-2">APBDes 2023 Pendapatan</p>
                <svg class="w-20 h-20 sm:w-24 sm:h-24 mb-2" viewbox="0 0 36 36">
                    <circle class="text-gray-300" cx="18" cy="18" fill="transparent" r="15" stroke="currentColor" stroke-width="3"></circle>
                    <circle class="text-gray-400" cx="18" cy="18" fill="transparent" r="15" stroke="currentColor" stroke-dasharray="0, 100" stroke-linecap="round" stroke-width="3" transform="rotate(-90 18 18)"></circle>
                </svg>
                <p class="text-xs text-gray-600 text-center">
                    Rp 0<br/>Total : Rp. 827186422
                </p>
            </div>
            <div class="bg-white rounded-lg shadow-md border border-orange-400 w-full sm:w-64 p-4 flex flex-col items-center">
                <p class="text-xs font-semibold mb-2">APBDes 2023 Pelaksanaan</p>
                <svg class="w-20 h-20 sm:w-24 sm:h-24 mb-2" viewbox="0 0 36 36">
                    <circle class="text-gray-300" cx="18" cy="18" fill="transparent" r="15" stroke="currentColor" stroke-width="3"></circle>
                    <circle class="text-gray-400" cx="18" cy="18" fill="transparent" r="15" stroke="currentColor" stroke-dasharray="0, 100" stroke-linecap="round" stroke-width="3" transform="rotate(-90 18 18)"></circle>
                </svg>
                <p class="text-xs text-gray-600 text-center">
                    Rp 0<br/>Total : Rp. 1024255657
                </p>
            </div>
            <div class="bg-white rounded-lg shadow-md border border-orange-400 w-full sm:w-64 p-4 flex flex-col items-center">
                <p class="text-xs font-semibold mb-2">APBDes 2023 Pembelanjaan</p>
                <svg class="w-20 h-20 sm:w-24 sm:h-24 mb-2" viewbox="0 0 36 36">
                    <circle class="text-gray-300" cx="18" cy="18" fill="transparent" r="15" stroke="currentColor" stroke-width="3"></circle>
                    <circle class="text-gray-400" cx="18" cy="18" fill="transparent" r="15" stroke="currentColor" stroke-dasharray="0, 100" stroke-linecap="round" stroke-width="3" transform="rotate(-90 18 18)"></circle>
                </svg>
                <p class="text-xs text-gray-600 text-center">
                    Rp 0<br/>Total : Rp. 994212000
                </p>
            </div>
        </div>
    </section>
    
    <!-- Program Sinergi Section -->
    <section class="max-w-7xl mx-auto px-4 sm:px-8 py-6 sm:py-8 bg-[#e6f0f0] rounded-lg text-center">
        <h4 class="text-xs text-gray-600 mb-4">Program Sinergi</h4>
        <div class="flex justify-center space-x-1">
            <span class="w-1.5 h-1.5 rounded-full bg-[#1dbf4a]"></span>
            <span class="w-1.5 h-1.5 rounded-full bg-[#1dbf4a]"></span>
            <span class="w-1.5 h-1.5 rounded-full bg-[#1dbf4a]"></span>
            <span class="w-1.5 h-1.5 rounded-full bg-[#1dbf4a]"></span>
            <span class="w-1.5 h-1.5 rounded-full bg-[#1dbf4a]"></span>
            <span class="w-1.5 h-1.5 rounded-full bg-[#1dbf4a]"></span>
            <span class="w-1.5 h-1.5 rounded-full bg-[#1dbf4a]"></span>
        </div>
    </section>
    
    <!-- Pengaduan Desa Section -->
    <section class="max-w-7xl mx-auto px-4 sm:px-8 py-6 sm:py-8">
        <div class="bg-gradient-to-r from-[#0f9d58] to-[#1dbf4a] rounded-lg p-4 sm:p-6 text-white flex flex-col sm:flex-row items-center justify-between gap-4">
            <div class="max-w-xl text-center sm:text-left">
                <h4 class="font-semibold text-sm mb-2">Pengaduan Desa</h4>
                <p class="text-xs leading-relaxed">
                    Apabila Anda Memiliki Keluhan dan Dan Permasalahan bisa klik button di bawah ini ! Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed egestas felis nec massa ornare blandit.
                </p>
            </div>
            <button class="bg-orange-500 hover:bg-orange-600 text-white text-xs font-semibold rounded-full px-4 sm:px-5 py-2 whitespace-nowrap" type="button">
                Buat Pengaduan
            </button>
            <img alt="Illustration of people and documents" class="w-20 h-auto sm:w-28" src="https://storage.googleapis.com/a1aa/image/5dfc7093-859d-4cc4-1a41-cdc3434a170a.jpg"/>
        </div>
    </section>
    
    <!-- Footer -->
    <footer class="bg-[#1dbf4a] text-white py-8 sm:py-10">
        <div class="max-w-7xl mx-auto px-4 sm:px-8 grid grid-cols-1 md:grid-cols-3 gap-6 sm:gap-8">
            <div class="text-center md:text-left">
                <div class="flex items-center justify-center md:justify-start space-x-2 mb-3">
                    <?php if($settings['logo_url'] ?? false): ?>
                        <img alt="RRDesa logo" class="w-10 h-10 sm:w-12 sm:h-12 object-contain" src="<?php echo e(asset($settings['logo_url'])); ?>"/>
                    <?php else: ?>
                        <div class="w-10 h-10 sm:w-12 sm:h-12 bg-white bg-opacity-20 rounded-lg flex items-center justify-center">
                            <span class="text-white font-bold text-sm sm:text-base">RR</span>
                        </div>
                    <?php endif; ?>
                    <span class="font-robotoslab font-semibold text-base sm:text-lg">RRDesa.</span>
                </div>
                <p class="text-xs max-w-xs mx-auto md:mx-0">Kel. Kalibaru Kec. Cilodong Kota Depok</p>
                <div class="mt-4 flex justify-center md:justify-start">
                    <img alt="Google Play Store badge" class="w-24 sm:w-32" src="https://storage.googleapis.com/a1aa/image/2fefb4ee-182f-433b-5bb5-e078bdcdc8a7.jpg"/>
                </div>
            </div>
            <div class="text-xs text-center md:text-left">
                <h5 class="font-semibold mb-3">Menu Lainnya</h5>
                <ul class="space-y-2">
                    <li><a class="hover:underline" href="<?php echo e(route('pengumuman.list')); ?>">Pengumuman</a></li>
                    <li><a class="hover:underline" href="#visi-misi">Visi & Misi</a></li>
                    <li><a class="hover:underline" href="#sejarah">Sejarah Desa</a></li>
                    <li><a class="hover:underline" href="<?php echo e(route('aparatur.list')); ?>">Aparatur Desa</a></li>
                    <li><a class="hover:underline" href="#produk">Produk Desa</a></li>
                </ul>
            </div>
            <div class="text-xs text-center md:text-left">
                <h5 class="font-semibold mb-3">Hubungi Kami</h5>
                <div class="flex justify-center md:justify-start space-x-3 mb-3 text-base">
                    <a aria-label="WhatsApp" class="hover:text-gray-200" href="#"><i class="fab fa-whatsapp"></i></a>
                    <a aria-label="Facebook" class="hover:text-gray-200" href="#"><i class="fab fa-facebook-f"></i></a>
                    <a aria-label="Twitter" class="hover:text-gray-200" href="#"><i class="fab fa-twitter"></i></a>
                    <a aria-label="YouTube" class="hover:text-gray-200" href="#"><i class="fab fa-youtube"></i></a>
                </div>
                <p class="mb-1 flex items-center justify-center md:justify-start space-x-2">
                    <i class="fas fa-envelope"></i>
                    <span><?php echo e($settings['email'] ?? 'secretariat@desarrdigital.id'); ?></span>
                </p>
                <p class="flex items-center justify-center md:justify-start space-x-2">
                    <i class="fas fa-phone-alt"></i>
                    <span>WA: <?php echo e($settings['wa_number'] ?? '+62 812 9496 2546'); ?></span>
                </p>
            </div>
        </div>
        <p class="text-center text-xs mt-6 sm:mt-8 text-white/80">
            RRDesa Template © All rights reserved. | Made with ♥ by rrdesign.id
        </p>
    </footer>
    
    <!-- Mobile Menu JavaScript -->
    <script>
        document.getElementById('mobile-menu-btn').addEventListener('click', function() {
            const mobileMenu = document.getElementById('mobile-menu');
            mobileMenu.classList.toggle('hidden');
        });
    </script>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\website-desa\resources\views/home.blade.php ENDPATH**/ ?>