

<?php $__env->startSection('title', 'Kelola Berita'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <div class="row mb-4">
        <div class="col-12 d-flex justify-content-between align-items-center">
            <h2 class="mb-0">Kelola Berita</h2>
            <a href="<?php echo e(route('admin.berita.create')); ?>" class="btn btn-success">
                <i class="fas fa-plus me-2"></i>Tambah Berita
            </a>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <?php if(isset($beritas) && $beritas->count() > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-hover align-middle mb-0">
                                <thead class="thead-light">
                                    <tr>
                                        <th>Judul</th>
                                        <th>Penulis</th>
                                        <th>Tanggal</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $beritas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $berita): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($berita->judul); ?></td>
                                        <td><?php echo e($berita->author); ?></td>
                                        <td><?php echo e($berita->created_at ? $berita->created_at->format('d/m/Y') : '-'); ?></td>
                                        <td>
                                            <a href="<?php echo e(route('admin.berita.edit', $berita)); ?>" class="btn btn-sm btn-primary"><i class="fas fa-edit"></i></a>
                                            <form action="<?php echo e(route('admin.berita.destroy', $berita)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Yakin hapus berita ini?')">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-sm btn-danger"><i class="fas fa-trash"></i></button>
                                            </form>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="mt-3">
                            <?php echo e($beritas->links()); ?>

                        </div>
                    <?php else: ?>
                        <div class="text-center py-5">
                            <i class="fas fa-newspaper fa-4x text-secondary mb-3"></i>
                            <h5 class="mb-2">Belum ada berita</h5>
                            <p class="text-muted mb-4">Mulai dengan menambahkan berita pertama Anda.</p>
                            <a href="<?php echo e(route('admin.berita.create')); ?>" class="btn btn-success">
                                Tambah Berita Pertama
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\website-desa\resources\views/admin/berita/index.blade.php ENDPATH**/ ?>