<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class AddTestData extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'data:add-test';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Add test data for UMKM and Objek Wisata with Sirnajaya locations';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Adding test data for Desa Sirnajaya...');

        try {
            // Add penduduk data first
            $pendudukId = DB::table('penduduk')->insertGetId([
                'nik' => '3203012345678901',
                'no_kk' => '3203012345678900',
                'nama' => 'Sari Wulandari',
                'jenis_kelamin' => 'P',
                'alamat' => 'Kampung Sirnajaya',
                'tempat_lahir' => 'Cianjur',
                'tanggal_lahir' => '1980-05-15',
                'agama' => 'Islam',
                'status_perkawinan' => 'Kawin',
                'pekerjaan' => 'Wiraswasta',
                'kewarganegaraan' => 'WNI',
                'created_at' => now(),
                'updated_at' => now()
            ]);
            $this->info('✓ Penduduk data added (ID: ' . $pendudukId . ')');

            // Add UMKM data
            $umkmData = [
                [
                    'nama_umkm' => 'Warung Makan Bu Sari',
                    'kategori' => 'makanan_minuman',
                    'pemilik_id' => $pendudukId,
                    'user_id' => 1,
                    'deskripsi' => 'Warung makan tradisional dengan menu khas Sunda. Spesialisasi nasi liwet, pepes ikan, dan sayur asem yang lezat.',
                    'alamat' => 'Kampung Sirnajaya RT 01/RW 01, Desa Sirnajaya',
                    'nomor_telepon' => '081234567890',
                    'email' => 'busari@example.com',
                    'status' => 'aktif',
                    'is_verified' => true,
                    'latitude' => -6.7175,
                    'longitude' => 107.1430,
                    'skala_usaha' => 'mikro',
                    'slug' => 'warung-makan-bu-sari',
                    'created_at' => now(),
                    'updated_at' => now()
                ],
                [
                    'nama_umkm' => 'Kerajinan Bambu Pak Joko',
                    'kategori' => 'kerajinan_tangan',
                    'pemilik_id' => $pendudukId,
                    'user_id' => 1,
                    'deskripsi' => 'Kerajinan bambu berkualitas tinggi dengan desain modern dan tradisional. Menerima pesanan custom untuk furniture dan dekorasi rumah.',
                    'alamat' => 'Kampung Bojong RT 02/RW 01, Desa Sirnajaya',
                    'nomor_telepon' => '081234567891',
                    'email' => 'bambukreatif@example.com',
                    'status' => 'aktif',
                    'is_verified' => true,
                    'latitude' => -6.7180,
                    'longitude' => 107.1440,
                    'skala_usaha' => 'mikro',
                    'slug' => 'kerajinan-bambu-pak-joko',
                    'created_at' => now(),
                    'updated_at' => now()
                ],
                [
                    'nama_umkm' => 'Tani Madu Sirnajaya',
                    'kategori' => 'pertanian_perkebunan',
                    'pemilik_id' => $pendudukId,
                    'user_id' => 1,
                    'deskripsi' => 'Produksi madu murni dari peternakan lebah lokal. Madu berkualitas tinggi tanpa campuran bahan kimia, langsung dari peternak.',
                    'alamat' => 'Kampung Puncak RT 03/RW 02, Desa Sirnajaya',
                    'nomor_telepon' => '081234567892',
                    'email' => 'tanimadu@example.com',
                    'status' => 'aktif',
                    'is_verified' => true,
                    'latitude' => -6.7170,
                    'longitude' => 107.1420,
                    'skala_usaha' => 'mikro',
                    'slug' => 'tani-madu-sirnajaya',
                    'created_at' => now(),
                    'updated_at' => now()
                ],
                [
                    'nama_umkm' => 'Toko Kelontong Ibu Ani',
                    'kategori' => 'perdagangan_retail',
                    'pemilik_id' => $pendudukId,
                    'user_id' => 1,
                    'deskripsi' => 'Toko kelontong lengkap menyediakan kebutuhan sehari-hari warga desa. Melayani dengan ramah dan harga terjangkau.',
                    'alamat' => 'Kampung Cigentis RT 01/RW 02, Desa Sirnajaya',
                    'nomor_telepon' => '081234567893',
                    'email' => 'tokoani@example.com',
                    'status' => 'aktif',
                    'is_verified' => true,
                    'latitude' => -6.7185,
                    'longitude' => 107.1415,
                    'skala_usaha' => 'mikro',
                    'slug' => 'toko-kelontong-ibu-ani',
                    'created_at' => now(),
                    'updated_at' => now()
                ],
                [
                    'nama_umkm' => 'Konveksi Sirnajaya',
                    'kategori' => 'fashion_tekstil',
                    'pemilik_id' => $pendudukId,
                    'user_id' => 1,
                    'deskripsi' => 'Konveksi pakaian dengan kualitas jahitan terbaik. Menerima pesanan seragam, kaos, dan pakaian custom dengan harga kompetitif.',
                    'alamat' => 'Kampung Situ RT 02/RW 02, Desa Sirnajaya',
                    'nomor_telepon' => '081234567894',
                    'email' => 'konveksi@example.com',
                    'status' => 'aktif',
                    'is_verified' => true,
                    'latitude' => -6.7165,
                    'longitude' => 107.1435,
                    'skala_usaha' => 'mikro',
                    'slug' => 'konveksi-sirnajaya',
                    'created_at' => now(),
                    'updated_at' => now()
                ],
                [
                    'nama_umkm' => 'Bengkel Motor Sirnajaya',
                    'kategori' => 'jasa_layanan',
                    'pemilik_id' => $pendudukId,
                    'user_id' => 1,
                    'deskripsi' => 'Bengkel motor terpercaya dengan mekanik berpengalaman. Melayani servis rutin, perbaikan, dan ganti spare part motor.',
                    'alamat' => 'Jalan Raya Sirnajaya, Kampung Sirnajaya RT 01/RW 01',
                    'nomor_telepon' => '081234567895',
                    'email' => 'bengkel@example.com',
                    'status' => 'aktif',
                    'is_verified' => true,
                    'latitude' => -6.7190,
                    'longitude' => 107.1425,
                    'skala_usaha' => 'mikro',
                    'slug' => 'bengkel-motor-sirnajaya',
                    'created_at' => now(),
                    'updated_at' => now()
                ]
            ];

            foreach ($umkmData as $data) {
                DB::table('umkm')->insert($data);
            }
            $this->info('✓ ' . count($umkmData) . ' UMKM records added');

            // Add Objek Wisata data
            $wisataData = [
                [
                    'nama' => 'Air Terjun Sirnajaya',
                    'slug' => 'air-terjun-sirnajaya',
                    'kategori' => 'Wisata Alam',
                    'deskripsi' => 'Air terjun alami dengan ketinggian sekitar 25 meter yang dikelilingi oleh hutan bambu dan pepohonan rindang. Lokasi yang sejuk dan asri cocok untuk piknik keluarga.',
                    'alamat' => 'Kampung Sirnajaya, Desa Sirnajaya, Kecamatan Sukamakmur',
                    'latitude' => -6.7190,
                    'longitude' => 107.1450,
                    'jam_buka' => '07:00',
                    'jam_tutup' => '17:00',
                    'harga_tiket' => 5000,
                    'fasilitas' => json_encode(['Tempat Parkir', 'Warung Makan', 'Toilet', 'Gazebo']),
                    'kontak_person' => '081234567890',
                    'status' => 'aktif',
                    'is_featured' => true,
                    'rating_rata_rata' => 4.5,
                    'jumlah_ulasan' => 25,
                    'view_count' => 150,
                    'created_at' => now(),
                    'updated_at' => now()
                ],
                [
                    'nama' => 'Kebun Teh Sirnajaya',
                    'slug' => 'kebun-teh-sirnajaya',
                    'kategori' => 'Agrowisata',
                    'deskripsi' => 'Perkebunan teh tradisional dengan pemandangan pegunungan yang menakjubkan. Pengunjung dapat melihat proses pemetikan teh dan menikmati teh segar langsung dari kebun.',
                    'alamat' => 'Kampung Bojong, Desa Sirnajaya, Kecamatan Sukamakmur',
                    'latitude' => -6.7160,
                    'longitude' => 107.1410,
                    'jam_buka' => '06:00',
                    'jam_tutup' => '18:00',
                    'harga_tiket' => 10000,
                    'fasilitas' => json_encode(['Tempat Parkir', 'Cafe Teh', 'Toilet', 'Toko Souvenir', 'Spot Foto']),
                    'kontak_person' => '081234567891',
                    'status' => 'aktif',
                    'is_featured' => true,
                    'rating_rata_rata' => 4.7,
                    'jumlah_ulasan' => 42,
                    'view_count' => 230,
                    'created_at' => now(),
                    'updated_at' => now()
                ],
                [
                    'nama' => 'Curug Cigentis',
                    'slug' => 'curug-cigentis',
                    'kategori' => 'Wisata Alam',
                    'deskripsi' => 'Air terjun tersembunyi dengan kolam alami yang jernih. Akses menuju lokasi melalui trekking ringan sekitar 15 menit dari jalan utama.',
                    'alamat' => 'Kampung Cigentis, Desa Sirnajaya, Kecamatan Sukamakmur',
                    'latitude' => -6.7200,
                    'longitude' => 107.1380,
                    'jam_buka' => '08:00',
                    'jam_tutup' => '16:00',
                    'harga_tiket' => 3000,
                    'fasilitas' => json_encode(['Tempat Parkir', 'Warung Sederhana', 'Toilet']),
                    'kontak_person' => '081234567892',
                    'status' => 'aktif',
                    'is_featured' => false,
                    'rating_rata_rata' => 4.2,
                    'jumlah_ulasan' => 18,
                    'view_count' => 95,
                    'created_at' => now(),
                    'updated_at' => now()
                ],
                [
                    'nama' => 'Puncak Gunung Sirnajaya',
                    'slug' => 'puncak-gunung-sirnajaya',
                    'kategori' => 'Wisata Alam',
                    'deskripsi' => 'Puncak dengan pemandangan 360 derajat yang spektakuler. Cocok untuk hiking dan menikmati sunrise/sunset. Ketinggian sekitar 1.200 mdpl.',
                    'alamat' => 'Kampung Puncak, Desa Sirnajaya, Kecamatan Sukamakmur',
                    'latitude' => -6.7120,
                    'longitude' => 107.1470,
                    'jam_buka' => '05:00',
                    'jam_tutup' => '19:00',
                    'harga_tiket' => 15000,
                    'fasilitas' => json_encode(['Tempat Parkir', 'Pos Jaga', 'Toilet', 'Warung', 'Camping Ground']),
                    'kontak_person' => '081234567893',
                    'status' => 'aktif',
                    'is_featured' => true,
                    'rating_rata_rata' => 4.8,
                    'jumlah_ulasan' => 67,
                    'view_count' => 320,
                    'created_at' => now(),
                    'updated_at' => now()
                ],
                [
                    'nama' => 'Situ Sirnajaya',
                    'slug' => 'situ-sirnajaya',
                    'kategori' => 'Wisata Alam',
                    'deskripsi' => 'Danau kecil alami yang dikelilingi perbukitan hijau. Tempat yang tenang untuk memancing dan bersantai bersama keluarga.',
                    'alamat' => 'Kampung Situ, Desa Sirnajaya, Kecamatan Sukamakmur',
                    'latitude' => -6.7180,
                    'longitude' => 107.1430,
                    'jam_buka' => '06:00',
                    'jam_tutup' => '18:00',
                    'harga_tiket' => 5000,
                    'fasilitas' => json_encode(['Tempat Parkir', 'Gazebo', 'Toilet', 'Penyewaan Perahu']),
                    'kontak_person' => '081234567894',
                    'status' => 'aktif',
                    'is_featured' => false,
                    'rating_rata_rata' => 4.3,
                    'jumlah_ulasan' => 31,
                    'view_count' => 180,
                    'created_at' => now(),
                    'updated_at' => now()
                ]
            ];

            foreach ($wisataData as $data) {
                DB::table('objek_wisata')->insert($data);
            }
            $this->info('✓ ' . count($wisataData) . ' Objek Wisata records added');

            $this->info('');
            $this->info('🎉 All test data added successfully!');
            $this->info('- 1 Penduduk record');
            $this->info('- ' . count($umkmData) . ' UMKM records');
            $this->info('- ' . count($wisataData) . ' Objek Wisata records');

            // Show summary
            $this->info('');
            $this->info('📊 Current Data Summary:');
            $this->info('UMKM Count: ' . DB::table('umkm')->count());
            $this->info('Objek Wisata Count: ' . DB::table('objek_wisata')->count());
            $this->info('UMKM with coordinates: ' . DB::table('umkm')->whereNotNull('latitude')->whereNotNull('longitude')->count());
            $this->info('Wisata with coordinates: ' . DB::table('objek_wisata')->whereNotNull('latitude')->whereNotNull('longitude')->count());

        } catch (\Exception $e) {
            $this->error('❌ Error: ' . $e->getMessage());
            return 1;
        }

        return 0;
    }
}
