<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class CreateTestAdmin extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'make:test-admin';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create a test admin user';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $email = 'admin@test.com';
        $password = 'admin123';
        
        // Check if user already exists
        $existingUser = User::where('email', $email)->first();
        
        if ($existingUser) {
            $this->info("Admin user already exists: {$email}");
            $this->info("Password: {$password}");
            return;
        }
        
        // Create admin user
        $user = User::create([
            'name' => 'Test Admin',
            'email' => $email,
            'password' => Hash::make($password),
            'role' => 'admin',
            'is_active' => true,
        ]);
        
        $this->info("✅ Test admin user created successfully!");
        $this->info("Email: {$email}");
        $this->info("Password: {$password}");
        $this->info("Role: admin");
        $this->info("");
        $this->info("You can now login at: http://127.0.0.1:8000/login");
    }
}
