<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\CaptchaService;
use Illuminate\Support\Facades\Log;

class CaptchaController extends Controller
{
    /**
     * Generate CAPTCHA image for admin login
     */
    public function generateCaptcha()
    {
        try {
            Log::info('CAPTCHA Generation Attempt');
            
            // Check if GD is available
            if (!extension_loaded('gd')) {
                throw new \Exception('GD extension is not loaded');
            }
            
            // Check if CaptchaBuilder exists
            if (!class_exists('\Gregwar\Captcha\CaptchaBuilder')) {
                throw new \Exception('CaptchaBuilder class not found');
            }
            
            $builder = new \Gregwar\Captcha\CaptchaBuilder();
            $builder->build();
            
            $imageData = $builder->get();
            $phrase = $builder->getPhrase();
            
            if (!$imageData || strlen($imageData) == 0) {
                throw new \Exception('Failed to generate CAPTCHA image data');
            }
            
            // Store CAPTCHA phrase in session
            session(['captcha_phrase' => $phrase]);
            
            Log::info('CAPTCHA Generated Successfully', [
                'phrase' => $phrase,
                'image_size' => strlen($imageData)
            ]);
            
            return response($imageData, 200, [
                'Content-Type' => 'image/jpeg',
                'Cache-Control' => 'no-cache, no-store, must-revalidate',
                'Pragma' => 'no-cache',
                'Expires' => '0'
            ]);
        } catch (\Exception $e) {
            Log::error('CAPTCHA Generation Error', [
                'message' => $e->getMessage(),
                'file' => $e->getFile(),
                'line' => $e->getLine(),
                'trace' => $e->getTraceAsString()
            ]);
            return response('Error generating CAPTCHA: ' . $e->getMessage(), 500, [
                'Content-Type' => 'text/plain'
            ]);
        }
    }
    
    /**
     * Generate CAPTCHA image for portal login
     */
    public function generatePortalCaptcha()
    {
        try {
            Log::info('Portal CAPTCHA Generation Attempt');
            
            // Check if GD is available
            if (!extension_loaded('gd')) {
                throw new \Exception('GD extension is not loaded');
            }
            
            // Check if CaptchaBuilder exists
            if (!class_exists('\Gregwar\Captcha\CaptchaBuilder')) {
                throw new \Exception('CaptchaBuilder class not found');
            }
            
            $builder = new \Gregwar\Captcha\CaptchaBuilder();
            $builder->build();
            
            $imageData = $builder->get();
            $phrase = $builder->getPhrase();
            
            if (!$imageData || strlen($imageData) == 0) {
                throw new \Exception('Failed to generate CAPTCHA image data');
            }
            
            // Store CAPTCHA phrase in session
            session(['captcha_phrase' => $phrase]);
            
            Log::info('Portal CAPTCHA Generated Successfully', [
                'phrase' => $phrase,
                'image_size' => strlen($imageData)
            ]);
            
            return response($imageData, 200, [
                'Content-Type' => 'image/jpeg',
                'Cache-Control' => 'no-cache, no-store, must-revalidate',
                'Pragma' => 'no-cache',
                'Expires' => '0'
            ]);
        } catch (\Exception $e) {
            Log::error('Portal CAPTCHA Generation Error', [
                'message' => $e->getMessage(),
                'file' => $e->getFile(),
                'line' => $e->getLine(),
                'trace' => $e->getTraceAsString()
            ]);
            return response('Error generating CAPTCHA: ' . $e->getMessage(), 500, [
                'Content-Type' => 'text/plain'
            ]);
        }
    }
}
