<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class RtRwMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Check if user is authenticated
        if (!Auth::check()) {
            return redirect()->route('login')->with('error', 'Silakan login terlebih dahulu.');
        }

        $user = Auth::user();

        // Allow access if user is superadmin or admin desa
        // Check role directly from user properties
        if ($user->role === 'superadmin' || $user->role === 'super_admin' || 
            $user->role === 'admin_desa' || $user->is_admin) {
            return $next($request);
        }

        // Check if user has RT/RW role
        // Check role directly from user properties
        if (in_array($user->role, ['ketua_rt', 'rt', 'ketua_rw', 'rw', 'ketua_dusun', 'dusun'])) {
            // Check if user has wilayah kerja configured
            if (!$user->dusun && !$user->rt && !$user->rw) {
                return redirect()->route('dashboard')->with('error', 'Wilayah kerja belum dikonfigurasi. Silakan hubungi administrator.');
            }
            
            return $next($request);
        }

        // Deny access for other roles
        return redirect()->route('dashboard')->with('error', 'Anda tidak memiliki akses ke fitur ini.');
    }
}
