<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AnggotaKeluarga extends Model
{
    use HasFactory;

    protected $table = 'anggota_keluarga';

    protected $fillable = [
        'no_kk',
        'nik',
        'status_keluarga'
    ];

    // Relationships
    public function keluarga()
    {
        return $this->belongsTo(Keluarga::class, 'no_kk', 'no_kk');
    }

    public function penduduk()
    {
        return $this->belongsTo(Penduduk::class, 'nik', 'nik');
    }

    // Scopes
    public function scopeKepalaKeluarga($query)
    {
        return $query->where('status_keluarga', 'Kepala Keluarga');
    }

    public function scopeAnak($query)
    {
        return $query->where('status_keluarga', 'Anak');
    }
} 
