<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Role extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'display_name',
        'description',
        'permissions',
        'is_active'
    ];

    protected $casts = [
        'permissions' => 'array',
        'is_active' => 'boolean'
    ];

    /**
     * Get users with this role
     */
    public function users()
    {
        return $this->hasMany(User::class);
    }

    /**
     * Check if role has permission
     */
    public function hasPermission($permission)
    {
        if (!$this->permissions) {
            return false;
        }
        
        return in_array($permission, $this->permissions);
    }

    /**
     * Default permissions list
     */
    public static function getAvailablePermissions()
    {
        return [
            'dashboard' => 'Akses Dashboard',
            'penduduk.view' => 'Lihat Data Penduduk',
            'penduduk.create' => 'Tambah Data Penduduk',
            'penduduk.edit' => 'Edit Data Penduduk',
            'penduduk.delete' => 'Hapus Data Penduduk',
            'keluarga.view' => 'Lihat Data Keluarga',
            'keluarga.create' => 'Tambah Data Keluarga',
            'keluarga.edit' => 'Edit Data Keluarga',
            'keluarga.delete' => 'Hapus Data Keluarga',
            'surat.view' => 'Lihat Pelayanan Surat',
            'surat.create' => 'Buat Pelayanan Surat',
            'surat.edit' => 'Edit Pelayanan Surat',
            'surat.delete' => 'Hapus Pelayanan Surat',
            'pengaduan.view' => 'Lihat Pengaduan',
            'pengaduan.create' => 'Tambah Pengaduan',
            'pengaduan.edit' => 'Edit Pengaduan',
            'pengaduan.delete' => 'Hapus Pengaduan',
            'bantuan.view' => 'Lihat Bantuan Sosial',
            'bantuan.create' => 'Tambah Bantuan Sosial',
            'bantuan.edit' => 'Edit Bantuan Sosial',
            'bantuan.delete' => 'Hapus Bantuan Sosial',
            'berita.view' => 'Lihat Berita',
            'berita.create' => 'Tambah Berita',
            'berita.edit' => 'Edit Berita',
            'berita.delete' => 'Hapus Berita',
            'peta.view' => 'Lihat Peta',
            'settings.view' => 'Lihat Pengaturan',
            'settings.edit' => 'Edit Pengaturan',
            'roles.view' => 'Lihat Role Management',
            'roles.create' => 'Tambah Role',
            'roles.edit' => 'Edit Role',
            'roles.delete' => 'Hapus Role',
            'users.view' => 'Lihat Data User',
            'users.create' => 'Tambah User',
            'users.edit' => 'Edit User',
            'users.delete' => 'Hapus User'
        ];
    }
} 
