<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        // Register PaymentGatewayService
        $this->app->singleton(\App\Services\PaymentGatewayService::class, function ($app) {
            return new \App\Services\PaymentGatewayService();
        });

        // Register PaymentMethodSyncService
        $this->app->singleton(\App\Services\PaymentMethodSyncService::class, function ($app) {
            return new \App\Services\PaymentMethodSyncService(
                $app->make(\App\Services\PaymentGatewayService::class)
            );
        });
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
    }
}
