#!/bin/bash

# =================================================================
# CLOUDFLARE SETUP SCRIPT UNTUK APLIKASI DESA
# =================================================================

echo "🌐 CLOUDFLARE SETUP UNTUK APLIKASI DESA"
echo "========================================"

# Colors for output
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
BLUE='\033[0;34m'
NC='\033[0m' # No Color

# Function to print colored output
print_status() {
    echo -e "${GREEN}✅ $1${NC}"
}

print_warning() {
    echo -e "${YELLOW}⚠️  $1${NC}"
}

print_error() {
    echo -e "${RED}❌ $1${NC}"
}

print_info() {
    echo -e "${BLUE}ℹ️  $1${NC}"
}

# Check if running on correct directory
if [ ! -f "composer.json" ]; then
    print_error "Script harus dijalankan di root directory Laravel!"
    exit 1
fi

print_info "Memulai setup Cloudflare compatibility..."

# 1. Backup .env file
if [ -f ".env" ]; then
    cp .env .env.backup
    print_status "Backup .env file dibuat"
else
    print_warning ".env file tidak ditemukan, akan dibuat dari .env.example"
    if [ -f ".env.example" ]; then
        cp .env.example .env
    fi
fi

# 2. Add Cloudflare settings to .env
print_info "Menambahkan konfigurasi Cloudflare ke .env..."

# Check if Cloudflare settings already exist
if ! grep -q "CLOUDFLARE_ENABLED" .env; then
    cat >> .env << EOL

# ======================================
# CLOUDFLARE SETTINGS
# ======================================
CLOUDFLARE_ENABLED=true
SESSION_SECURE_COOKIE=true
SESSION_HTTP_ONLY=true
SESSION_SAME_SITE=lax

# Cloudflare Real IP
TRUSTED_PROXIES="173.245.48.0/20,103.21.244.0/22,103.22.200.0/22,103.31.4.0/22,141.101.64.0/18,108.162.192.0/18,190.93.240.0/20,188.114.96.0/20,197.234.240.0/22,198.41.128.0/17,162.158.0.0/15,104.16.0.0/13,104.24.0.0/14,172.64.0.0/13,131.0.72.0/22"
EOL
    print_status "Konfigurasi Cloudflare ditambahkan ke .env"
else
    print_warning "Konfigurasi Cloudflare sudah ada di .env"
fi

# 3. Clear cache
print_info "Membersihkan cache aplikasi..."
php artisan config:clear
php artisan cache:clear
php artisan route:clear
php artisan view:clear
print_status "Cache berhasil dibersihkan"

# 4. Test application
print_info "Testing aplikasi..."
if php artisan route:list > /dev/null 2>&1; then
    print_status "Aplikasi Laravel berjalan normal"
else
    print_error "Ada masalah dengan aplikasi Laravel"
    exit 1
fi

# 5. Show next steps
echo ""
echo "🎉 SETUP SELESAI!"
echo "=================="
echo ""
print_info "LANGKAH SELANJUTNYA:"
echo "1. 📖 Baca panduan lengkap: CLOUDFLARE_FREE_SETUP.md"
echo "2. 🌐 Daftar di https://cloudflare.com (GRATIS)"
echo "3. ➕ Add domain Anda ke Cloudflare"
echo "4. 🔄 Update nameservers di domain registrar"
echo "5. ⏰ Tunggu 2-24 jam untuk propagasi DNS"
echo "6. 🔒 Konfigurasi SSL ke mode 'Full' atau 'Full (strict)'"
echo "7. 🛡️ Setup firewall rules dasar"
echo "8. ✅ Test website dan functionality"
echo ""
print_status "Aplikasi Laravel sudah siap untuk Cloudflare!"
echo ""
print_warning "BACKUP: File .env asli disimpan sebagai .env.backup"
echo ""

# 6. Show Cloudflare benefits
echo "🚀 MANFAAT CLOUDFLARE GRATIS:"
echo "================================"
echo "✅ DDoS Protection otomatis"
echo "✅ SSL Certificate gratis"
echo "✅ CDN global (website lebih cepat)"
echo "✅ Bot protection dasar"
echo "✅ Analytics & monitoring"
echo "✅ Basic firewall rules"
echo "✅ Always online mode"
echo ""
print_info "Estimasi peningkatan: 30-50% lebih cepat!"
echo ""

# 7. Quick verification
echo "🔍 QUICK VERIFICATION:"
echo "======================"
echo "Setelah Cloudflare aktif, test dengan:"
echo "curl -I https://yourdomain.com"
echo ""
echo "Harus menampilkan header:"
echo "- server: cloudflare"
echo "- cf-ray: xxxxx-xxx"
echo ""

print_status "Setup completed successfully! 🎊"
