<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Tripay Configuration
    |--------------------------------------------------------------------------
    */

    'api_key' => env('TRIPAY_API_KEY', ''),
    'private_key' => env('TRIPAY_PRIVATE_KEY', ''),
    'merchant_code' => env('TRIPAY_MERCHANT_CODE', ''),
    'mode' => env('TRIPAY_MODE', 'sandbox'), // sandbox or production
    
    'sandbox_url' => 'https://tripay.co.id/api-sandbox',
    'production_url' => 'https://tripay.co.id/api',
    
    // Payment channels yang tersedia
    'channels' => [
        'BRIVA' => 'BRI Virtual Account',
        'BCAVA' => 'BCA Virtual Account', 
        'BNIVA' => 'BNI Virtual Account',
        'MANDIRIVA' => 'Mandiri Virtual Account',
        'BSIVA' => 'BSI Virtual Account',
        'MUAMALATVA' => 'Muamalat Virtual Account',
        'CIMBVA' => 'CIMB Virtual Account',
        'SMSVA' => 'Sinarmas Virtual Account',
        'DANAMONVA' => 'Danamon Virtual Account',
        'ALFAMART' => 'Alfamart',
        'INDOMARET' => 'Indomaret',
        'ALFAMIDI' => 'Alfamidi',
        'OVO' => 'OVO',
        'DANA' => 'DANA',
        'SHOPEEPAY' => 'ShopeePay',
        'LINKAJA' => 'LinkAja',
        'GOPAY' => 'GoPay',
        'QRIS' => 'QRIS',
        'QRIS2' => 'QRIS (Customizable)',
    ],
    
    // Callback settings
    'callback_url' => env('APP_URL') . '/tripay/callback',
    'return_url' => env('APP_URL') . '/checkout/success',
    
    // Fee settings
    'fee_customer' => true, // true = customer pays fee, false = merchant pays fee
    
    // Expiry time in minutes
    'expiry_time' => 60 * 24, // 24 hours
]; 