<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bantuan', function (Blueprint $table) {
            $table->id();
            $table->string('nik', 16);
            $table->enum('jenis_bantuan', [
                'PKH',
                'Bansos Pangan',
                'BLT Dana Desa',
                'Kartu Prakerja',
                'Bantuan Pendidikan',
                'Bantuan Kesehatan',
                'Bantuan Perumahan',
                'BPNT',
                'Lainnya'
            ]);
            $table->text('deskripsi')->nullable();
            $table->string('periode'); // misal: "Januari 2024", "2024", dll
            $table->decimal('nominal', 15, 2)->nullable();
            $table->enum('status', ['Diajukan', 'Diverifikasi', 'Diterima', 'Ditolak'])->default('Diajukan');
            $table->date('tanggal_distribusi')->nullable();
            $table->text('keterangan')->nullable();
            $table->timestamps();
            
            $table->foreign('nik')->references('nik')->on('penduduk');
            $table->index(['jenis_bantuan', 'periode', 'status']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bantuan');
    }
}; 
