<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('notifikasi_wa', function (Blueprint $table) {
            $table->id();
            $table->string('no_wa', 15);
            $table->text('pesan');
            $table->enum('jenis', [
                'surat_selesai',
                'bantuan_diterima', 
                'pengaduan_ditanggapi',
                'broadcast_berita',
                'manual'
            ]);
            $table->string('reference_id')->nullable(); // ID dari tabel terkait
            $table->string('reference_type')->nullable(); // Model yang direferensi
            $table->enum('status', ['Pending', 'Terkirim', 'Gagal'])->default('Pending');
            $table->text('response')->nullable(); // Response dari API WA
            $table->timestamp('tanggal_kirim')->nullable();
            $table->timestamps();
            
            $table->index(['status', 'jenis']);
            $table->index(['reference_type', 'reference_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('notifikasi_wa');
    }
}; 
