<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('anggota_keluarga', function (Blueprint $table) {
            // Drop existing foreign key constraint
            $table->dropForeign(['nik']);
            
            // Recreate with cascade delete
            $table->foreign('nik')->references('nik')->on('penduduk')->onDelete('cascade');
        });

        Schema::table('keluarga', function (Blueprint $table) {
            // Drop existing foreign key constraint
            $table->dropForeign(['kepala_keluarga_nik']);
            
            // Recreate with cascade delete
            $table->foreign('kepala_keluarga_nik')->references('nik')->on('penduduk')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('anggota_keluarga', function (Blueprint $table) {
            // Drop cascade constraint
            $table->dropForeign(['nik']);
            
            // Recreate without cascade delete
            $table->foreign('nik')->references('nik')->on('penduduk');
        });

        Schema::table('keluarga', function (Blueprint $table) {
            // Drop cascade constraint
            $table->dropForeign(['kepala_keluarga_nik']);
            
            // Recreate without cascade delete
            $table->foreign('kepala_keluarga_nik')->references('nik')->on('penduduk');
        });
    }
};
// 
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// 
//     https://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

