<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('penduduk', function (Blueprint $table) {
            $table->string('ayah_nik', 16)->nullable()->after('no_kk')->comment('NIK Ayah untuk relasi pohon keluarga');
            $table->string('ibu_nik', 16)->nullable()->after('ayah_nik')->comment('NIK Ibu untuk relasi pohon keluarga');
            
            // Add foreign key constraints
            $table->foreign('ayah_nik')->references('nik')->on('penduduk')->onDelete('set null');
            $table->foreign('ibu_nik')->references('nik')->on('penduduk')->onDelete('set null');
            
            // Add indexes for better performance
            $table->index('ayah_nik');
            $table->index('ibu_nik');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('penduduk', function (Blueprint $table) {
            $table->dropForeign(['ayah_nik']);
            $table->dropForeign(['ibu_nik']);
            $table->dropIndex(['ayah_nik']);
            $table->dropIndex(['ibu_nik']);
            $table->dropColumn(['ayah_nik', 'ibu_nik']);
        });
    }
};
