<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('umkm', function (Blueprint $table) {
            $table->id();
            $table->string('nama_umkm');
            $table->enum('kategori', [
                'makanan_minuman', 
                'kerajinan_tangan', 
                'fashion_tekstil', 
                'jasa_layanan', 
                'pertanian_perkebunan',
                'peternakan_perikanan',
                'teknologi_digital',
                'perdagangan_retail',
                'pariwisata_budaya',
                'lainnya'
            ]);
            $table->foreignId('pemilik_id')->constrained('penduduk', 'id')->onDelete('cascade');
            $table->text('deskripsi');
            $table->text('alamat');
            $table->string('nomor_telepon', 15)->nullable();
            $table->string('email')->nullable();
            $table->string('website')->nullable();
            $table->string('instagram')->nullable();
            $table->string('facebook')->nullable();
            $table->string('whatsapp', 15)->nullable();
            
            // Lokasi & Operasional
            $table->decimal('latitude', 10, 8)->nullable();
            $table->decimal('longitude', 11, 8)->nullable();
            $table->json('jam_operasional')->nullable(); // {"senin": "08:00-17:00", "selasa": "08:00-17:00", ...}
            $table->json('hari_libur')->nullable(); // ["minggu", "hari_raya"]
            
            // Media & Dokumentasi
            $table->string('logo')->nullable();
            $table->json('galeri_foto')->nullable(); // Array foto produk/tempat
            $table->string('video_profil')->nullable();
            
            // Legalitas & Sertifikasi
            $table->string('nomor_izin_usaha')->nullable();
            $table->date('tanggal_izin')->nullable();
            $table->string('npwp')->nullable();
            $table->json('sertifikat')->nullable(); // Array sertifikat (halal, ISO, dll)
            
            // Finansial & Kapasitas
            $table->enum('skala_usaha', ['mikro', 'kecil', 'menengah']);
            $table->integer('jumlah_karyawan')->default(1);
            $table->decimal('modal_awal', 15, 2)->nullable();
            $table->decimal('omzet_bulanan', 15, 2)->nullable();
            $table->text('produk_unggulan')->nullable();
            $table->integer('kapasitas_produksi_harian')->nullable();
            
            // Status & Verifikasi
            $table->enum('status', ['aktif', 'nonaktif', 'pending_verifikasi'])->default('pending_verifikasi');
            $table->boolean('is_verified')->default(false);
            $table->timestamp('verified_at')->nullable();
            $table->foreignId('verified_by')->nullable()->constrained('users')->onDelete('set null');
            $table->text('catatan_verifikasi')->nullable();
            
            // Marketplace & E-commerce
            $table->boolean('aktif_marketplace')->default(false);
            $table->boolean('bisa_cod')->default(true);
            $table->boolean('bisa_transfer')->default(true);
            $table->decimal('minimal_order', 12, 2)->nullable();
            $table->text('kebijakan_pengiriman')->nullable();
            $table->text('kebijakan_pengembalian')->nullable();
            
            // SEO & Pencarian
            $table->string('slug')->unique();
            $table->json('tags')->nullable(); // ["organik", "halal", "handmade"]
            $table->integer('rating_rata_rata')->default(0); // 1-5 bintang
            $table->integer('jumlah_ulasan')->default(0);
            $table->integer('total_penjualan')->default(0);
            $table->integer('view_count')->default(0);
            
            // Metadata
            $table->foreignId('user_id')->constrained()->onDelete('cascade'); // User yang input data
            $table->timestamps();
            
            // Indexes
            $table->index(['kategori', 'status']);
            $table->index(['pemilik_id']);
            $table->index(['is_verified', 'aktif_marketplace']);
            $table->index('slug');
            $table->fullText(['nama_umkm', 'deskripsi', 'produk_unggulan']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('umkm');
    }
};
