<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tiket_wisata', function (Blueprint $table) {
            $table->id();
            $table->string('kode_tiket', 20)->unique(); // TKT-20250612-001
            $table->foreignId('objek_wisata_id')->constrained('objek_wisata')->onDelete('cascade');
            $table->unsignedBigInteger('transaksi_id')->nullable();
            
            // Data Pembeli
            $table->string('nama_pembeli');
            $table->string('email_pembeli');
            $table->string('nomor_hp_pembeli', 15);
            $table->text('alamat_pembeli')->nullable();
            $table->string('nik_pembeli', 16)->nullable();
            
            // Detail Tiket
            $table->enum('jenis_tiket', ['dewasa', 'anak', 'rombongan', 'paket_keluarga']);
            $table->integer('jumlah_tiket');
            $table->decimal('harga_per_tiket', 10, 2);
            $table->decimal('total_harga', 12, 2);
            $table->decimal('biaya_admin', 8, 2)->default(0);
            $table->decimal('diskon', 10, 2)->default(0);
            $table->decimal('total_bayar', 12, 2);
            
            // Jadwal Kunjungan
            $table->date('tanggal_kunjungan');
            $table->time('jam_kunjungan')->nullable();
            $table->integer('estimasi_durasi_jam')->nullable(); // Durasi kunjungan dalam jam
            $table->text('catatan_khusus')->nullable();
            
            // Layanan Tambahan
            $table->boolean('butuh_guide')->default(false);
            $table->decimal('biaya_guide', 10, 2)->default(0);
            $table->boolean('butuh_transportasi')->default(false);
            $table->decimal('biaya_transportasi', 10, 2)->default(0);
            $table->boolean('butuh_makan')->default(false);
            $table->decimal('biaya_makan', 10, 2)->default(0);
            $table->json('layanan_tambahan')->nullable(); // Array layanan lain
            
            // Status & Verifikasi
            $table->enum('status_tiket', [
                'pending_payment',
                'paid',
                'confirmed',
                'used',
                'expired',
                'cancelled',
                'refunded'
            ])->default('pending_payment');
            $table->timestamp('tanggal_bayar')->nullable();
            $table->timestamp('tanggal_konfirmasi')->nullable();
            $table->timestamp('tanggal_digunakan')->nullable();
            $table->timestamp('tanggal_expired')->nullable();
            
            // QR Code & Verifikasi
            $table->string('qr_code')->unique()->nullable(); // QR code untuk verifikasi
            $table->string('verification_token', 64)->unique()->nullable();
            $table->boolean('is_verified')->default(false);
            $table->timestamp('verified_at')->nullable();
            $table->foreignId('verified_by')->nullable()->constrained('users')->onDelete('set null');
            $table->text('catatan_verifikasi')->nullable();
            
            // Check-in & Check-out
            $table->timestamp('check_in_at')->nullable();
            $table->timestamp('check_out_at')->nullable();
            $table->decimal('check_in_latitude', 10, 8)->nullable();
            $table->decimal('check_in_longitude', 11, 8)->nullable();
            $table->string('check_in_device')->nullable(); // Info device yang check-in
            
            // Pembatalan & Refund
            $table->boolean('bisa_dibatalkan')->default(true);
            $table->timestamp('batas_pembatalan')->nullable();
            $table->text('alasan_pembatalan')->nullable();
            $table->decimal('biaya_pembatalan', 10, 2)->default(0);
            $table->decimal('jumlah_refund', 12, 2)->nullable();
            $table->timestamp('tanggal_refund')->nullable();
            
            // Rating & Review
            $table->integer('rating')->nullable(); // 1-5 bintang
            $table->text('review')->nullable();
            $table->timestamp('review_at')->nullable();
            $table->json('foto_review')->nullable(); // Foto dari pengunjung
            
            // Metadata & Tracking
            $table->string('source', 50)->default('website'); // website, mobile_app, offline
            $table->string('user_agent')->nullable();
            $table->string('ip_address', 45)->nullable();
            $table->json('metadata')->nullable(); // Data tambahan
            
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('set null'); // User yang input (jika ada)
            $table->timestamps();
            
            // Indexes
            $table->index(['objek_wisata_id', 'status_tiket']);
            $table->index(['tanggal_kunjungan', 'status_tiket']);
            $table->index(['email_pembeli', 'nomor_hp_pembeli']);
            $table->index(['kode_tiket']);
            $table->index(['qr_code']);
            $table->index(['verification_token']);
            $table->index(['status_tiket', 'tanggal_kunjungan']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tiket_wisata');
    }
};
