<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('mutasi_penduduks', function (Blueprint $table) {
            $table->id();
            $table->string('nik', 16);
            $table->enum('jenis_mutasi', ['Lahir', 'Meninggal', 'Pindah Masuk', 'Pindah Keluar', 'Status Update']);
            $table->date('tanggal_mutasi');
            $table->text('keterangan')->nullable();
            $table->string('asal_daerah')->nullable(); // untuk pindah masuk
            $table->string('tujuan_daerah')->nullable(); // untuk pindah keluar
            $table->string('sebab_meninggal')->nullable(); // khusus meninggal
            $table->string('tempat_meninggal')->nullable(); // khusus meninggal
            $table->string('no_surat_keterangan')->nullable(); // nomor surat resmi
            $table->json('data_lama')->nullable(); // backup data sebelum perubahan
            $table->string('admin_user')->nullable(); // siapa yang input
            $table->text('catatan_admin')->nullable();
            $table->timestamps();
            
            $table->foreign('nik')->references('nik')->on('penduduk')->onDelete('cascade');
            $table->index(['nik', 'tanggal_mutasi']);
            $table->index('jenis_mutasi');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('mutasi_penduduks');
    }
};
