<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->string('tripay_api_key')->nullable()->after('sejarah_desa');
            $table->string('tripay_private_key')->nullable()->after('tripay_api_key');
            $table->string('tripay_merchant_code')->nullable()->after('tripay_private_key');
            $table->enum('tripay_mode', ['sandbox', 'production'])->default('sandbox')->after('tripay_merchant_code');
            $table->integer('tripay_expiry_time')->default(24)->after('tripay_mode');
            $table->boolean('tripay_fee_customer')->default(true)->after('tripay_expiry_time');
            $table->json('tripay_channels')->nullable()->after('tripay_fee_customer');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->dropColumn([
                'tripay_api_key',
                'tripay_private_key',
                'tripay_merchant_code',
                'tripay_mode',
                'tripay_expiry_time',
                'tripay_fee_customer',
                'tripay_channels'
            ]);
        });
    }
};
