<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ppob_transactions', function (Blueprint $table) {
            $table->id();
            $table->string('order_id')->unique();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('product_type'); // pulsa, paket_data, pln, pdam, bpjs, tv_kabel, internet, finance
            $table->string('provider')->nullable(); // telkomsel, indosat, xl, etc
            $table->string('target_number'); // nomor hp, nomor pelanggan, dll
            $table->decimal('amount', 15, 2); // nominal asli
            $table->decimal('admin_fee', 15, 2); // biaya admin
            $table->decimal('total_amount', 15, 2); // total yang harus dibayar
            $table->enum('status', ['pending', 'paid', 'processing', 'success', 'failed', 'cancelled'])->default('pending');
            $table->text('payment_url')->nullable(); // URL pembayaran dari Ottopay
            $table->json('payment_data')->nullable(); // data pembayaran dari Ottopay
            $table->json('payment_response')->nullable(); // response callback dari Ottopay
            $table->timestamp('processed_at')->nullable(); // waktu transaksi diproses
            $table->timestamps();
            
            $table->index(['user_id', 'status']);
            $table->index(['product_type', 'status']);
            $table->index('order_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ppob_transactions');
    }
};
