<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ApbdesRencana;
use App\Models\ApbdesRealisasi;
use App\Models\User;

class ApbdesSeeder extends Seeder
{
    public function run(): void
    {
        $adminUser = User::where('email', 'admin@aplikasidesa.com')->first();
        
        if (!$adminUser) {
            $adminUser = User::first();
        }

        $tahun = date('Y');

        // Rencana Pendapatan
        $pendapatan = [
            [
                'kode_rekening' => '4.1.1',
                'uraian' => 'Dana Desa',
                'anggaran' => 800000000,
                'bidang' => 'dana_desa'
            ],
            [
                'kode_rekening' => '4.1.2',
                'uraian' => 'Alokasi Dana Desa (ADD)',
                'anggaran' => 600000000,
                'bidang' => 'add'
            ],
            [
                'kode_rekening' => '4.1.3',
                'uraian' => 'Pendapatan Asli Desa',
                'anggaran' => 50000000,
                'bidang' => 'pad'
            ],
        ];

        foreach ($pendapatan as $data) {
            ApbdesRencana::create([
                'tahun_anggaran' => $tahun,
                'kategori' => 'pendapatan',
                'bidang' => $data['bidang'],
                'kode_rekening' => $data['kode_rekening'],
                'uraian' => $data['uraian'],
                'anggaran' => $data['anggaran'],
                'realisasi' => 0,
                'sisa_anggaran' => $data['anggaran'],
                'user_id' => $adminUser->id
            ]);
        }

        // Rencana Belanja
        $belanja = [
            [
                'kode_rekening' => '5.1.1',
                'uraian' => 'Belanja Pegawai',
                'anggaran' => 300000000,
                'bidang' => 'pemerintahan'
            ],
            [
                'kode_rekening' => '5.2.1',
                'uraian' => 'Pembangunan Infrastruktur Jalan',
                'anggaran' => 500000000,
                'bidang' => 'pembangunan'
            ],
            [
                'kode_rekening' => '5.3.1',
                'uraian' => 'Program Pemberdayaan Masyarakat',
                'anggaran' => 200000000,
                'bidang' => 'pemberdayaan'
            ],
            [
                'kode_rekening' => '5.4.1',
                'uraian' => 'Belanja Operasional Kantor',
                'anggaran' => 150000000,
                'bidang' => 'pemerintahan'
            ],
        ];

        foreach ($belanja as $data) {
            ApbdesRencana::create([
                'tahun_anggaran' => $tahun,
                'kategori' => 'belanja',
                'bidang' => $data['bidang'],
                'kode_rekening' => $data['kode_rekening'],
                'uraian' => $data['uraian'],
                'anggaran' => $data['anggaran'],
                'realisasi' => 0,
                'sisa_anggaran' => $data['anggaran'],
                'user_id' => $adminUser->id
            ]);
        }

        // Sample Realisasi
        $rencana = ApbdesRencana::where('kode_rekening', '4.1.1')->first();
        if ($rencana) {
            ApbdesRealisasi::create([
                'apbdes_rencana_id' => $rencana->id,
                'tanggal_transaksi' => now()->subDays(30),
                'nomor_bukti' => 'BKM-001/' . $tahun,
                'uraian_transaksi' => 'Penerimaan Dana Desa Tahap 1',
                'jumlah' => 200000000,
                'jenis' => 'pemasukan',
                'sumber_dana' => 'Kementerian Desa',
                'status_verifikasi' => 'verified',
                'user_id' => $adminUser->id,
                'verified_by' => $adminUser->id,
                'verified_at' => now()
            ]);

            $rencana->update([
                'realisasi' => 200000000,
                'sisa_anggaran' => 600000000
            ]);
        }

        $rencana2 = ApbdesRencana::where('kode_rekening', '5.1.1')->first();
        if ($rencana2) {
            ApbdesRealisasi::create([
                'apbdes_rencana_id' => $rencana2->id,
                'tanggal_transaksi' => now()->subDays(15),
                'nomor_bukti' => 'BKK-001/' . $tahun,
                'uraian_transaksi' => 'Pembayaran Gaji Pegawai Bulan ' . now()->format('F'),
                'jumlah' => 25000000,
                'jenis' => 'pengeluaran',
                'penerima_pembayaran' => 'Bendahara Desa',
                'status_verifikasi' => 'verified',
                'user_id' => $adminUser->id,
                'verified_by' => $adminUser->id,
                'verified_at' => now()
            ]);

            $rencana2->update([
                'realisasi' => 25000000,
                'sisa_anggaran' => 275000000
            ]);
        }
    }
} 