<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class NotifikasiWaLegacySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Clear existing data
        DB::table('notifikasi_wa')->truncate();

        // Sample notifications using existing table structure
        $notifications = [
            [
                'no_wa' => '081234567890',
                'pesan' => 'Surat domisili atas nama John Doe telah disetujui dan siap diambil. Silakan datang ke kantor desa pada jam kerja.',
                'jenis' => 'surat_selesai',
                'reference_id' => '1',
                'reference_type' => 'PelayananSurat',
                'status' => 'Terkirim',
                'response' => json_encode(['status' => 'success', 'message_id' => 'WA123']),
                'tanggal_kirim' => now()->subMinutes(5),
                'created_at' => now()->subMinutes(5),
                'updated_at' => now()->subMinutes(5),
            ],
            [
                'no_wa' => '081234567891',
                'pesan' => 'Pengaduan Anda tentang jalan rusak di RT 02 telah ditanggapi oleh petugas. Perbaikan akan dilakukan minggu depan.',
                'jenis' => 'pengaduan_ditanggapi',
                'reference_id' => '2',
                'reference_type' => 'Pengaduan',
                'status' => 'Terkirim',
                'response' => json_encode(['status' => 'success', 'message_id' => 'WA124']),
                'tanggal_kirim' => now()->subMinutes(15),
                'created_at' => now()->subMinutes(15),
                'updated_at' => now()->subMinutes(15),
            ],
            [
                'no_wa' => '081234567892',
                'pesan' => 'Bantuan sembako untuk program PKH bulan ini telah siap. Silakan ambil di kantor desa mulai besok pagi.',
                'jenis' => 'bantuan_diterima',
                'reference_id' => '3',
                'reference_type' => 'Bantuan',
                'status' => 'Terkirim',
                'response' => json_encode(['status' => 'success', 'message_id' => 'WA125']),
                'tanggal_kirim' => now()->subHour(),
                'created_at' => now()->subHour(),
                'updated_at' => now()->subHour(),
            ],
            [
                'no_wa' => '081234567893',
                'pesan' => 'BERITA DESA: Program gotong royong pembersihan lingkungan akan dilaksanakan hari Minggu, 14 Januari 2024. Mari berpartisipasi!',
                'jenis' => 'broadcast_berita',
                'reference_id' => '4',
                'reference_type' => 'Berita',
                'status' => 'Pending',
                'response' => null,
                'tanggal_kirim' => null,
                'created_at' => now()->subMinutes(2),
                'updated_at' => now()->subMinutes(2),
            ],
            [
                'no_wa' => '081234567894',
                'pesan' => 'Surat keterangan usaha Anda ditolak. Alasan: Dokumen pendukung tidak lengkap. Hubungi kantor desa untuk info lebih lanjut.',
                'jenis' => 'surat_selesai',
                'reference_id' => '5',
                'reference_type' => 'PelayananSurat',
                'status' => 'Gagal',
                'response' => json_encode(['status' => 'failed', 'error' => 'Invalid phone number']),
                'tanggal_kirim' => null,
                'created_at' => now()->subHours(2),
                'updated_at' => now()->subHours(2),
            ],
            [
                'no_wa' => '081234567895',
                'pesan' => 'PENGINGAT: Pembayaran PBB tahun 2024 akan berakhir pada tanggal 31 Januari 2024. Segera lakukan pembayaran untuk menghindari denda.',
                'jenis' => 'manual',
                'reference_id' => null,
                'reference_type' => null,
                'status' => 'Terkirim',
                'response' => json_encode(['status' => 'success', 'message_id' => 'WA126']),
                'tanggal_kirim' => now()->subHours(3),
                'created_at' => now()->subHours(3),
                'updated_at' => now()->subHours(3),
            ],
            [
                'no_wa' => '081234567896',
                'pesan' => 'Selamat datang di layanan notifikasi WhatsApp Desa. Anda akan menerima update terkait layanan desa melalui nomor ini.',
                'jenis' => 'manual',
                'reference_id' => null,
                'reference_type' => null,
                'status' => 'Terkirim',
                'response' => json_encode(['status' => 'success', 'message_id' => 'WA127']),
                'tanggal_kirim' => now()->subDays(1),
                'created_at' => now()->subDays(1),
                'updated_at' => now()->subDays(1),
            ],
            [
                'no_wa' => '081234567897',
                'pesan' => 'Permohonan surat keterangan tidak mampu (SKTM) Anda sedang diproses. Estimasi selesai 3 hari kerja.',
                'jenis' => 'surat_selesai',
                'reference_id' => '6',
                'reference_type' => 'PelayananSurat',
                'status' => 'Terkirim',
                'response' => json_encode(['status' => 'success', 'message_id' => 'WA128']),
                'tanggal_kirim' => now()->subHours(6),
                'created_at' => now()->subHours(6),
                'updated_at' => now()->subHours(6),
            ],
            [
                'no_wa' => '081234567898',
                'pesan' => 'Bantuan Langsung Tunai (BLT) bulan Januari 2024 telah cair. Silakan ambil di agen/bank terdekat dengan membawa KTP.',
                'jenis' => 'bantuan_diterima',
                'reference_id' => '7',
                'reference_type' => 'Bantuan',
                'status' => 'Pending',
                'response' => null,
                'tanggal_kirim' => null,
                'created_at' => now()->subMinutes(30),
                'updated_at' => now()->subMinutes(30),
            ],
            [
                'no_wa' => '081234567899',
                'pesan' => 'Sistem maintenance akan dilakukan pada Sabtu malam. Layanan online mungkin terganggu sementara. Mohon maaf atas ketidaknyamanan.',
                'jenis' => 'manual',
                'reference_id' => null,
                'reference_type' => null,
                'status' => 'Gagal',
                'response' => json_encode(['status' => 'failed', 'error' => 'Network timeout']),
                'tanggal_kirim' => null,
                'created_at' => now()->subHours(4),
                'updated_at' => now()->subHours(4),
            ],
        ];

        foreach ($notifications as $notification) {
            DB::table('notifikasi_wa')->insert($notification);
        }

        $this->command->info('NotifikasiWa legacy seeder completed! Created ' . count($notifications) . ' notification records.');
    }
} 