<?php

namespace Database\Seeders;

use App\Models\NotifikasiWa;
use Illuminate\Database\Seeder;

class NotifikasiWaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Simple notifications with required fields only
        $notifications = [
            [
                'no_wa_legacy' => '081234567890',
                'pesan_legacy' => 'Surat domisili atas nama John Doe telah disetujui dan siap diambil.',
                'jenis_legacy' => 'surat_selesai',
                'phone_number' => '081234567890',
                'message' => 'Surat domisili atas nama John Doe telah disetujui dan siap diambil.',
                'message_type' => 'surat_selesai',
                'status' => 'Terkirim',
                'is_read' => false,
                'sent_at' => now()->subMinutes(5),
                'tanggal_kirim' => now()->subMinutes(5),
            ],
            [
                'no_wa_legacy' => '081234567891',
                'pesan_legacy' => 'Pengaduan Anda tentang jalan rusak telah ditanggapi.',
                'jenis_legacy' => 'pengaduan_ditanggapi',
                'phone_number' => '081234567891',
                'message' => 'Pengaduan Anda tentang jalan rusak telah ditanggapi.',
                'message_type' => 'pengaduan_ditanggapi',
                'status' => 'Terkirim',
                'is_read' => false,
                'sent_at' => now()->subMinutes(15),
                'tanggal_kirim' => now()->subMinutes(15),
            ],
            [
                'no_wa_legacy' => '081234567892',
                'pesan_legacy' => 'Bantuan sembako PKH bulan ini telah siap diambil.',
                'jenis_legacy' => 'bantuan_diterima',
                'phone_number' => '081234567892',
                'message' => 'Bantuan sembako PKH bulan ini telah siap diambil.',
                'message_type' => 'bantuan_diterima',
                'status' => 'Terkirim',
                'is_read' => true,
                'sent_at' => now()->subHour(),
                'tanggal_kirim' => now()->subHour(),
            ],
            [
                'no_wa_legacy' => '081234567893',
                'pesan_legacy' => 'Program gotong royong akan dilaksanakan hari Minggu.',
                'jenis_legacy' => 'broadcast_berita',
                'phone_number' => '081234567893',
                'message' => 'Program gotong royong akan dilaksanakan hari Minggu.',
                'message_type' => 'broadcast_berita',
                'status' => 'Pending',
                'is_read' => false,
                'tanggal_kirim' => null,
            ],
            [
                'no_wa_legacy' => '081234567894',
                'pesan_legacy' => 'Surat keterangan usaha ditolak karena dokumen tidak lengkap.',
                'jenis_legacy' => 'surat_selesai',
                'phone_number' => '081234567894',
                'message' => 'Surat keterangan usaha ditolak karena dokumen tidak lengkap.',
                'message_type' => 'surat_selesai',
                'status' => 'Gagal',
                'is_read' => false,
                'sent_at' => null,
                'tanggal_kirim' => null,
            ],
        ];

        foreach ($notifications as $notification) {
            NotifikasiWa::create($notification);
        }

        $this->command->info('NotifikasiWa seeder completed! Created ' . count($notifications) . ' notification records.');
    }
} 