<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\ObjekWisata;

class ObjekWisataSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $wisataData = [
            [
                'nama' => 'Air Terjun Sirnajaya',
                'slug' => 'air-terjun-sirnajaya',
                'kategori' => 'Wisata Alam',
                'deskripsi' => 'Air terjun alami dengan ketinggian sekitar 25 meter yang dikelilingi oleh hutan bambu dan pepohonan rindang. Lokasi yang sejuk dan asri cocok untuk piknik keluarga.',
                'alamat' => 'Kampung Sirnajaya, Desa Sirnajaya, Kecamatan Sukamakmur',
                'latitude' => -6.7190,
                'longitude' => 107.1450,
                'jam_buka' => '07:00',
                'jam_tutup' => '17:00',
                'harga_tiket' => 5000,
                'fasilitas' => json_encode(['Tempat Parkir', 'Warung Makan', 'Toilet', 'Gazebo']),
                'kontak_person' => '081234567890',
                'status' => 'aktif',
                'is_featured' => true,
                'rating_rata_rata' => 4.5,
                'jumlah_ulasan' => 25,
                'view_count' => 150,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'nama' => 'Kebun Teh Sirnajaya',
                'slug' => 'kebun-teh-sirnajaya',
                'kategori' => 'Agrowisata',
                'deskripsi' => 'Perkebunan teh tradisional dengan pemandangan pegunungan yang menakjubkan. Pengunjung dapat melihat proses pemetikan teh dan menikmati teh segar langsung dari kebun.',
                'alamat' => 'Kampung Bojong, Desa Sirnajaya, Kecamatan Sukamakmur',
                'latitude' => -6.7160,
                'longitude' => 107.1410,
                'jam_buka' => '06:00',
                'jam_tutup' => '18:00',
                'harga_tiket' => 10000,
                'fasilitas' => json_encode(['Tempat Parkir', 'Cafe Teh', 'Toilet', 'Toko Souvenir', 'Spot Foto']),
                'kontak_person' => '081234567891',
                'status' => 'aktif',
                'is_featured' => true,
                'rating_rata_rata' => 4.7,
                'jumlah_ulasan' => 42,
                'view_count' => 230,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'nama' => 'Curug Cigentis',
                'slug' => 'curug-cigentis',
                'kategori' => 'Wisata Alam',
                'deskripsi' => 'Air terjun tersembunyi dengan kolam alami yang jernih. Akses menuju lokasi melalui trekking ringan sekitar 15 menit dari jalan utama.',
                'alamat' => 'Kampung Cigentis, Desa Sirnajaya, Kecamatan Sukamakmur',
                'latitude' => -6.7200,
                'longitude' => 107.1380,
                'jam_buka' => '08:00',
                'jam_tutup' => '16:00',
                'harga_tiket' => 3000,
                'fasilitas' => json_encode(['Tempat Parkir', 'Warung Sederhana', 'Toilet']),
                'kontak_person' => '081234567892',
                'status' => 'aktif',
                'is_featured' => false,
                'rating_rata_rata' => 4.2,
                'jumlah_ulasan' => 18,
                'view_count' => 95,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'nama' => 'Puncak Gunung Sirnajaya',
                'slug' => 'puncak-gunung-sirnajaya',
                'kategori' => 'Wisata Alam',
                'deskripsi' => 'Puncak dengan pemandangan 360 derajat yang spektakuler. Cocok untuk hiking dan menikmati sunrise/sunset. Ketinggian sekitar 1.200 mdpl.',
                'alamat' => 'Kampung Puncak, Desa Sirnajaya, Kecamatan Sukamakmur',
                'latitude' => -6.7120,
                'longitude' => 107.1470,
                'jam_buka' => '05:00',
                'jam_tutup' => '19:00',
                'harga_tiket' => 15000,
                'fasilitas' => json_encode(['Tempat Parkir', 'Pos Jaga', 'Toilet', 'Warung', 'Camping Ground']),
                'kontak_person' => '081234567893',
                'status' => 'aktif',
                'is_featured' => true,
                'rating_rata_rata' => 4.8,
                'jumlah_ulasan' => 67,
                'view_count' => 320,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'nama' => 'Situ Sirnajaya',
                'slug' => 'situ-sirnajaya',
                'kategori' => 'Wisata Alam',
                'deskripsi' => 'Danau kecil alami yang dikelilingi perbukitan hijau. Tempat yang tenang untuk memancing dan bersantai bersama keluarga.',
                'alamat' => 'Kampung Situ, Desa Sirnajaya, Kecamatan Sukamakmur',
                'latitude' => -6.7180,
                'longitude' => 107.1430,
                'jam_buka' => '06:00',
                'jam_tutup' => '18:00',
                'harga_tiket' => 5000,
                'fasilitas' => json_encode(['Tempat Parkir', 'Gazebo', 'Toilet', 'Penyewaan Perahu']),
                'kontak_person' => '081234567894',
                'status' => 'aktif',
                'is_featured' => false,
                'rating_rata_rata' => 4.3,
                'jumlah_ulasan' => 31,
                'view_count' => 180,
                'created_at' => now(),
                'updated_at' => now()
            ]
        ];

        foreach ($wisataData as $data) {
            ObjekWisata::create($data);
        }
    }
}
