<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PendudukSeeder extends Seeder
{
    public function run()
    {
        $penduduk = [
            [
                'nik' => '3203012345678901',
                'nama' => 'Sari Wulandari',
                'no_kk' => '3203012345678900',
                'alamat' => 'Kampung Sirnajaya RT 01/RW 01',
                'dusun' => 'Sirnajaya',
                'desa' => 'Sirnajaya',
                'rt' => '01',
                'rw' => '01',
                'tempat_lahir' => 'Cianjur',
                'tanggal_lahir' => '1980-05-15',
                'jenis_kelamin' => 'P',
                'status_kawin' => 'Kawin',
                'agama' => 'Islam',
                'pekerjaan' => 'Wiraswasta',
                'pendidikan' => 'SMA',
                'kewarganegaraan' => 'WNI',
                'status_hidup' => 'Hidup',
                'is_kepala_keluarga' => true,
                'latitude' => -6.7150,
                'longitude' => 107.1420,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'nik' => '3203012345678902',
                'nama' => 'Budi Santoso',
                'no_kk' => '3203012345678900',
                'alamat' => 'Kampung Sirnajaya RT 01/RW 01',
                'dusun' => 'Sirnajaya',
                'desa' => 'Sirnajaya',
                'rt' => '01',
                'rw' => '01',
                'tempat_lahir' => 'Cianjur',
                'tanggal_lahir' => '1978-03-20',
                'jenis_kelamin' => 'L',
                'status_kawin' => 'Kawin',
                'agama' => 'Islam',
                'pekerjaan' => 'Petani',
                'pendidikan' => 'SD',
                'kewarganegaraan' => 'WNI',
                'status_hidup' => 'Hidup',
                'is_kepala_keluarga' => false,
                'latitude' => -6.7152,
                'longitude' => 107.1422,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'nik' => '3203012345678903',
                'nama' => 'Ani Susanti',
                'no_kk' => '3203012345678901',
                'alamat' => 'Kampung Sirnajaya RT 02/RW 01',
                'dusun' => 'Sirnajaya',
                'desa' => 'Sirnajaya',
                'rt' => '02',
                'rw' => '01',
                'tempat_lahir' => 'Cianjur',
                'tanggal_lahir' => '1985-08-12',
                'jenis_kelamin' => 'P',
                'status_kawin' => 'Belum Kawin',
                'agama' => 'Islam',
                'pekerjaan' => 'Guru',
                'pendidikan' => 'S1',
                'kewarganegaraan' => 'WNI',
                'status_hidup' => 'Hidup',
                'is_kepala_keluarga' => true,
                'latitude' => -6.7155,
                'longitude' => 107.1425,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'nik' => '3203012345678904',
                'nama' => 'Joko Prasetyo',
                'no_kk' => '3203012345678902',
                'alamat' => 'Kampung Sirnajaya RT 03/RW 02',
                'dusun' => 'Sirnajaya',
                'desa' => 'Sirnajaya',
                'rt' => '03',
                'rw' => '02',
                'tempat_lahir' => 'Cianjur',
                'tanggal_lahir' => '1975-11-05',
                'jenis_kelamin' => 'L',
                'status_kawin' => 'Kawin',
                'agama' => 'Islam',
                'pekerjaan' => 'Buruh',
                'pendidikan' => 'SMP',
                'kewarganegaraan' => 'WNI',
                'status_hidup' => 'Hidup',
                'is_kepala_keluarga' => true,
                'latitude' => -6.7160,
                'longitude' => 107.1430,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'nik' => '3203012345678905',
                'nama' => 'Dewi Lestari',
                'no_kk' => '3203012345678902',
                'alamat' => 'Kampung Sirnajaya RT 03/RW 02',
                'dusun' => 'Sirnajaya',
                'desa' => 'Sirnajaya',
                'rt' => '03',
                'rw' => '02',
                'tempat_lahir' => 'Cianjur',
                'tanggal_lahir' => '1982-07-18',
                'jenis_kelamin' => 'P',
                'status_kawin' => 'Kawin',
                'agama' => 'Islam',
                'pekerjaan' => 'Ibu Rumah Tangga',
                'pendidikan' => 'SMA',
                'kewarganegaraan' => 'WNI',
                'status_hidup' => 'Hidup',
                'is_kepala_keluarga' => false,
                'latitude' => -6.7162,
                'longitude' => 107.1432,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'nik' => '3203012345678906',
                'nama' => 'Ahmad Fauzi',
                'no_kk' => '3203012345678903',
                'alamat' => 'Kampung Sirnajaya RT 01/RW 02',
                'dusun' => 'Sirnajaya',
                'desa' => 'Sirnajaya',
                'rt' => '01',
                'rw' => '02',
                'tempat_lahir' => 'Cianjur',
                'tanggal_lahir' => '1990-12-25',
                'jenis_kelamin' => 'L',
                'status_kawin' => 'Belum Kawin',
                'agama' => 'Islam',
                'pekerjaan' => 'Mahasiswa',
                'pendidikan' => 'SMA',
                'kewarganegaraan' => 'WNI',
                'status_hidup' => 'Hidup',
                'is_kepala_keluarga' => false,
                'latitude' => -6.7140,
                'longitude' => 107.1440,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'nik' => '3203012345678907',
                'nama' => 'Rina Marlina',
                'no_kk' => '3203012345678904',
                'alamat' => 'Kampung Sirnajaya RT 02/RW 03',
                'dusun' => 'Sirnajaya',
                'desa' => 'Sirnajaya',
                'rt' => '02',
                'rw' => '03',
                'tempat_lahir' => 'Cianjur',
                'tanggal_lahir' => '1988-04-30',
                'jenis_kelamin' => 'P',
                'status_kawin' => 'Kawin',
                'agama' => 'Islam',
                'pekerjaan' => 'Pedagang',
                'pendidikan' => 'SMP',
                'kewarganegaraan' => 'WNI',
                'status_hidup' => 'Hidup',
                'is_kepala_keluarga' => true,
                'latitude' => -6.7170,
                'longitude' => 107.1450,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'nik' => '3203012345678908',
                'nama' => 'Hendra Gunawan',
                'no_kk' => '3203012345678905',
                'alamat' => 'Kampung Sirnajaya RT 03/RW 03',
                'dusun' => 'Sirnajaya',
                'desa' => 'Sirnajaya',
                'rt' => '03',
                'rw' => '03',
                'tempat_lahir' => 'Cianjur',
                'tanggal_lahir' => '1983-09-14',
                'jenis_kelamin' => 'L',
                'status_kawin' => 'Kawin',
                'agama' => 'Islam',
                'pekerjaan' => 'Tukang',
                'pendidikan' => 'SD',
                'kewarganegaraan' => 'WNI',
                'status_hidup' => 'Hidup',
                'is_kepala_keluarga' => true,
                'latitude' => -6.7175,
                'longitude' => 107.1455,
                'created_at' => now(),
                'updated_at' => now(),
            ]
        ];

        DB::table('penduduk')->insert($penduduk);
        
        $this->command->info('Data penduduk berhasil ditambahkan: ' . count($penduduk) . ' record');
    }
} 