<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Pengaduan;
use App\Models\Penduduk;

class PengaduanSeeder extends Seeder
{
    public function run()
    {
        echo "Creating sample Pengaduan data...\n";
        
        // Get some penduduk data for pengaduan reporters
        $pendudukList = Penduduk::limit(8)->get();
        
        if ($pendudukList->isEmpty()) {
            echo "❌ No penduduk data found. Cannot create pengaduan.\n";
            return;
        }
        
        $pengaduanData = [
            [
                'nik' => $pendudukList[0]->nik,
                'judul' => 'Lampu Jalan Rusak di RT 01',
                'isi_pengaduan' => 'Lampu jalan di RT 01 sudah rusak seminggu ini, mohon segera diperbaiki karena mengganggu keamanan warga dan sering terjadi kecelakaan di malam hari.',
                'kategori' => 'Infrastruktur',
                'gambar' => null,
                'latitude' => -6.200000,
                'longitude' => 106.816666,
                'status' => 'Baru',
                'tanggapan' => null,
                'tanggal_tanggapan' => null,
                'created_at' => now()->subDays(3),
                'updated_at' => now()->subDays(3),
            ],
            [
                'nik' => $pendudukList[1]->nik,
                'judul' => 'Jalan Berlubang Perlu Diperbaiki',
                'isi_pengaduan' => 'Jalan menuju pasar banyak berlubang dan berbahaya untuk kendaraan bermotor. Sudah ada beberapa motor yang terjatuh. Mohon segera ditangani sebelum musim hujan.',
                'kategori' => 'Infrastruktur',
                'gambar' => null,
                'latitude' => -6.201000,
                'longitude' => 106.817000,
                'status' => 'Diproses',
                'tanggapan' => 'Pengaduan telah diterima dan akan diagendakan perbaikan bulan depan. Tim teknis sudah melakukan survey lokasi.',
                'tanggal_tanggapan' => now()->subDays(2),
                'created_at' => now()->subDays(5),
                'updated_at' => now()->subDays(2),
            ],
            [
                'nik' => $pendudukList[2]->nik,
                'judul' => 'Sampah Tidak Diangkut Seminggu',
                'isi_pengaduan' => 'Sampah di RT 02 sudah tidak diangkut selama seminggu, mulai menimbulkan bau tidak sedap dan mengundang lalat. Warga sangat terganggu.',
                'kategori' => 'Kebersihan',
                'gambar' => null,
                'latitude' => -6.202000,
                'longitude' => 106.818000,
                'status' => 'Selesai',
                'tanggapan' => 'Sampah telah diangkut dan jadwal pengangkutan diperbaiki. Mulai sekarang pengangkutan akan dilakukan 3x seminggu.',
                'tanggal_tanggapan' => now()->subDays(1),
                'created_at' => now()->subDays(8),
                'updated_at' => now()->subDays(1),
            ],
            [
                'nik' => $pendudukList[3]->nik,
                'judul' => 'Keamanan Kurang di Malam Hari',
                'isi_pengaduan' => 'Di daerah RT 03 sering terjadi pencurian sepeda motor di malam hari. Perlu ditingkatkan patroli keamanan atau penambahan CCTV.',
                'kategori' => 'Keamanan',
                'gambar' => null,
                'latitude' => -6.203000,
                'longitude' => 106.819000,
                'status' => 'Ditanggapi',
                'tanggapan' => 'Koordinasi dengan Babinsa dan Bhabinkamtibmas telah dilakukan. Patroli malam akan ditingkatkan.',
                'tanggal_tanggapan' => now()->subDays(3),
                'created_at' => now()->subDays(6),
                'updated_at' => now()->subDays(3),
            ],
            [
                'nik' => $pendudukList[4]->nik,
                'judul' => 'Pelayanan Kantor Desa Lambat',
                'isi_pengaduan' => 'Proses pembuatan surat keterangan domisili memakan waktu terlalu lama, sudah 2 minggu belum selesai. Mohon dipercepat prosesnya.',
                'kategori' => 'Pelayanan',
                'gambar' => null,
                'latitude' => null,
                'longitude' => null,
                'status' => 'Diproses',
                'tanggapan' => 'Akan dilakukan evaluasi SOP pelayanan untuk mempercepat proses. Target maksimal 3 hari kerja.',
                'tanggal_tanggapan' => now()->subDays(1),
                'created_at' => now()->subDays(4),
                'updated_at' => now()->subDays(1),
            ],
            [
                'nik' => $pendudukList[5]->nik,
                'judul' => 'Bantuan Sosial Tidak Merata',
                'isi_pengaduan' => 'Distribusi bantuan sosial di RT 04 tidak merata, ada keluarga miskin yang tidak mendapat bantuan padahal sudah terdaftar.',
                'kategori' => 'Sosial',
                'gambar' => null,
                'latitude' => null,
                'longitude' => null,
                'status' => 'Baru',
                'tanggapan' => null,
                'tanggal_tanggapan' => null,
                'created_at' => now()->subDays(2),
                'updated_at' => now()->subDays(2),
            ],
            [
                'nik' => $pendudukList[6]->nik,
                'judul' => 'Pasar Desa Tidak Terawat',
                'isi_pengaduan' => 'Kondisi pasar desa sangat kotor dan bau. Perlu pembersihan rutin dan perbaikan sistem drainase agar tidak menggenang air.',
                'kategori' => 'Ekonomi',
                'gambar' => null,
                'latitude' => -6.204000,
                'longitude' => 106.820000,
                'status' => 'Baru',
                'tanggapan' => null,
                'tanggal_tanggapan' => null,
                'created_at' => now()->subDays(1),
                'updated_at' => now()->subDays(1),
            ],
            [
                'nik' => $pendudukList[7]->nik,
                'judul' => 'Pencemaran Sungai oleh Limbah',
                'isi_pengaduan' => 'Sungai di belakang desa tercemar limbah rumah tangga dan sampah. Air sungai berbau dan berwarna keruh, ikan-ikan banyak yang mati.',
                'kategori' => 'Lingkungan',
                'gambar' => null,
                'latitude' => -6.205000,
                'longitude' => 106.821000,
                'status' => 'Diproses',
                'tanggapan' => 'Tim lingkungan akan melakukan pengecekan dan koordinasi dengan dinas terkait untuk penanganan limbah.',
                'tanggal_tanggapan' => now()->subDays(2),
                'created_at' => now()->subDays(7),
                'updated_at' => now()->subDays(2),
            ]
        ];
        
        $totalCreated = 0;
        
        foreach ($pengaduanData as $data) {
            try {
                Pengaduan::create($data);
                $totalCreated++;
            } catch (\Exception $e) {
                echo "Error creating pengaduan: " . $e->getMessage() . "\n";
            }
        }
        
        echo "✅ Successfully created {$totalCreated} Pengaduan records\n";
        echo "Total pengaduan: " . Pengaduan::count() . "\n";
        echo "Pengaduan baru: " . Pengaduan::where('status', 'Baru')->count() . "\n";
        echo "Pengaduan diproses: " . Pengaduan::where('status', 'Diproses')->count() . "\n";
        echo "Pengaduan selesai: " . Pengaduan::where('status', 'Selesai')->count() . "\n";
    }
} 
