<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\PerangkatDesa;

class PerangkatDesaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $perangkatDesa = [
            [
                'nama' => 'Budi Santoso',
                'nik' => '3201010101800001',
                'jabatan' => 'Kepala Desa',
                'no_hp' => '081234567890',
                'alamat' => 'Jl. Raya Desa No. 1',
                'mulai_tugas' => '2020-01-01',
                'status' => 'Aktif',
                'pendidikan' => 'S1',
                'is_active' => true,
                'foto' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'nama' => 'Siti Nurhaliza',
                'nik' => '3201010101800002',
                'jabatan' => 'Sekretaris Desa',
                'no_hp' => '081234567891',
                'alamat' => 'Jl. Mawar No. 5',
                'mulai_tugas' => '2020-01-01',
                'status' => 'Aktif',
                'pendidikan' => 'S1',
                'is_active' => true,
                'foto' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'nama' => 'Ahmad Fauzi',
                'nik' => '3201010101800003',
                'jabatan' => 'Kaur Keuangan',
                'no_hp' => '081234567892',
                'alamat' => 'Jl. Melati No. 10',
                'mulai_tugas' => '2020-01-01',
                'status' => 'Aktif',
                'pendidikan' => 'SMA',
                'is_active' => true,
                'foto' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'nama' => 'Dewi Sartika',
                'nik' => '3201010101800004',
                'jabatan' => 'Kaur Tata Usaha dan Umum',
                'no_hp' => '081234567893',
                'alamat' => 'Jl. Kenanga No. 15',
                'mulai_tugas' => '2020-02-01',
                'status' => 'Aktif',
                'pendidikan' => 'SMA',
                'is_active' => true,
                'foto' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'nama' => 'Joko Widodo',
                'nik' => '3201010101800005',
                'jabatan' => 'Kasi Pemerintahan',
                'no_hp' => '081234567894',
                'alamat' => 'Jl. Anggrek No. 20',
                'mulai_tugas' => '2020-03-01',
                'status' => 'Aktif',
                'pendidikan' => 'D3',
                'is_active' => true,
                'foto' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'nama' => 'Rina Susanti',
                'nik' => '3201010101800006',
                'jabatan' => 'Kasi Kesejahteraan',
                'no_hp' => '081234567895',
                'alamat' => 'Jl. Cempaka No. 25',
                'mulai_tugas' => '2020-04-01',
                'status' => 'Aktif',
                'pendidikan' => 'S1',
                'is_active' => true,
                'foto' => null,
                'created_at' => now(),
                'updated_at' => now()
            ]
        ];

        foreach ($perangkatDesa as $data) {
            PerangkatDesa::create($data);
        }
    }
}
