<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Role;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $roles = [
            [
                'name' => 'super_admin',
                'display_name' => 'Super Admin',
                'description' => 'Akses penuh ke semua fitur sistem',
                'permissions' => array_keys(Role::getAvailablePermissions()),
                'is_active' => true
            ],
            [
                'name' => 'admin_desa',
                'display_name' => 'Admin Desa',
                'description' => 'Administrator desa dengan akses ke sebagian besar fitur',
                'permissions' => [
                    'dashboard',
                    'penduduk.view', 'penduduk.create', 'penduduk.edit',
                    'keluarga.view', 'keluarga.create', 'keluarga.edit',
                    'surat.view', 'surat.create', 'surat.edit',
                    'pengaduan.view', 'pengaduan.edit',
                    'bantuan.view', 'bantuan.create', 'bantuan.edit',
                    'berita.view', 'berita.create', 'berita.edit',
                    'peta.view'
                ],
                'is_active' => true
            ],
            [
                'name' => 'operator',
                'display_name' => 'Operator',
                'description' => 'Operator untuk input data dan pelayanan',
                'permissions' => [
                    'dashboard',
                    'penduduk.view', 'penduduk.create', 'penduduk.edit',
                    'keluarga.view', 'keluarga.create', 'keluarga.edit',
                    'surat.view', 'surat.create', 'surat.edit',
                    'pengaduan.view', 'pengaduan.edit',
                    'berita.view'
                ],
                'is_active' => true
            ],
            [
                'name' => 'viewer',
                'display_name' => 'Viewer',
                'description' => 'Hanya dapat melihat data tanpa bisa mengedit',
                'permissions' => [
                    'dashboard',
                    'penduduk.view',
                    'keluarga.view',
                    'surat.view',
                    'pengaduan.view',
                    'bantuan.view',
                    'berita.view',
                    'peta.view'
                ],
                'is_active' => true
            ],
            [
                'name' => 'ketua_rt',
                'display_name' => 'Ketua RT',
                'description' => 'Ketua Rukun Tetangga dengan akses terbatas pada wilayah RT',
                'permissions' => [
                    'dashboard',
                    'penduduk.view',
                    'keluarga.view',
                    'surat.view', 'surat.create',
                    'pengaduan.view', 'pengaduan.edit',
                    'bantuan.view',
                    'berita.view',
                    'peta.view'
                ],
                'is_active' => true
            ],
            [
                'name' => 'ketua_rw',
                'display_name' => 'Ketua RW',
                'description' => 'Ketua Rukun Warga dengan akses pada wilayah RW',
                'permissions' => [
                    'dashboard',
                    'penduduk.view', 'penduduk.create', 'penduduk.edit',
                    'keluarga.view', 'keluarga.create', 'keluarga.edit',
                    'surat.view', 'surat.create', 'surat.edit',
                    'pengaduan.view', 'pengaduan.edit',
                    'bantuan.view', 'bantuan.create',
                    'berita.view',
                    'peta.view'
                ],
                'is_active' => true
            ],
            [
                'name' => 'ketua_dusun',
                'display_name' => 'Ketua Dusun',
                'description' => 'Ketua Dusun dengan akses pada wilayah dusun',
                'permissions' => [
                    'dashboard',
                    'penduduk.view', 'penduduk.create', 'penduduk.edit',
                    'keluarga.view', 'keluarga.create', 'keluarga.edit',
                    'surat.view', 'surat.create', 'surat.edit',
                    'pengaduan.view', 'pengaduan.edit',
                    'bantuan.view', 'bantuan.create', 'bantuan.edit',
                    'berita.view', 'berita.create',
                    'peta.view'
                ],
                'is_active' => true
            ],
            [
                'name' => 'staf_desa',
                'display_name' => 'Staf Desa',
                'description' => 'Staf kantor desa untuk pelayanan administratif',
                'permissions' => [
                    'dashboard',
                    'penduduk.view', 'penduduk.create', 'penduduk.edit',
                    'keluarga.view', 'keluarga.create', 'keluarga.edit',
                    'surat.view', 'surat.create', 'surat.edit',
                    'pengaduan.view', 'pengaduan.create', 'pengaduan.edit',
                    'bantuan.view', 'bantuan.create',
                    'berita.view'
                ],
                'is_active' => true
            ]
        ];

        foreach ($roles as $roleData) {
            Role::updateOrCreate(
                ['name' => $roleData['name']],
                $roleData
            );
        }
    }
} 
