<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Penduduk;
use App\Models\PerangkatDesa;

class SamplePerangkatDesaSeeder extends Seeder
{
    /**
     * Run the database seeder.
     */
    public function run(): void
    {
        // Sample Penduduk data for Perangkat Desa
        $pendudukData = [
            [
                'nik' => '3201010101010001',
                'nama' => 'H. Ahmad Wijaya, S.AP',
                'no_kk' => '3201010101010001',
                'alamat' => 'Jl. Raya Desa No. 1',
                'dusun' => 'Dusun 1',
                'rt' => '001',
                'rw' => '001',
                'tempat_lahir' => 'Jakarta',
                'tanggal_lahir' => '1965-05-15',
                'jenis_kelamin' => 'L',
                'agama' => 'Islam',
                'pekerjaan' => 'PNS',
                'pendidikan' => 'S1',
                'no_wa' => '081234567890'
            ],
            [
                'nik' => '3201010101010002',
                'nama' => 'Drs. Bambang Sutrisno',
                'no_kk' => '3201010101010002',
                'alamat' => 'Jl. Mawar No. 15',
                'dusun' => 'Dusun 1',
                'rt' => '002',
                'rw' => '001',
                'tempat_lahir' => 'Bandung',
                'tanggal_lahir' => '1972-03-12',
                'jenis_kelamin' => 'L',
                'agama' => 'Islam',
                'pekerjaan' => 'PNS',
                'pendidikan' => 'S1',
                'no_wa' => '081234567891'
            ],
            [
                'nik' => '3201010101010003',
                'nama' => 'Siti Fatimah, S.Pd',
                'no_kk' => '3201010101010003',
                'alamat' => 'Jl. Melati No. 8',
                'dusun' => 'Dusun 1',
                'rt' => '003',
                'rw' => '001',
                'tempat_lahir' => 'Bogor',
                'tanggal_lahir' => '1980-07-20',
                'jenis_kelamin' => 'P',
                'agama' => 'Islam',
                'pekerjaan' => 'PNS',
                'pendidikan' => 'S1',
                'no_wa' => '081234567892'
            ],
            [
                'nik' => '3201010101010004',
                'nama' => 'Muhammad Fauzi',
                'no_kk' => '3201010101010004',
                'alamat' => 'Jl. Anggrek No. 12',
                'dusun' => 'Dusun 1',
                'rt' => '004',
                'rw' => '001',
                'tempat_lahir' => 'Depok',
                'tanggal_lahir' => '1985-11-30',
                'jenis_kelamin' => 'L',
                'agama' => 'Islam',
                'pekerjaan' => 'PNS',
                'pendidikan' => 'S1',
                'no_wa' => '081234567893'
            ],
            [
                'nik' => '3201010101010005',
                'nama' => 'Dr. Sari Indrawati',
                'no_kk' => '3201010101010005',
                'alamat' => 'Jl. Dahlia No. 5',
                'dusun' => 'Dusun 1',
                'rt' => '005',
                'rw' => '001',
                'tempat_lahir' => 'Bekasi',
                'tanggal_lahir' => '1978-09-10',
                'jenis_kelamin' => 'P',
                'agama' => 'Islam',
                'pekerjaan' => 'PNS',
                'pendidikan' => 'S3',
                'no_wa' => '081234567894'
            ],
            [
                'nik' => '3201010101010006',
                'nama' => 'Budi Santoso, S.Sos',
                'no_kk' => '3201010101010006',
                'alamat' => 'Jl. Cempaka No. 18',
                'dusun' => 'Dusun 2',
                'rt' => '006',
                'rw' => '002',
                'tempat_lahir' => 'Tangerang',
                'tanggal_lahir' => '1982-04-25',
                'jenis_kelamin' => 'L',
                'agama' => 'Islam',
                'pekerjaan' => 'PNS',
                'pendidikan' => 'S1',
                'no_wa' => '081234567895'
            ]
        ];

        // Create Penduduk records
        foreach ($pendudukData as $data) {
            Penduduk::create($data);
        }

        // Sample Perangkat Desa data
        $perangkatData = [
            [
                'nik' => '3201010101010001',
                'nama' => 'H. Ahmad Wijaya, S.AP',
                'nip' => '196505151990031002',
                'jabatan' => 'Kepala Desa',
                'bidang_tugas' => 'Kepemimpinan dan Koordinasi Umum',
                'tugas_tanggung_jawab' => 'Memimpin penyelenggaraan pemerintahan desa, pembangunan, dan pemberdayaan masyarakat',
                'mulai_tugas' => '2019-08-17',
                'selesai_tugas' => '2025-08-17',
                'status' => 'Aktif',
                'no_hp' => '081234567890',
                'email' => 'kades@desa.id',
                'alamat' => 'Jl. Raya Desa No. 1',
                'wilayah_kerja' => 'Seluruh Wilayah Desa',
                'urutan' => 1,
                'level_hierarki' => 0
            ],
            [
                'nik' => '3201010101010002',
                'nama' => 'Drs. Bambang Sutrisno',
                'nip' => '197203121995031001',
                'jabatan' => 'Sekretaris Desa',
                'bidang_tugas' => 'Administrasi dan Kesekretariatan',
                'tugas_tanggung_jawab' => 'Membantu Kepala Desa dalam bidang administrasi pemerintahan',
                'mulai_tugas' => '2020-01-01',
                'status' => 'Aktif',
                'no_hp' => '081234567891',
                'email' => 'sekdes@desa.id',
                'alamat' => 'Jl. Mawar No. 15',
                'wilayah_kerja' => 'Seluruh Wilayah Desa',
                'urutan' => 2,
                'level_hierarki' => 1
            ],
            [
                'nik' => '3201010101010003',
                'nama' => 'Siti Fatimah, S.Pd',
                'jabatan' => 'Kaur Tata Usaha dan Umum',
                'bidang_tugas' => 'Tata Usaha dan Administrasi Umum',
                'tugas_tanggung_jawab' => 'Mengelola administrasi umum dan tata usaha desa',
                'mulai_tugas' => '2020-02-01',
                'status' => 'Aktif',
                'no_hp' => '081234567892',
                'email' => 'kaur.umum@desa.id',
                'alamat' => 'Jl. Melati No. 8',
                'wilayah_kerja' => 'Seluruh Wilayah Desa',
                'urutan' => 3,
                'level_hierarki' => 2
            ],
            [
                'nik' => '3201010101010004',
                'nama' => 'Muhammad Fauzi',
                'jabatan' => 'Kaur Keuangan',
                'bidang_tugas' => 'Pengelolaan Keuangan Desa',
                'tugas_tanggung_jawab' => 'Mengelola keuangan dan aset desa',
                'mulai_tugas' => '2020-03-01',
                'status' => 'Aktif',
                'no_hp' => '081234567893',
                'email' => 'kaur.keuangan@desa.id',
                'alamat' => 'Jl. Anggrek No. 12',
                'wilayah_kerja' => 'Seluruh Wilayah Desa',
                'urutan' => 4,
                'level_hierarki' => 2
            ],
            [
                'nik' => '3201010101010005',
                'nama' => 'Dr. Sari Indrawati',
                'jabatan' => 'Kasi Kesejahteraan',
                'bidang_tugas' => 'Kesejahteraan dan Pemberdayaan Masyarakat',
                'tugas_tanggung_jawab' => 'Mengelola program kesejahteraan dan pemberdayaan masyarakat',
                'mulai_tugas' => '2020-04-01',
                'status' => 'Aktif',
                'no_hp' => '081234567894',
                'email' => 'kasi.kesra@desa.id',
                'alamat' => 'Jl. Dahlia No. 5',
                'wilayah_kerja' => 'Seluruh Wilayah Desa',
                'urutan' => 5,
                'level_hierarki' => 2
            ],
            [
                'nik' => '3201010101010006',
                'nama' => 'Budi Santoso, S.Sos',
                'jabatan' => 'Kasi Pelayanan',
                'bidang_tugas' => 'Pelayanan Publik',
                'tugas_tanggung_jawab' => 'Mengelola pelayanan publik dan administrasi kependudukan',
                'mulai_tugas' => '2020-05-01',
                'status' => 'Aktif',
                'no_hp' => '081234567895',
                'email' => 'kasi.pelayanan@desa.id',
                'alamat' => 'Jl. Cempaka No. 18',
                'wilayah_kerja' => 'Seluruh Wilayah Desa',
                'urutan' => 6,
                'level_hierarki' => 2
            ]
        ];

        // Create Perangkat Desa records
        foreach ($perangkatData as $data) {
            PerangkatDesa::create($data);
        }

        $this->command->info('Sample Perangkat Desa data created successfully!');
    }
}
