<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Setting;

class SettingSeeder extends Seeder
{
    public function run(): void
    {
        Setting::updateOrCreate(
            [],
            [
                'nama_desa' => 'Desa Contoh',
                'kode_desa' => '001',
                'kecamatan' => 'Kecamatan Contoh',
                'kabupaten' => 'Kabupaten Contoh',
                'provinsi' => 'Provinsi Contoh',
                'kode_pos' => '12345',
                'alamat_kantor' => 'Jl. Raya Desa No. 1, Desa Contoh',
                'telepon' => '(021) 1234567',
                'email' => 'desa@contoh.go.id',
                'website' => 'https://desa-contoh.go.id',
                'kepala_desa' => 'Bapak Kepala Desa',
                'nip_kepala_desa' => '123456789012345678',
                'sekretaris_desa' => 'Bapak Sekretaris Desa',
                'nip_sekretaris' => '123456789012345679',
                'visi' => 'Mewujudkan desa yang maju, mandiri, dan sejahtera',
                'misi' => "1. Meningkatkan kualitas pelayanan publik\n2. Mengembangkan potensi ekonomi desa\n3. Memperkuat gotong royong masyarakat\n4. Melestarikan budaya dan lingkungan",
                'luas_wilayah' => 15.50,
                'jumlah_penduduk' => 5000,
                'jumlah_kk' => 1250,
                'jumlah_rt' => 25,
                'jumlah_rw' => 5,
                'jumlah_dusun' => 4,
                'latitude' => -6.200000,
                'longitude' => 106.816666,
                'jam_operasional' => [
                    'senin' => ['mulai' => '08:00', 'selesai' => '16:00', 'tutup' => false],
                    'selasa' => ['mulai' => '08:00', 'selesai' => '16:00', 'tutup' => false],
                    'rabu' => ['mulai' => '08:00', 'selesai' => '16:00', 'tutup' => false],
                    'kamis' => ['mulai' => '08:00', 'selesai' => '16:00', 'tutup' => false],
                    'jumat' => ['mulai' => '08:00', 'selesai' => '11:30', 'tutup' => false],
                    'sabtu' => ['mulai' => '08:00', 'selesai' => '12:00', 'tutup' => false],
                    'minggu' => ['mulai' => '', 'selesai' => '', 'tutup' => true]
                ],
                'media_sosial' => [
                    'facebook' => 'https://facebook.com/desa-contoh',
                    'instagram' => 'https://instagram.com/desa_contoh',
                    'whatsapp' => '6281234567890'
                ],
                'sejarah_desa' => 'Desa Contoh didirikan pada tahun 1945 dan memiliki sejarah panjang dalam perjuangan kemerdekaan Indonesia. Desa ini terkenal dengan keramahtamahan penduduknya dan potensi wisata alamnya.'
            ]
        );
    }
} 
