<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use App\Models\Role;

class SuperAdminSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Cek apakah superadmin sudah ada
        $superadmin = User::where('email', 'superadmin@aplikasidesa.com')
                         ->orWhere('role', 'superadmin')
                         ->first();

        if ($superadmin) {
            $this->command->info('SuperAdmin sudah ada: ' . $superadmin->email);
            return;
        }

        // Cari atau buat role superadmin
        $superAdminRole = Role::where('name', 'superadmin')->first();
        
        if (!$superAdminRole) {
            $superAdminRole = Role::create([
                'name' => 'superadmin',
                'display_name' => 'Super Administrator',
                'description' => 'Full access to all system features',
                'permissions' => [
                    'users.view', 'users.create', 'users.edit', 'users.delete',
                    'roles.view', 'roles.create', 'roles.edit', 'roles.delete',
                    'penduduk.view', 'penduduk.create', 'penduduk.edit', 'penduduk.delete',
                    'keluarga.view', 'keluarga.create', 'keluarga.edit', 'keluarga.delete',
                    'surat.view', 'surat.create', 'surat.edit', 'surat.delete',
                    'pengaduan.view', 'pengaduan.create', 'pengaduan.edit', 'pengaduan.delete',
                    'bantuan.view', 'bantuan.create', 'bantuan.edit', 'bantuan.delete',
                    'berita.view', 'berita.create', 'berita.edit', 'berita.delete',
                    'apbdes.view', 'apbdes.create', 'apbdes.edit', 'apbdes.delete', 'apbdes.verify',
                    'kegiatan.view', 'kegiatan.create', 'kegiatan.edit', 'kegiatan.delete',
                    'organisasi.view', 'organisasi.create', 'organisasi.edit', 'organisasi.delete',
                    'wilayah.view', 'wilayah.create', 'wilayah.edit', 'wilayah.delete',
                    'settings.view', 'settings.edit',
                    'dashboard.view', 'laporan.view'
                ],
                'is_active' => true
            ]);
        }

        // Buat user superadmin
        $user = User::create([
            'name' => 'Super Administrator',
            'email' => 'superadmin@aplikasidesa.com',
            'password' => Hash::make('SuperAdmin123!'),
            'role' => 'superadmin',
            'role_id' => $superAdminRole->id,
            'is_active' => true,
            'email_verified_at' => now()
        ]);

        $this->command->info('');
        $this->command->info('🎉 SuperAdmin berhasil dibuat!');
        $this->command->info('📧 Email: superadmin@aplikasidesa.com');
        $this->command->info('🔑 Password: SuperAdmin123!');
        $this->command->info('🚀 Akses: Full access ke semua fitur');
        $this->command->info('');
        $this->command->warn('⚠️  PENTING: Ubah password setelah login pertama!');
        $this->command->info('');
    }
} 