<?php
/**
 * Script untuk memastikan direktori UMKM storage tersedia
 * Jalankan script ini setelah deploy ke shared hosting
 */

// Set error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "=== UMKM Storage Setup Script ===\n";
echo "Memastikan direktori UMKM storage tersedia...\n\n";

// Paths
$storagePath = __DIR__ . '/../storage/app/public';
$publicStoragePath = __DIR__ . '/storage';

// Create UMKM and Product directories if they don't exist
$umkmDirs = [
    $storagePath . '/umkm',
    $storagePath . '/umkm/logo',
    $storagePath . '/umkm/galeri',
    $storagePath . '/produk',
    $storagePath . '/produk/galeri',
    $publicStoragePath . '/umkm',
    $publicStoragePath . '/umkm/logo', 
    $publicStoragePath . '/umkm/galeri',
    $publicStoragePath . '/produk',
    $publicStoragePath . '/produk/galeri'
];

foreach ($umkmDirs as $dir) {
    if (!is_dir($dir)) {
        if (mkdir($dir, 0755, true)) {
            echo "✓ Created directory: " . $dir . "\n";
        } else {
            echo "✗ Failed to create directory: " . $dir . "\n";
        }
    } else {
        echo "✓ Directory exists: " . $dir . "\n";
    }
}

// Create .htaccess files for security
$htaccessContent = "Options -Indexes\n<Files \"*\">\n    Require all granted\n</Files>\n<FilesMatch \"\\.(jpg|jpeg|png|gif|webp|svg)$\">\n    Require all granted\n</FilesMatch>\n";

$htaccessDirs = [
    $storagePath . '/umkm',
    $storagePath . '/umkm/logo',
    $storagePath . '/umkm/galeri',
    $storagePath . '/produk',
    $storagePath . '/produk/galeri',
    $publicStoragePath . '/umkm',
    $publicStoragePath . '/umkm/logo',
    $publicStoragePath . '/umkm/galeri',
    $publicStoragePath . '/produk',
    $publicStoragePath . '/produk/galeri'
];

foreach ($htaccessDirs as $dir) {
    $htaccessFile = $dir . '/.htaccess';
    if (!file_exists($htaccessFile)) {
        if (file_put_contents($htaccessFile, $htaccessContent)) {
            echo "✓ Created .htaccess: " . $htaccessFile . "\n";
        } else {
            echo "✗ Failed to create .htaccess: " . $htaccessFile . "\n";
        }
    } else {
        echo "✓ .htaccess exists: " . $htaccessFile . "\n";
    }
}

// Check storage symlink
if (is_link($publicStoragePath)) {
    echo "✓ Storage symlink exists\n";
} else {
    echo "! Storage symlink not found - please run: php artisan storage:link\n";
}

echo "\n=== Setup Complete ===\n";
echo "UMKM storage directories are ready!\n";
