/**
 * Global Modal Backdrop Fix
 * Mengatasi masalah modal backdrop yang tertinggal
 */

(function() {
    'use strict';
    
    // Function to forcefully clean modal backdrops
    window.forceCleanModalBackdrops = function() {
        // Remove all modal backdrops
        document.querySelectorAll('.modal-backdrop').forEach(el => el.remove());
        document.querySelectorAll('div.modal-backdrop').forEach(el => el.remove());
        document.querySelectorAll('div[class*="backdrop"]').forEach(el => el.remove());
        
        // Remove modal-open class from body
        document.body.classList.remove('modal-open');
        
        // Reset body styles
        document.body.style.overflow = '';
        document.body.style.paddingRight = '';
        document.body.style.marginRight = '';
        
        // Hide all modals
        document.querySelectorAll('.modal').forEach(modal => {
            modal.classList.remove('show');
            modal.style.display = 'none';
            modal.setAttribute('aria-hidden', 'true');
            modal.removeAttribute('aria-modal');
        });
        
        console.log('Modal backdrops cleaned (vanilla JS)');
    };
    
    // Clean up on DOM ready
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(window.forceCleanModalBackdrops, 100);
        });
    } else {
        setTimeout(window.forceCleanModalBackdrops, 100);
    }
    
    // Clean up on page load
    window.addEventListener('load', function() {
        setTimeout(window.forceCleanModalBackdrops, 200);
    });
    
    // Clean up on page visibility change
    document.addEventListener('visibilitychange', function() {
        if (!document.hidden) {
            setTimeout(window.forceCleanModalBackdrops, 100);
        }
    });
    
    // Clean up on window focus
    window.addEventListener('focus', function() {
        setTimeout(window.forceCleanModalBackdrops, 200);
    });
    
    // Periodic cleanup
    setInterval(function() {
        const visibleModals = document.querySelectorAll('.modal.show, .modal[style*="display: block"]');
        if (visibleModals.length === 0) {
            const backdrops = document.querySelectorAll('.modal-backdrop, div[class*="backdrop"]');
            if (backdrops.length > 0) {
                console.log('Periodic cleanup: removing ' + backdrops.length + ' orphaned backdrops');
                window.forceCleanModalBackdrops();
            }
        }
    }, 3000);
    
    // Override Bootstrap modal methods if available
    if (typeof bootstrap !== 'undefined' && bootstrap.Modal) {
        const originalHide = bootstrap.Modal.prototype.hide;
        bootstrap.Modal.prototype.hide = function() {
            originalHide.call(this);
            setTimeout(window.forceCleanModalBackdrops, 100);
        };
    }
    
})(); 