

<?php $__env->startSection('title', 'Detail Penduduk'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.penduduk.index')); ?>">Data Penduduk</a></li>
    <li class="breadcrumb-item active"><?php echo e($penduduk->nama); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Page Header -->
<div class="page-header mb-4">
    <div class="d-flex justify-content-between align-items-start">
        <div class="page-title-section">
            <div class="d-flex align-items-center mb-2">
                <div class="page-icon bg-primary text-white rounded-circle me-3">
                    <i class="fas fa-user"></i>
                </div>
                <div>
                    <h1 class="page-title mb-1"><?php echo e($penduduk->nama); ?></h1>
                    <p class="page-subtitle text-muted mb-0">
                        <i class="fas fa-id-card me-1"></i><?php echo e($penduduk->nik); ?>

                        <?php if($penduduk->status_hidup !== 'Hidup'): ?>
                            <span class="badge bg-danger ms-2"><?php echo e($penduduk->status_hidup); ?></span>
                        <?php endif; ?>
                    </p>
                </div>
            </div>
        </div>
        <div class="page-actions">
            <div class="btn-toolbar" role="toolbar">
                <div class="btn-group me-2" role="group">
                    <a href="<?php echo e(route('admin.penduduk.index')); ?>" class="btn btn-outline-secondary">
                        <i class="fas fa-arrow-left me-1"></i>
                        <span class="d-none d-sm-inline">Kembali</span>
                    </a>
                    <a href="<?php echo e(route('admin.penduduk.edit', $penduduk->id)); ?>" class="btn btn-warning">
                        <i class="fas fa-edit me-1"></i>
                        <span class="d-none d-sm-inline">Edit</span>
                    </a>
                </div>
                <div class="btn-group" role="group">
                    <button type="button" class="btn btn-primary dropdown-toggle" data-bs-toggle="dropdown">
                        <i class="fas fa-print me-1"></i>
                        <span class="d-none d-sm-inline">Cetak</span>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item" href="#" onclick="printKTP()">
                            <i class="fas fa-id-card me-2"></i>KTP
                        </a></li>
                        <li><a class="dropdown-item" href="#" onclick="printKK()">
                            <i class="fas fa-users me-2"></i>Kartu Keluarga
                        </a></li>
                        <li><a class="dropdown-item" href="#" onclick="printProfile()">
                            <i class="fas fa-user me-2"></i>Profil Lengkap
                        </a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- Main Profile -->
    <div class="col-lg-8">
        <!-- Personal Information -->
        <div class="card profile-card shadow-sm">
            <div class="card-body p-4">
                <div class="row">
                    <!-- Photo Section -->
                    <div class="col-lg-3 col-md-4 text-center">
                        <div class="profile-photo-section">
                            <div class="profile-photo-container mb-3">
                                <?php if($penduduk->foto): ?>
                                    <img src="<?php echo e(\App\Helpers\ImageHelper::getAvatarUrl($penduduk->foto, $penduduk->nama)); ?>" 
                                         class="profile-photo"
                                         alt="Foto <?php echo e($penduduk->nama); ?>"
                                         onclick="showPhotoModal('<?php echo e(\App\Helpers\ImageHelper::getAvatarUrl($penduduk->foto, $penduduk->nama)); ?>')">
                                <?php else: ?>
                                    <div class="profile-photo-placeholder">
                                        <div class="avatar-initials">
                                            <?php echo e(strtoupper(substr($penduduk->nama, 0, 2))); ?>

                                        </div>
                                    </div>
                                <?php endif; ?>
                                <div class="profile-status-badge">
                                    <span class="badge bg-<?php echo e($penduduk->status_hidup === 'Hidup' ? 'success' : 'danger'); ?>">
                                        <?php echo e($penduduk->status_hidup ?? 'Hidup'); ?>

                                    </span>
                                </div>
                            </div>
                            
                            <!-- Profile Summary -->
                            <div class="profile-summary mb-4">
                                <h4 class="profile-name mb-1"><?php echo e($penduduk->nama); ?></h4>
                                <p class="profile-nik text-muted mb-2"><?php echo e($penduduk->nik); ?></p>
                                <div class="profile-badges mb-3">
                                    <span class="badge bg-<?php echo e($penduduk->jenis_kelamin === 'L' ? 'primary' : 'pink'); ?> me-1">
                                        <?php echo e($penduduk->jenis_kelamin === 'L' ? 'Laki-laki' : 'Perempuan'); ?>

                                    </span>
                                    <?php if($penduduk->tanggal_lahir): ?>
                                        <span class="badge bg-info"><?php echo e($penduduk->tanggal_lahir->age); ?> tahun</span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <!-- Quick Contact Actions -->
                            <div class="profile-actions d-grid gap-2">
                                <?php if($penduduk->no_wa): ?>
                                    <button type="button" class="btn btn-success btn-sm" onclick="sendWhatsApp()">
                                        <i class="fab fa-whatsapp me-2"></i>
                                        WhatsApp
                                    </button>
                                <?php endif; ?>
                                <?php if($penduduk->latitude && $penduduk->longitude): ?>
                                    <button type="button" class="btn btn-info btn-sm" onclick="showOnMap()">
                                        <i class="fas fa-map-marker-alt me-2"></i>
                                        Lihat di Peta
                                    </button>
                                <?php endif; ?>
                                <button type="button" class="btn btn-outline-primary btn-sm" onclick="createSurat()">
                                    <i class="fas fa-file-plus me-2"></i>
                                    Buat Surat
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Personal Details -->
                    <div class="col-lg-9 col-md-8">
                        <div class="profile-details">
                            <div class="section-header mb-4">
                                <h5 class="section-title">
                                    <i class="fas fa-id-card me-2 text-primary"></i>
                                    Informasi Pribadi
                                </h5>
                            </div>
                            
                            <div class="row g-4">
                                <!-- Identitas -->
                                <div class="col-md-6">
                                    <div class="info-group">
                                        <h6 class="info-group-title">Identitas</h6>
                                        <div class="info-list">
                                            <div class="info-item">
                                                <span class="info-label">NIK</span>
                                                <span class="info-value"><?php echo e($penduduk->nik); ?></span>
                                            </div>
                                            <div class="info-item">
                                                <span class="info-label">No. KK</span>
                                                <span class="info-value">
                                                    <?php if($penduduk->keluarga): ?>
                                                        <a href="<?php echo e(route('admin.keluarga.show', $penduduk->keluarga->id)); ?>" 
                                                           class="text-primary text-decoration-none">
                                                            <?php echo e($penduduk->no_kk); ?>

                                                            <i class="fas fa-external-link-alt fa-xs ms-1"></i>
                                                        </a>
                                                    <?php else: ?>
                                                        <?php echo e($penduduk->no_kk ?? '-'); ?>

                                                    <?php endif; ?>
                                                </span>
                                            </div>
                                            <div class="info-item">
                                                <span class="info-label">Tempat, Tanggal Lahir</span>
                                                <span class="info-value">
                                                    <?php echo e($penduduk->tempat_lahir ?? '-'); ?>

                                                    <?php if($penduduk->tanggal_lahir): ?>
                                                        , <?php echo e($penduduk->tanggal_lahir->format('d F Y')); ?>

                                                    <?php endif; ?>
                                                </span>
                                            </div>
                                            <div class="info-item">
                                                <span class="info-label">Agama</span>
                                                <span class="info-value"><?php echo e($penduduk->agama ?? '-'); ?></span>
                                            </div>
                                            <div class="info-item">
                                                <span class="info-label">Kewarganegaraan</span>
                                                <span class="info-value"><?php echo e($penduduk->kewarganegaraan ?? 'WNI'); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Data Sosial -->
                                <div class="col-md-6">
                                    <div class="info-group">
                                        <h6 class="info-group-title">Data Sosial</h6>
                                        <div class="info-list">
                                            <div class="info-item">
                                                <span class="info-label">Pendidikan Terakhir</span>
                                                <span class="info-value"><?php echo e($penduduk->pendidikan_terakhir ?? '-'); ?></span>
                                            </div>
                                            <div class="info-item">
                                                <span class="info-label">Pekerjaan</span>
                                                <span class="info-value"><?php echo e($penduduk->pekerjaan ?? '-'); ?></span>
                                            </div>
                                            <div class="info-item">
                                                <span class="info-label">Status Perkawinan</span>
                                                <span class="info-value"><?php echo e($penduduk->status_kawin ?? 'Belum Kawin'); ?></span>
                                            </div>
                                            <div class="info-item">
                                                <span class="info-label">Golongan Darah</span>
                                                <span class="info-value">
                                                    <?php if($penduduk->golongan_darah): ?>
                                                        <span class="badge bg-danger"><?php echo e($penduduk->golongan_darah); ?></span>
                                                    <?php else: ?>
                                                        -
                                                    <?php endif; ?>
                                                </span>
                                            </div>
                                            <div class="info-item">
                                                <span class="info-label">Status Keluarga</span>
                                                <span class="info-value"><?php echo e($penduduk->status_keluarga ?? '-'); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Kontak -->
                                <div class="col-12">
                                    <div class="info-group">
                                        <h6 class="info-group-title">Informasi Kontak</h6>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="info-item">
                                                    <span class="info-label">No. WhatsApp</span>
                                                    <span class="info-value">
                                                        <?php if($penduduk->no_wa): ?>
                                                            <a href="https://wa.me/<?php echo e($penduduk->no_wa); ?>" target="_blank" 
                                                               class="text-success text-decoration-none">
                                                                <i class="fab fa-whatsapp me-1"></i><?php echo e($penduduk->no_wa); ?>

                                                            </a>
                                                        <?php else: ?>
                                                            -
                                                        <?php endif; ?>
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="info-item">
                                                    <span class="info-label">Email</span>
                                                    <span class="info-value">
                                                        <?php if($penduduk->email): ?>
                                                            <a href="mailto:<?php echo e($penduduk->email); ?>" class="text-primary text-decoration-none">
                                                                <i class="fas fa-envelope me-1"></i><?php echo e($penduduk->email); ?>

                                                            </a>
                                                        <?php else: ?>
                                                            -
                                                        <?php endif; ?>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Address Information -->
        <div class="card mt-4 shadow-sm">
            <div class="card-body p-4">
                <div class="section-header mb-4">
                    <h5 class="section-title">
                        <i class="fas fa-map-marker-alt me-2 text-primary"></i>
                        Informasi Alamat
                    </h5>
                </div>
                
                <div class="row g-4">
                    <div class="col-lg-6">
                        <div class="address-details">
                            <div class="info-list">
                                <div class="info-item">
                                    <span class="info-label">Alamat Lengkap</span>
                                    <span class="info-value"><?php echo e($penduduk->alamat ?? '-'); ?></span>
                                </div>
                                <div class="row">
                                    <div class="col-4">
                                        <div class="info-item">
                                            <span class="info-label">RT</span>
                                            <span class="info-value"><?php echo e($penduduk->rt ?? '-'); ?></span>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <div class="info-item">
                                            <span class="info-label">RW</span>
                                            <span class="info-value"><?php echo e($penduduk->rw ?? '-'); ?></span>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <div class="info-item">
                                            <span class="info-label">Dusun</span>
                                            <span class="info-value"><?php echo e($penduduk->dusun ?? '-'); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-6">
                        <?php if($penduduk->latitude && $penduduk->longitude): ?>
                        <div class="location-info">
                            <div class="coordinates-card bg-light rounded p-3">
                                <div class="d-flex align-items-center justify-content-between mb-3">
                                    <h6 class="mb-0">
                                        <i class="fas fa-crosshairs me-2 text-info"></i>
                                        Koordinat GPS
                                    </h6>
                                    <span class="badge bg-success">Tersedia</span>
                                </div>
                                <div class="row text-center mb-3">
                                    <div class="col-6">
                                        <div class="coordinate-item">
                                            <div class="coordinate-value"><?php echo e($penduduk->latitude); ?></div>
                                            <small class="text-muted">Latitude</small>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="coordinate-item">
                                            <div class="coordinate-value"><?php echo e($penduduk->longitude); ?></div>
                                            <small class="text-muted">Longitude</small>
                                        </div>
                                    </div>
                                </div>
                                <div class="d-grid gap-2">
                                    <button type="button" class="btn btn-outline-primary btn-sm" onclick="openInGoogleMaps()">
                                        <i class="fab fa-google me-2"></i>
                                        Buka di Google Maps
                                    </button>
                                    <button type="button" class="btn btn-outline-info btn-sm" onclick="getDirections()">
                                        <i class="fas fa-route me-2"></i>
                                        Petunjuk Arah
                                    </button>
                                </div>
                            </div>
                        </div>
                        <?php else: ?>
                        <div class="location-placeholder text-center p-4">
                            <div class="placeholder-icon mb-3">
                                <i class="fas fa-map-marker-alt fa-3x text-muted"></i>
                            </div>
                            <h6 class="text-muted mb-2">Koordinat Belum Diset</h6>
                            <p class="text-muted small mb-3">Koordinat GPS rumah belum tersedia</p>
                            <a href="<?php echo e(route('admin.penduduk.edit', $penduduk->id)); ?>" class="btn btn-outline-primary btn-sm">
                                <i class="fas fa-map-pin me-2"></i>
                                Set Koordinat
                            </a>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Family Information -->
        <?php if($penduduk->keluarga): ?>
        <div class="card mt-4 shadow-sm">
            <div class="card-body p-4">
                <div class="section-header mb-4">
                    <h5 class="section-title">
                        <i class="fas fa-users me-2 text-primary"></i>
                        Informasi Keluarga
                    </h5>
                </div>
                
                <div class="family-info">
                    <!-- Family Header -->
                    <div class="family-header bg-light rounded p-3 mb-4">
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="family-head-info">
                                <h6 class="mb-1">
                                    <i class="fas fa-crown text-warning me-2"></i>
                                    Kepala Keluarga: <?php echo e($penduduk->keluarga->kepala_keluarga->nama ?? '-'); ?>

                                </h6>
                                <p class="text-muted mb-0">
                                    <i class="fas fa-id-card me-1"></i>
                                    No. KK: <?php echo e($penduduk->keluarga->no_kk); ?>

                                </p>
                            </div>
                            <a href="<?php echo e(route('admin.keluarga.show', $penduduk->keluarga->id)); ?>" 
                               class="btn btn-outline-primary btn-sm">
                                <i class="fas fa-external-link-alt me-1"></i>
                                Detail Keluarga
                            </a>
                        </div>
                    </div>
                    
                    <!-- Family Members -->
                    <div class="family-members">
                        <h6 class="mb-3">
                            <i class="fas fa-users me-2"></i>
                            Anggota Keluarga (<?php echo e($penduduk->keluarga->anggota->count()); ?> orang)
                        </h6>
                        <div class="row g-3">
                            <?php $__currentLoopData = $penduduk->keluarga->anggota; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $anggota): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-lg-6">
                                <div class="member-card p-3 rounded <?php echo e($anggota->id === $penduduk->id ? 'border-primary bg-primary bg-opacity-10' : ''); ?>">
                                    <div class="d-flex align-items-center">
                                        <div class="member-avatar bg-<?php echo e($anggota->jenis_kelamin === 'L' ? 'primary' : 'pink'); ?> text-white rounded-circle me-3" 
                                             style="width: 45px; height: 45px;">
                                            <i class="fas fa-user"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="member-name fw-semibold"><?php echo e($anggota->nama); ?></div>
                                            <div class="member-relation text-muted small">
                                                <?php echo e($anggota->status_keluarga ?? 'Anggota Keluarga'); ?>

                                            </div>
                                            <div class="member-details text-muted small">
                                                <?php echo e($anggota->jenis_kelamin === 'L' ? 'Laki-laki' : 'Perempuan'); ?>

                                                <?php if($anggota->tanggal_lahir): ?>
                                                    • <?php echo e($anggota->tanggal_lahir->age); ?> tahun
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="member-actions">
                                            <?php if($anggota->id === $penduduk->id): ?>
                                                <span class="badge bg-primary">
                                                    <i class="fas fa-star me-1"></i>Anda
                                                </span>
                                            <?php else: ?>
                                                <a href="<?php echo e(route('admin.penduduk.show', $anggota->id)); ?>" 
                                                   class="btn btn-outline-info btn-sm">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php else: ?>
        <div class="card mt-4 shadow-sm">
            <div class="card-body p-4 text-center">
                <div class="empty-state py-4">
                    <i class="fas fa-users fa-3x text-muted mb-3"></i>
                    <h6 class="text-muted mb-2">Belum Terdaftar dalam Keluarga</h6>
                    <p class="text-muted small mb-3">Data keluarga belum tersedia atau belum terhubung</p>
                    <a href="<?php echo e(route('admin.penduduk.edit', $penduduk->id)); ?>" class="btn btn-outline-primary btn-sm">
                        <i class="fas fa-link me-2"></i>
                        Hubungkan ke Keluarga
                    </a>
                </div>
            </div>
        </div>
        <?php endif; ?>
        
        <!-- Services History -->
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-file-alt me-2"></i>
                    Riwayat Pelayanan
                </h5>
            </div>
            <div class="card-body">
                <?php if(isset($services) && $services->count() > 0): ?>
                <div class="services-timeline">
                    <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="service-item d-flex mb-3">
                        <div class="service-icon bg-<?php echo e($service->status_color); ?> rounded-circle me-3" style="width: 40px; height: 40px;">
                            <i class="fas fa-<?php echo e($service->type_icon); ?>"></i>
                        </div>
                        <div class="service-content">
                            <h6 class="mb-1"><?php echo e($service->jenis_layanan); ?></h6>
                            <p class="mb-1 text-muted"><?php echo e($service->keterangan); ?></p>
                            <div class="d-flex align-items-center gap-3">
                                <small class="text-muted">
                                    <i class="fas fa-calendar me-1"></i>
                                    <?php echo e($service->created_at->format('d M Y')); ?>

                                </small>
                                <span class="badge bg-<?php echo e($service->status_color); ?>"><?php echo e($service->status); ?></span>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <?php else: ?>
                <div class="text-center py-4">
                    <i class="fas fa-file-alt fa-3x text-muted mb-3"></i>
                    <h6 class="text-muted">Belum ada riwayat pelayanan</h6>
                    <p class="text-muted">Riwayat surat dan layanan akan muncul di sini</p>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <!-- Sidebar -->
    <div class="col-lg-4">
        <!-- Quick Stats -->
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-chart-bar me-2"></i>
                    Statistik
                </h6>
            </div>
            <div class="card-body">
                <div class="stats-grid">
                    <div class="stat-item text-center p-3 bg-primary bg-opacity-10 rounded mb-3">
                        <h4 class="mb-1 text-primary"><?php echo e($penduduk->umur); ?></h4>
                        <small class="text-muted">Tahun</small>
                    </div>
                    <div class="row">
                        <div class="col-6">
                            <div class="stat-item text-center p-2 bg-success bg-opacity-10 rounded">
                                <h5 class="mb-1 text-success"><?php echo e($stats['services'] ?? 0); ?></h5>
                                <small class="text-muted">Layanan</small>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="stat-item text-center p-2 bg-info bg-opacity-10 rounded">
                                <h5 class="mb-1 text-info"><?php echo e($stats['family_members'] ?? 0); ?></h5>
                                <small class="text-muted">Anggota KK</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Location Map -->
        <?php if($penduduk->latitude && $penduduk->longitude): ?>
        <div class="card mt-4">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-map me-2"></i>
                    Lokasi Rumah
                </h6>
            </div>
            <div class="card-body">
                <div id="locationMap" style="height: 250px; border-radius: 8px;"></div>
                <div class="mt-3 text-center">
                    <button type="button" class="btn btn-outline-primary btn-sm" onclick="getDirections()">
                        <i class="fas fa-route me-2"></i>
                        Petunjuk Arah
                    </button>
                </div>
            </div>
        </div>
        <?php endif; ?>
        
        <!-- Quick Actions -->
        <div class="card mt-4">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-bolt me-2"></i>
                    Aksi Cepat
                </h6>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <button type="button" class="btn btn-outline-success" onclick="createSurat()">
                        <i class="fas fa-file-plus me-2"></i>
                        Buat Surat
                    </button>
                    <button type="button" class="btn btn-outline-info" onclick="addBantuan()">
                        <i class="fas fa-hand-holding-heart me-2"></i>
                        Tambah Bantuan
                    </button>
                    <button type="button" class="btn btn-outline-warning" onclick="updateData()">
                        <i class="fas fa-sync me-2"></i>
                        Update Data
                    </button>
                    <button type="button" class="btn btn-outline-danger" onclick="reportProblem()">
                        <i class="fas fa-flag me-2"></i>
                        Laporkan Masalah
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Recent Activity -->
        <div class="card mt-4">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-history me-2"></i>
                    Aktivitas Terbaru
                </h6>
            </div>
            <div class="card-body">
                <div class="activity-timeline">
                    <?php $__currentLoopData = $recent_activities ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="activity-item d-flex mb-3">
                        <div class="activity-icon bg-<?php echo e($activity['color']); ?> rounded-circle me-2" style="width: 32px; height: 32px;">
                            <i class="fas fa-<?php echo e($activity['icon']); ?>"></i>
                        </div>
                        <div class="activity-content">
                            <p class="mb-1 small"><?php echo e($activity['message']); ?></p>
                            <small class="text-muted"><?php echo e($activity['time']); ?></small>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
        
        <!-- Password Management Section -->
        <div class="card mt-4">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-lock me-2"></i>
                    Manajemen Password Portal Warga
                </h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label">Status Password</label>
                            <div>
                                <?php if($penduduk->hasPassword()): ?>
                                    <?php if($penduduk->mustChangePassword()): ?>
                                        <span class="badge bg-warning">
                                            <i class="fas fa-exclamation-triangle me-1"></i>
                                            Harus Diganti
                                        </span>
                                    <?php else: ?>
                                        <span class="badge bg-success">
                                            <i class="fas fa-check-circle me-1"></i>
                                            Aktif
                                        </span>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <span class="badge bg-danger">
                                        <i class="fas fa-times-circle me-1"></i>
                                        Belum Diatur
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <?php if($penduduk->password_set_at): ?>
                        <div class="mb-3">
                            <label class="form-label">Password Diatur Pada</label>
                            <div class="text-muted">
                                <?php echo e($penduduk->password_set_at->format('d F Y, H:i')); ?> WIB
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <?php if($penduduk->last_login_at): ?>
                        <div class="mb-3">
                            <label class="form-label">Login Terakhir</label>
                            <div class="text-muted">
                                <?php echo e($penduduk->last_login_at->format('d F Y, H:i')); ?> WIB
                                <small class="text-muted">(<?php echo e($penduduk->last_login_at->diffForHumans()); ?>)</small>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="d-grid gap-2">
                            <?php if(!$penduduk->hasPassword()): ?>
                                <button type="button" class="btn btn-success" onclick="generateDefaultPassword('<?php echo e($penduduk->id); ?>')">
                                    <i class="fas fa-key me-2"></i>
                                    Generate Password Default
                                </button>
                            <?php else: ?>
                                <button type="button" class="btn btn-warning" onclick="resetPassword('<?php echo e($penduduk->id); ?>')">
                                    <i class="fas fa-redo me-2"></i>
                                    Reset Password
                                </button>
                            <?php endif; ?>
                            
                            <button type="button" class="btn btn-info" onclick="showPasswordModal('<?php echo e($penduduk->id); ?>', '<?php echo e($penduduk->nama); ?>', '<?php echo e($penduduk->nik); ?>')">
                                <i class="fas fa-edit me-2"></i>
                                Atur Password Custom
                            </button>
                            
                            <?php if($penduduk->hasPassword()): ?>
                                <button type="button" class="btn btn-outline-secondary" onclick="forcePasswordChange('<?php echo e($penduduk->id); ?>')">
                                    <i class="fas fa-exclamation-triangle me-2"></i>
                                    Paksa Ganti Password
                                </button>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <div class="alert alert-info mt-3">
                    <i class="fas fa-info-circle me-2"></i>
                    <strong>Informasi:</strong>
                    <ul class="mb-0 mt-2">
                        <li>Password default adalah 6 digit terakhir NIK (<?php echo e(substr($penduduk->nik, -6)); ?>)</li>
                        <li>Warga dapat login ke Portal Layanan Mandiri menggunakan NIK dan password</li>
                        <li>Password dapat diubah oleh admin atau warga sendiri setelah login</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Photo Modal -->
<div class="modal fade" id="photoModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Foto <?php echo e($penduduk->nama); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body text-center">
                <img id="modalPhoto" src="" class="img-fluid" alt="Foto Penduduk">
            </div>
        </div>
    </div>
</div>

<!-- Create Service Modal -->
<div class="modal fade" id="createServiceModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Buat Layanan Baru</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="createServiceForm">
                    <div class="mb-3">
                        <label class="form-label">Jenis Layanan</label>
                        <select class="form-select" name="service_type" required>
                            <option value="">Pilih Layanan</option>
                            <option value="surat_domisili">Surat Domisili</option>
                            <option value="surat_skck">SKCK</option>
                            <option value="surat_usaha">Surat Usaha</option>
                            <option value="bantuan_sosial">Bantuan Sosial</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Keterangan</label>
                        <textarea class="form-control" name="keterangan" rows="3" 
                                  placeholder="Keterangan tambahan..."></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                <button type="button" class="btn btn-primary" onclick="submitService()">Buat Layanan</button>
            </div>
        </div>
    </div>
</div>

<!-- Password Management Modal -->
<div class="modal fade" id="passwordModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Atur Password Custom</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="passwordForm">
                    <input type="hidden" id="penduduk_id" name="penduduk_id">
                    
                    <div class="mb-3">
                        <label class="form-label">Nama Penduduk</label>
                        <input type="text" id="penduduk_nama" class="form-control" readonly>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">NIK</label>
                        <input type="text" id="penduduk_nik" class="form-control" readonly>
                    </div>
                    
                    <div class="mb-3">
                        <label for="new_password" class="form-label">Password Baru</label>
                        <div class="input-group">
                            <input type="password" class="form-control" id="new_password" name="new_password" required minlength="6">
                            <button type="button" class="btn btn-outline-secondary" onclick="togglePasswordVisibility()">
                                <i class="fas fa-eye" id="toggleIcon"></i>
                            </button>
                        </div>
                        <small class="text-muted">Minimal 6 karakter</small>
                    </div>
                    
                    <div class="mb-3">
                        <label for="confirm_password" class="form-label">Konfirmasi Password</label>
                        <input type="password" class="form-control" id="confirm_password" name="confirm_password" required>
                    </div>
                    
                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" id="must_change" name="must_change">
                        <label class="form-check-label" for="must_change">
                            Paksa warga mengganti password saat login pertama
                        </label>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                <button type="button" class="btn btn-primary" onclick="setCustomPassword()">
                    <i class="fas fa-save me-2"></i>Simpan Password
                </button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    /* Page Header Styles */
    .page-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 2rem;
        border-radius: 12px;
        margin-bottom: 2rem;
    }
    
    .page-icon {
        width: 60px;
        height: 60px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 24px;
    }
    
    .page-title {
        font-size: 2rem;
        font-weight: 600;
        margin: 0;
    }
    
    .page-subtitle {
        font-size: 1rem;
        opacity: 0.9;
    }
    
    /* Profile Card Styles */
    .profile-card {
        border: none;
        border-radius: 16px;
    }
    
    .profile-photo-container {
        position: relative;
        display: inline-block;
    }
    
    .profile-photo {
        width: 180px;
        height: 180px;
        object-fit: cover;
        cursor: pointer;
        border-radius: 50%;
        border: 4px solid #fff;
        box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        transition: transform 0.3s ease;
    }
    
    .profile-photo:hover {
        transform: scale(1.05);
    }
    
    .profile-photo-placeholder {
        width: 180px;
        height: 180px;
        border: 3px dashed #dee2e6;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto;
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    }
    
    .avatar-initials {
        font-size: 3rem;
        font-weight: 600;
        color: #6c757d;
    }
    
    .profile-status-badge {
        position: absolute;
        bottom: 10px;
        right: 10px;
    }
    
    .profile-name {
        font-size: 1.75rem;
        font-weight: 600;
        color: #2c3e50;
    }
    
    .profile-nik {
        font-size: 1rem;
        font-family: 'Courier New', monospace;
    }
    
    .profile-badges .badge {
        font-size: 0.875rem;
        padding: 0.5rem 0.75rem;
    }
    
    /* Section Styles */
    .section-header {
        border-bottom: 2px solid #f8f9fa;
        padding-bottom: 1rem;
    }
    
    .section-title {
        font-size: 1.25rem;
        font-weight: 600;
        color: #2c3e50;
        margin: 0;
    }
    
    /* Info Group Styles */
    .info-group {
        background: #f8f9fa;
        border-radius: 12px;
        padding: 1.5rem;
        height: 100%;
    }
    
    .info-group-title {
        font-size: 1rem;
        font-weight: 600;
        color: #495057;
        margin-bottom: 1rem;
        padding-bottom: 0.5rem;
        border-bottom: 2px solid #dee2e6;
    }
    
    .info-list {
        display: flex;
        flex-direction: column;
        gap: 1rem;
    }
    
    .info-item {
        display: flex;
        flex-direction: column;
        gap: 0.25rem;
    }
    
    .info-label {
        font-size: 0.875rem;
        font-weight: 500;
        color: #6c757d;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .info-value {
        font-size: 1rem;
        font-weight: 500;
        color: #2c3e50;
        word-break: break-word;
    }
    
    /* Address Styles */
    .address-details {
        background: #f8f9fa;
        border-radius: 12px;
        padding: 1.5rem;
        height: 100%;
    }
    
    .coordinates-card {
        border: 1px solid #dee2e6;
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    }
    
    .coordinate-item {
        padding: 0.5rem;
    }
    
    .coordinate-value {
        font-size: 1rem;
        font-weight: 600;
        color: #2c3e50;
        font-family: 'Courier New', monospace;
    }
    
    .location-placeholder {
        border: 2px dashed #dee2e6;
        border-radius: 12px;
        background: #f8f9fa;
    }
    
    .placeholder-icon {
        opacity: 0.5;
    }
    
    /* Family Card Styles */
    .family-header {
        border: 1px solid #e9ecef;
    }
    
    .member-card {
        transition: all 0.3s ease;
        border: 1px solid #dee2e6;
        background: white;
    }
    
    .member-card:hover {
        box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        transform: translateY(-2px);
    }
    
    .member-avatar {
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 16px;
    }
    
    .member-name {
        font-size: 1rem;
        color: #2c3e50;
    }
    
    .member-relation {
        font-weight: 500;
        color: #6c757d !important;
    }
    
    .member-details {
        color: #868e96 !important;
    }
    
    .empty-state {
        padding: 2rem;
    }
    
    .avatar {
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 12px;
    }
    
    /* Activity Styles */
    .activity-icon, .service-icon {
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 14px;
        min-width: 40px;
        min-height: 40px;
    }
    
    .services-timeline {
        max-height: 400px;
        overflow-y: auto;
    }
    
    /* Statistics Styles */
    .stat-item {
        transition: all 0.3s ease;
        border-radius: 12px;
        border: 1px solid transparent;
    }
    
    .stat-item:hover {
        transform: translateY(-3px);
        box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        border-color: #dee2e6;
    }
    
    /* Utility Classes */
    .bg-pink {
        background-color: #e83e8c !important;
    }
    
    .shadow-sm {
        box-shadow: 0 2px 8px rgba(0,0,0,0.08) !important;
    }
    
    /* Responsive Design */
    @media (max-width: 768px) {
        .page-header {
            padding: 1.5rem;
        }
        
        .page-title {
            font-size: 1.5rem;
        }
        
        .profile-photo, .profile-photo-placeholder {
            width: 150px;
            height: 150px;
        }
        
        .avatar-initials {
            font-size: 2.5rem;
        }
        
        .profile-name {
            font-size: 1.5rem;
        }
        
        .info-group {
            padding: 1rem;
        }
        
        .btn-toolbar {
            flex-direction: column;
            gap: 0.5rem;
        }
        
        .btn-group {
            width: 100%;
        }
    }
    
    /* Animation */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    .card {
        animation: fadeInUp 0.6s ease-out;
    }
    
    .card:nth-child(2) { animation-delay: 0.1s; }
    .card:nth-child(3) { animation-delay: 0.2s; }
    .card:nth-child(4) { animation-delay: 0.3s; }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
let map;
const pendudukId = <?php echo e($penduduk->id); ?>;
const latitude = <?php echo e($penduduk->latitude ?? 'null'); ?>;
const longitude = <?php echo e($penduduk->longitude ?? 'null'); ?>;

$(document).ready(function() {
    // Initialize map if coordinates exist
    if (latitude && longitude) {
        initMap();
    }
});

// Initialize map
function initMap() {
    map = L.map('locationMap').setView([latitude, longitude], 16);
    
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '© OpenStreetMap contributors'
    }).addTo(map);
    
    // Add marker
    const marker = L.marker([latitude, longitude]).addTo(map);
    marker.bindPopup(`
        <strong><?php echo e($penduduk->nama); ?></strong><br>
        <?php echo e($penduduk->alamat); ?><br>
        Dusun <?php echo e($penduduk->dusun); ?>, RT <?php echo e($penduduk->rt); ?>/RW <?php echo e($penduduk->rw); ?>

    `).openPopup();
}

// Show photo modal
function showPhotoModal(src) {
    document.getElementById('modalPhoto').src = src;
    $('#photoModal').modal('show');
}

// Send WhatsApp
function sendWhatsApp() {
    <?php if($penduduk->no_wa): ?>
    const message = encodeURIComponent('Halo <?php echo e($penduduk->nama); ?>, ');
    window.open(`https://wa.me/<?php echo e($penduduk->no_wa); ?>?text=${message}`, '_blank');
    <?php else: ?>
    showToast('Nomor WhatsApp tidak tersedia', 'warning');
    <?php endif; ?>
}

// Show on map
function showOnMap() {
    <?php if($penduduk->latitude && $penduduk->longitude): ?>
    window.location.href = `/admin/peta?lat=<?php echo e($penduduk->latitude); ?>&lng=<?php echo e($penduduk->longitude); ?>&zoom=16&highlight=penduduk_<?php echo e($penduduk->id); ?>`;
    <?php else: ?>
    showToast('Koordinat rumah belum diset', 'warning');
    <?php endif; ?>
}

// Open in Google Maps
function openInGoogleMaps() {
    <?php if($penduduk->latitude && $penduduk->longitude): ?>
    window.open(`https://www.google.com/maps?q=<?php echo e($penduduk->latitude); ?>,<?php echo e($penduduk->longitude); ?>`, '_blank');
    <?php else: ?>
    showToast('Koordinat rumah belum diset', 'warning');
    <?php endif; ?>
}

// Get directions
function getDirections() {
    <?php if($penduduk->latitude && $penduduk->longitude): ?>
    window.open(`https://www.google.com/maps/dir/?api=1&destination=<?php echo e($penduduk->latitude); ?>,<?php echo e($penduduk->longitude); ?>`, '_blank');
    <?php else: ?>
    showToast('Koordinat rumah belum diset', 'warning');
    <?php endif; ?>
}

// Print functions
function printKTP() {
    window.open(`/admin/penduduk/<?php echo e($penduduk->id); ?>/print-ktp`, '_blank');
}

function printKK() {
    <?php if($penduduk->keluarga): ?>
    window.open(`/admin/keluarga/<?php echo e($penduduk->keluarga->id); ?>/print-kk`, '_blank');
    <?php else: ?>
    showToast('Data keluarga tidak tersedia', 'warning');
    <?php endif; ?>
}

function printProfile() {
    window.open(`/admin/penduduk/<?php echo e($penduduk->id); ?>/print-profile`, '_blank');
}

// Quick actions
function createSurat() {
    $('#createServiceModal').modal('show');
}

function addBantuan() {
    window.location.href = `/admin/bantuan/create?penduduk_id=<?php echo e($penduduk->id); ?>`;
}

function updateData() {
    window.location.href = `/admin/penduduk/<?php echo e($penduduk->id); ?>/edit`;
}

function reportProblem() {
    window.location.href = `/admin/pengaduan/create?penduduk_id=<?php echo e($penduduk->id); ?>`;
}

// Submit service
function submitService() {
    const form = document.getElementById('createServiceForm');
    const formData = new FormData(form);
    formData.append('penduduk_id', pendudukId);
    
    showLoading();
    
    fetch('/admin/services', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showToast('Layanan berhasil dibuat', 'success');
            $('#createServiceModal').modal('hide');
            setTimeout(() => location.reload(), 1500);
        } else {
            showToast(data.message || 'Gagal membuat layanan', 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showToast('Terjadi kesalahan', 'error');
    })
    .finally(() => {
        hideLoading();
    });
}

// Password Management Functions
function generateDefaultPassword(pendudukId) {
    if (confirm('Generate password default untuk penduduk ini?\n\nPassword akan diatur menjadi 6 digit terakhir NIK.')) {
        fetch(`/admin/penduduk/${pendudukId}/generate-password`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert(`Password berhasil digenerate!\n\nPassword: ${data.password}\n\nSilakan berikan password ini kepada warga.`);
                location.reload();
            } else {
                alert('Gagal generate password: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Terjadi kesalahan saat generate password');
        });
    }
}

function resetPassword(pendudukId) {
    if (confirm('Reset password ke default (6 digit terakhir NIK)?\n\nPassword lama akan dihapus dan diganti dengan password default.')) {
        fetch(`/admin/penduduk/${pendudukId}/reset-password`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert(`Password berhasil direset!\n\nPassword baru: ${data.password}\n\nSilakan berikan password ini kepada warga.`);
                location.reload();
            } else {
                alert('Gagal reset password: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Terjadi kesalahan saat reset password');
        });
    }
}

function showPasswordModal(pendudukId, nama, nik) {
    document.getElementById('penduduk_id').value = pendudukId;
    document.getElementById('penduduk_nama').value = nama;
    document.getElementById('penduduk_nik').value = nik;
    document.getElementById('new_password').value = '';
    document.getElementById('confirm_password').value = '';
    document.getElementById('must_change').checked = false;
    
    new bootstrap.Modal(document.getElementById('passwordModal')).show();
}

function setCustomPassword() {
    const form = document.getElementById('passwordForm');
    const formData = new FormData(form);
    
    const newPassword = document.getElementById('new_password').value;
    const confirmPassword = document.getElementById('confirm_password').value;
    
    if (newPassword !== confirmPassword) {
        alert('Password dan konfirmasi password tidak sama!');
        return;
    }
    
    if (newPassword.length < 6) {
        alert('Password minimal 6 karakter!');
        return;
    }
    
    const pendudukId = document.getElementById('penduduk_id').value;
    
    fetch(`/admin/penduduk/${pendudukId}/set-password`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify({
            password: newPassword,
            must_change: document.getElementById('must_change').checked
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('Password berhasil diatur!');
            bootstrap.Modal.getInstance(document.getElementById('passwordModal')).hide();
            location.reload();
        } else {
            alert('Gagal mengatur password: ' + data.message);
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Terjadi kesalahan saat mengatur password');
    });
}

function forcePasswordChange(pendudukId) {
    if (confirm('Paksa warga untuk mengganti password saat login berikutnya?')) {
        fetch(`/admin/penduduk/${pendudukId}/force-password-change`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Berhasil! Warga akan diminta mengganti password saat login berikutnya.');
                location.reload();
            } else {
                alert('Gagal: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Terjadi kesalahan');
        });
    }
}

function togglePasswordVisibility() {
    const passwordInput = document.getElementById('new_password');
    const toggleIcon = document.getElementById('toggleIcon');
    
    if (passwordInput.type === 'password') {
        passwordInput.type = 'text';
        toggleIcon.className = 'fas fa-eye-slash';
    } else {
        passwordInput.type = 'password';
        toggleIcon.className = 'fas fa-eye';
    }
}
</script>
<?php $__env->stopPush(); ?> 

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/penduduk/show.blade.php ENDPATH**/ ?>