

<?php $__env->startSection('title', 'Edit Pengaduan'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="mb-2">
                <i class="fas fa-edit me-2 text-primary"></i>Edit Pengaduan
            </h2>
            <p class="text-muted mb-0">Edit pengaduan #<?php echo e($pengaduan->id ?? '1'); ?></p>
        </div>
        <div>
            <a href="<?php echo e(route('admin.pengaduan.index')); ?>" class="btn btn-outline-secondary me-2">
                <i class="fas fa-arrow-left me-2"></i>Kembali
            </a>
            <a href="<?php echo e(route('admin.pengaduan.show', $pengaduan->id ?? 1)); ?>" class="btn btn-outline-info">
                <i class="fas fa-eye me-2"></i>Lihat Detail
            </a>
        </div>
    </div>

    <form id="editPengaduanForm" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        <div class="row">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-exclamation-triangle me-2"></i>Edit Pengaduan
                        </h5>
                    </div>
                    <div class="card-body">
                        <!-- Kategori Pengaduan -->
                        <div class="mb-4">
                            <label class="form-label required">Kategori Pengaduan</label>
                            <select class="form-select" name="kategori" required>
                                <option value="">Pilih Kategori</option>
                                <option value="infrastruktur" <?php echo e(($pengaduan->kategori ?? '') === 'infrastruktur' ? 'selected' : ''); ?>>Infrastruktur</option>
                                <option value="kebersihan" <?php echo e(($pengaduan->kategori ?? '') === 'kebersihan' ? 'selected' : ''); ?>>Kebersihan</option>
                                <option value="keamanan" <?php echo e(($pengaduan->kategori ?? '') === 'keamanan' ? 'selected' : ''); ?>>Keamanan</option>
                                <option value="pelayanan" <?php echo e(($pengaduan->kategori ?? '') === 'pelayanan' ? 'selected' : ''); ?>>Pelayanan</option>
                                <option value="lainnya" <?php echo e(($pengaduan->kategori ?? '') === 'lainnya' ? 'selected' : ''); ?>>Lainnya</option>
                            </select>
                        </div>
                        
                        <!-- Pelapor -->
                        <div class="mb-4">
                            <label class="form-label required">Pelapor</label>
                            <select class="form-select" name="pelapor_id" required id="pelaporSelect">
                                <option value="">Pilih Pelapor</option>
                                <?php $__currentLoopData = $penduduk ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($p->id); ?>" 
                                        <?php echo e(($pengaduan->pelapor_id ?? '') == $p->id ? 'selected' : ''); ?>

                                        data-nama="<?php echo e($p->nama); ?>" 
                                        data-nik="<?php echo e($p->nik); ?>" 
                                        data-alamat="<?php echo e($p->alamat); ?>" 
                                        data-telepon="<?php echo e($p->telepon); ?>">
                                    <?php echo e($p->nama); ?> - <?php echo e($p->nik); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <div class="form-text">Pilih warga yang melaporkan pengaduan</div>
                        </div>
                        
                        <!-- Judul Pengaduan -->
                        <div class="mb-4">
                            <label class="form-label required">Judul Pengaduan</label>
                            <input type="text" class="form-control" name="judul" required 
                                   value="<?php echo e($pengaduan->judul ?? ''); ?>"
                                   placeholder="Masukkan judul pengaduan...">
                        </div>
                        
                        <!-- Deskripsi -->
                        <div class="mb-4">
                            <label class="form-label required">Deskripsi</label>
                            <textarea class="form-control" name="deskripsi" rows="5" required
                                      placeholder="Jelaskan detail pengaduan..."><?php echo e($pengaduan->deskripsi ?? ''); ?></textarea>
                        </div>
                        
                        <!-- Lokasi Kejadian -->
                        <div class="mb-4">
                            <label class="form-label">Lokasi Kejadian</label>
                            <input type="text" class="form-control" name="lokasi" 
                                   value="<?php echo e($pengaduan->lokasi ?? ''); ?>"
                                   placeholder="Masukkan lokasi kejadian...">
                        </div>
                        
                        <!-- Status -->
                        <div class="mb-4">
                            <label class="form-label">Status Pengaduan</label>
                            <select class="form-select" name="status" id="statusSelect">
                                <option value="pending" <?php echo e(($pengaduan->status ?? 'pending') === 'pending' ? 'selected' : ''); ?>>Pending</option>
                                <option value="diproses" <?php echo e(($pengaduan->status ?? '') === 'diproses' ? 'selected' : ''); ?>>Diproses</option>
                                <option value="selesai" <?php echo e(($pengaduan->status ?? '') === 'selesai' ? 'selected' : ''); ?>>Selesai</option>
                                <option value="ditolak" <?php echo e(($pengaduan->status ?? '') === 'ditolak' ? 'selected' : ''); ?>>Ditolak</option>
                            </select>
                        </div>
                        
                        <!-- Tanggapan -->
                        <div class="mb-4">
                            <label class="form-label">Tanggapan</label>
                            <textarea class="form-control" name="tanggapan" rows="4"
                                      placeholder="Tulis tanggapan untuk pengaduan ini..."><?php echo e($pengaduan->tanggapan ?? ''); ?></textarea>
                            <div class="form-text">Tanggapan ini akan dikirim ke pelapor</div>
                        </div>
                        
                        <!-- Target Selesai -->
                        <div class="mb-4">
                            <label class="form-label">Target Selesai</label>
                            <input type="date" class="form-control" name="target_selesai" 
                                   value="<?php echo e($pengaduan->target_selesai ? \Carbon\Carbon::parse($pengaduan->target_selesai)->format('Y-m-d') : ''); ?>">
                        </div>
                        
                        <!-- Upload Foto Tambahan -->
                        <div class="mb-4">
                            <label class="form-label">Foto Pendukung Tambahan</label>
                            <div class="border rounded p-3">
                                <input type="file" class="form-control" name="foto[]" multiple accept="image/*" id="fotoInput">
                                <div class="form-text">
                                    <i class="fas fa-info-circle me-1"></i>
                                    Upload foto tambahan jika ada (opsional, maksimal 5 file)
                                </div>
                                
                                <?php if(isset($pengaduan->foto) && $pengaduan->foto): ?>
                                <div class="mt-2">
                                    <small class="text-muted">Foto yang sudah ada:</small>
                                    <div class="row mt-2">
                                        <?php $__currentLoopData = json_decode($pengaduan->foto, true) ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $foto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-md-3 mb-2">
                                            <div class="card">
                                                <img src="<?php echo e(Storage::url($foto)); ?>" class="card-img-top" style="height: 100px; object-fit: cover;">
                                                <div class="card-body p-2">
                                                    <small class="text-muted"><?php echo e(basename($foto)); ?></small>
                                                </div>
                                            </div>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                                <?php endif; ?>
                                
                                <div id="fotoPreview" class="mt-2"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-4">
                <!-- Info Pelapor -->
                <div class="card">
                    <div class="card-header">
                        <h6 class="card-title mb-0">
                            <i class="fas fa-user me-2"></i>Info Pelapor
                        </h6>
                    </div>
                    <div class="card-body" id="infoPelapor">
                        <?php if(isset($pengaduan->pelapor)): ?>
                        <div class="text-center">
                            <div class="bg-primary text-white rounded-circle mx-auto mb-3 d-flex align-items-center justify-content-center" 
                                 style="width: 60px; height: 60px;">
                                <i class="fas fa-user fa-lg"></i>
                            </div>
                            <h6 class="mb-2"><?php echo e($pengaduan->pelapor->nama); ?></h6>
                            <div class="small text-muted">
                                <div class="mb-1"><strong>NIK:</strong> <?php echo e($pengaduan->pelapor->nik); ?></div>
                                <div class="mb-1"><strong>Alamat:</strong> <?php echo e($pengaduan->pelapor->alamat); ?></div>
                                <div><strong>Telepon:</strong> <?php echo e($pengaduan->pelapor->telepon ?: 'Belum diisi'); ?></div>
                            </div>
                        </div>
                        <?php else: ?>
                        <div class="text-center text-muted py-4">
                            <i class="fas fa-user fa-3x mb-3"></i>
                            <p>Pilih pelapor untuk melihat informasi</p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <!-- Timeline Status -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h6 class="card-title mb-0">
                            <i class="fas fa-history me-2"></i>Timeline Proses
                        </h6>
                    </div>
                    <div class="card-body">
                        <div class="timeline">
                            <div class="timeline-item completed">
                                <div class="timeline-marker"></div>
                                <div class="timeline-content">
                                    <h6 class="timeline-title">Pengaduan Diterima</h6>
                                    <p class="timeline-time"><?php echo e(isset($pengaduan->created_at) ? $pengaduan->created_at->format('d M Y H:i') : 'Belum tersedia'); ?></p>
                                </div>
                            </div>
                            
                            <div class="timeline-item <?php echo e(in_array($pengaduan->status ?? 'pending', ['diproses', 'selesai']) ? 'completed' : ''); ?>">
                                <div class="timeline-marker"></div>
                                <div class="timeline-content">
                                    <h6 class="timeline-title">Sedang Diproses</h6>
                                    <p class="timeline-time">
                                        <?php if(in_array($pengaduan->status ?? 'pending', ['diproses', 'selesai'])): ?>
                                            <?php echo e(isset($pengaduan->updated_at) ? $pengaduan->updated_at->format('d M Y H:i') : 'Belum tersedia'); ?>

                                        <?php else: ?>
                                            -
                                        <?php endif; ?>
                                    </p>
                                </div>
                            </div>
                            
                            <div class="timeline-item <?php echo e(($pengaduan->status ?? '') === 'selesai' ? 'completed' : ''); ?>">
                                <div class="timeline-marker"></div>
                                <div class="timeline-content">
                                    <h6 class="timeline-title">Selesai</h6>
                                    <p class="timeline-time">
                                        <?php if(($pengaduan->status ?? '') === 'selesai'): ?>
                                            <?php echo e(isset($pengaduan->updated_at) ? $pengaduan->updated_at->format('d M Y H:i') : 'Belum tersedia'); ?>

                                        <?php else: ?>
                                            -
                                        <?php endif; ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Informasi Sistem -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h6 class="card-title mb-0">
                            <i class="fas fa-info-circle me-2"></i>Informasi Sistem
                        </h6>
                    </div>
                    <div class="card-body">
                        <div class="small">
                            <div class="d-flex justify-content-between mb-2">
                                <span>ID Pengaduan</span>
                                <span class="fw-bold">#<?php echo e($pengaduan->id ?? '1'); ?></span>
                            </div>
                            <div class="d-flex justify-content-between mb-2">
                                <span>Dibuat</span>
                                <span class="fw-bold"><?php echo e(isset($pengaduan->created_at) ? $pengaduan->created_at->format('d/m/Y H:i') : 'Belum tersedia'); ?></span>
                            </div>
                            <div class="d-flex justify-content-between mb-2">
                                <span>Diperbarui</span>
                                <span class="fw-bold"><?php echo e(isset($pengaduan->updated_at) ? $pengaduan->updated_at->format('d/m/Y H:i') : 'Belum tersedia'); ?></span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Actions -->
                <div class="card mt-4">
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-save me-2"></i>Update Pengaduan
                            </button>
                            <button type="button" class="btn btn-outline-warning" onclick="resetChanges()">
                                <i class="fas fa-undo me-2"></i>Batalkan Perubahan
                            </button>
                            <a href="<?php echo e(route('admin.pengaduan.show', $pengaduan->id ?? 1)); ?>" class="btn btn-outline-info">
                                <i class="fas fa-eye me-2"></i>Lihat Detail
                            </a>
                        </div>
                    </div>
                </div>
                
                <!-- Delete Section -->
                <div class="card mt-4 border-danger">
                    <div class="card-body">
                        <h6 class="text-danger">
                            <i class="fas fa-exclamation-triangle me-2"></i>Zona Bahaya
                        </h6>
                        <p class="text-muted mb-3">Hapus pengaduan secara permanen.</p>
                        <button type="button" class="btn btn-danger btn-sm" onclick="deletePengaduan()">
                            <i class="fas fa-trash me-2"></i>Hapus Pengaduan
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .required::after {
        content: ' *';
        color: #dc3545;
    }
    
    .timeline {
        position: relative;
        padding-left: 30px;
    }

    .timeline::before {
        content: '';
        position: absolute;
        left: 9px;
        top: 0;
        bottom: 0;
        width: 2px;
        background: #dee2e6;
    }

    .timeline-item {
        position: relative;
        margin-bottom: 20px;
    }

    .timeline-marker {
        position: absolute;
        left: -25px;
        top: 5px;
        width: 18px;
        height: 18px;
        border-radius: 50%;
        background: #dee2e6;
        border: 3px solid white;
    }

    .timeline-item.completed .timeline-marker {
        background: #28a745;
    }

    .timeline-title {
        font-size: 14px;
        margin-bottom: 5px;
    }

    .timeline-time {
        font-size: 12px;
        color: #6c757d;
        margin: 0;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
const pengaduanId = <?php echo e($pengaduan->id ?? 1); ?>;

$(document).ready(function() {
    $('#pelaporSelect').on('change', function() {
        updateInfoPelapor();
    });
    
    $('#fotoInput').on('change', function() {
        previewFotos(this);
    });
});

function updateInfoPelapor() {
    const select = document.getElementById('pelaporSelect');
    const selectedOption = select.options[select.selectedIndex];
    
    if (selectedOption.value) {
        const nama = selectedOption.dataset.nama;
        const nik = selectedOption.dataset.nik;
        const alamat = selectedOption.dataset.alamat;
        const telepon = selectedOption.dataset.telepon;
        
        document.getElementById('infoPelapor').innerHTML = `
            <div class="text-center">
                <div class="bg-primary text-white rounded-circle mx-auto mb-3 d-flex align-items-center justify-content-center" 
                     style="width: 60px; height: 60px;">
                    <i class="fas fa-user fa-lg"></i>
                </div>
                <h6 class="mb-2">${nama}</h6>
                <div class="small text-muted">
                    <div class="mb-1"><strong>NIK:</strong> ${nik}</div>
                    <div class="mb-1"><strong>Alamat:</strong> ${alamat || 'Belum diisi'}</div>
                    <div><strong>Telepon:</strong> ${telepon || 'Belum diisi'}</div>
                </div>
            </div>
        `;
    } else {
        document.getElementById('infoPelapor').innerHTML = `
            <div class="text-center text-muted py-4">
                <i class="fas fa-user fa-3x mb-3"></i>
                <p>Pilih pelapor untuk melihat informasi</p>
            </div>
        `;
    }
}

function previewFotos(input) {
    const files = Array.from(input.files);
    const preview = document.getElementById('fotoPreview');
    
    if (files.length === 0) {
        preview.innerHTML = '';
        return;
    }
    
    let html = '<div class="row mt-2">';
    files.forEach((file, index) => {
        if (file.type.startsWith('image/')) {
            const fileSize = (file.size / 1024 / 1024).toFixed(2);
            html += `
                <div class="col-md-6 mb-2">
                    <div class="card">
                        <div class="card-body p-2">
                            <div class="d-flex align-items-center">
                                <i class="fas fa-image text-success me-2"></i>
                                <div class="flex-grow-1">
                                    <div class="fw-medium small">${file.name}</div>
                                    <small class="text-muted">${fileSize} MB</small>
                                </div>
                                <button type="button" class="btn btn-sm btn-outline-danger" onclick="removeFoto(${index})">
                                    <i class="fas fa-times"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            `;
        }
    });
    html += '</div>';
    
    preview.innerHTML = html;
}

function removeFoto(index) {
    const input = document.getElementById('fotoInput');
    const dt = new DataTransfer();
    const files = Array.from(input.files);
    
    files.forEach((file, i) => {
        if (i !== index) dt.items.add(file);
    });
    
    input.files = dt.files;
    previewFotos(input);
}

function resetChanges() {
    if (confirm('Apakah Anda yakin ingin membatalkan semua perubahan?')) {
        location.reload();
    }
}

function deletePengaduan() {
    if (confirm('Apakah Anda yakin ingin menghapus pengaduan ini?\n\nTindakan ini tidak dapat dibatalkan.')) {
        showLoading();
        
        fetch(`/admin/pengaduan/${pengaduanId}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showToast('Pengaduan berhasil dihapus', 'success');
                setTimeout(() => {
                    window.location.href = '<?php echo e(route("admin.pengaduan.index")); ?>';
                }, 1500);
            } else {
                showToast(data.message || 'Gagal menghapus pengaduan', 'error');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showToast('Terjadi kesalahan', 'error');
        })
        .finally(() => {
            hideLoading();
        });
    }
}

document.getElementById('editPengaduanForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    showLoading();
    
    fetch(`<?php echo e(route('admin.pengaduan.update', $pengaduan->id ?? 1)); ?>`, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showToast('Pengaduan berhasil diperbarui', 'success');
            setTimeout(() => {
                window.location.href = '<?php echo e(route("admin.pengaduan.index")); ?>';
            }, 1500);
        } else {
            showToast(data.message || 'Gagal memperbarui pengaduan', 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showToast('Terjadi kesalahan', 'error');
    })
    .finally(() => {
        hideLoading();
    });
});
</script>
<?php $__env->stopPush(); ?> 

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/pengaduan/edit.blade.php ENDPATH**/ ?>