

<?php $__env->startSection('title', 'Edit Produk UMKM'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Edit Produk UMKM</h1>
        <a href="<?php echo e(route('admin.produk-umkm.show', $produk->id)); ?>" class="btn btn-secondary btn-sm">
            <i class="fas fa-arrow-left"></i> Kembali
        </a>
    </div>

    <form action="<?php echo e(route('admin.produk-umkm.update', $produk->id)); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        
        <div class="row">
            <!-- Main Form -->
            <div class="col-lg-8">
                <!-- Basic Information -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Informasi Produk</h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="nama_produk">Nama Produk <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control <?php $__errorArgs = ['nama_produk'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="nama_produk" name="nama_produk" value="<?php echo e(old('nama_produk', $produk->nama_produk)); ?>" required>
                                    <?php $__errorArgs = ['nama_produk'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="kategori">Kategori <span class="text-danger">*</span></label>
                                    <select class="form-control <?php $__errorArgs = ['kategori'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                            id="kategori" name="kategori" required>
                                        <option value="">Pilih Kategori</option>
                                        <option value="makanan" <?php echo e(old('kategori', $produk->kategori) == 'makanan' ? 'selected' : ''); ?>>Makanan</option>
                                        <option value="minuman" <?php echo e(old('kategori', $produk->kategori) == 'minuman' ? 'selected' : ''); ?>>Minuman</option>
                                        <option value="kerajinan" <?php echo e(old('kategori', $produk->kategori) == 'kerajinan' ? 'selected' : ''); ?>>Kerajinan</option>
                                        <option value="fashion" <?php echo e(old('kategori', $produk->kategori) == 'fashion' ? 'selected' : ''); ?>>Fashion</option>
                                        <option value="pertanian" <?php echo e(old('kategori', $produk->kategori) == 'pertanian' ? 'selected' : ''); ?>>Pertanian</option>
                                        <option value="jasa" <?php echo e(old('kategori', $produk->kategori) == 'jasa' ? 'selected' : ''); ?>>Jasa</option>
                                        <option value="lainnya" <?php echo e(old('kategori', $produk->kategori) == 'lainnya' ? 'selected' : ''); ?>>Lainnya</option>
                                    </select>
                                    <?php $__errorArgs = ['kategori'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="deskripsi">Deskripsi Produk <span class="text-danger">*</span></label>
                            <textarea class="form-control <?php $__errorArgs = ['deskripsi'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                      id="deskripsi" name="deskripsi" rows="4" required><?php echo e(old('deskripsi', $produk->deskripsi)); ?></textarea>
                            <?php $__errorArgs = ['deskripsi'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="harga">Harga (Rp) <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['harga'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="harga" name="harga" value="<?php echo e(old('harga', $produk->harga)); ?>" required min="0">
                                    <?php $__errorArgs = ['harga'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="stok">Stok <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['stok'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="stok" name="stok" value="<?php echo e(old('stok', $produk->stok)); ?>" required min="0">
                                    <?php $__errorArgs = ['stok'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="berat">Berat (gram)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['berat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="berat" name="berat" value="<?php echo e(old('berat', $produk->berat)); ?>" min="0">
                                    <?php $__errorArgs = ['berat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="kondisi">Kondisi</label>
                                    <select class="form-control <?php $__errorArgs = ['kondisi'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                            id="kondisi" name="kondisi">
                                        <option value="baru" <?php echo e(old('kondisi', $produk->kondisi) == 'baru' ? 'selected' : ''); ?>>Baru</option>
                                        <option value="bekas" <?php echo e(old('kondisi', $produk->kondisi) == 'bekas' ? 'selected' : ''); ?>>Bekas</option>
                                    </select>
                                    <?php $__errorArgs = ['kondisi'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="minimal_order">Minimal Order</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['minimal_order'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="minimal_order" name="minimal_order" 
                                           value="<?php echo e(old('minimal_order', $produk->minimal_order)); ?>" min="1">
                                    <?php $__errorArgs = ['minimal_order'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="waktu_produksi">Waktu Produksi</label>
                            <input type="text" class="form-control <?php $__errorArgs = ['waktu_produksi'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="waktu_produksi" name="waktu_produksi" 
                                   value="<?php echo e(old('waktu_produksi', $produk->waktu_produksi)); ?>"
                                   placeholder="Contoh: 1-2 hari kerja">
                            <?php $__errorArgs = ['waktu_produksi'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>

                <!-- Varian Produk -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Varian Produk</h6>
                    </div>
                    <div class="card-body">
                        <div id="varian-container">
                            <?php
                                $varian = old('varian', $produk->varian ? (is_array($produk->varian) ? $produk->varian : json_decode($produk->varian, true)) : []);
                            ?>
                            <?php if($varian && count($varian) > 0): ?>
                                <?php $__currentLoopData = $varian; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="row mb-2 varian-item">
                                        <div class="col-md-4">
                                            <input type="text" class="form-control" name="varian[<?php echo e($index); ?>][nama]" 
                                                   value="<?php echo e($item['nama'] ?? ''); ?>" placeholder="Nama varian">
                                        </div>
                                        <div class="col-md-3">
                                            <input type="number" class="form-control" name="varian[<?php echo e($index); ?>][harga]" 
                                                   value="<?php echo e($item['harga'] ?? ''); ?>" placeholder="Harga" min="0">
                                        </div>
                                        <div class="col-md-3">
                                            <input type="number" class="form-control" name="varian[<?php echo e($index); ?>][stok]" 
                                                   value="<?php echo e($item['stok'] ?? ''); ?>" placeholder="Stok" min="0">
                                        </div>
                                        <div class="col-md-2">
                                            <button type="button" class="btn btn-danger btn-sm btn-remove-varian">
                                                <i class="fas fa-times"></i>
                                            </button>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </div>
                        <button type="button" class="btn btn-success btn-sm mt-2" id="btn-add-varian">
                            <i class="fas fa-plus"></i> Tambah Varian
                        </button>
                    </div>
                </div>

                <!-- Tags -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Tags</h6>
                    </div>
                    <div class="card-body">
                        <div id="tags-container">
                            <?php
                                $tags = old('tags', $produk->tags ? (is_array($produk->tags) ? $produk->tags : json_decode($produk->tags, true)) : []);
                            ?>
                            <?php if($tags && count($tags) > 0): ?>
                                <?php $__currentLoopData = $tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="input-group mb-2 tag-item">
                                        <input type="text" class="form-control" name="tags[]" 
                                               value="<?php echo e($tag); ?>" placeholder="Masukkan tag">
                                        <div class="input-group-append">
                                            <button type="button" class="btn btn-danger btn-remove-tag">
                                                <i class="fas fa-times"></i>
                                            </button>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <div class="input-group mb-2 tag-item">
                                    <input type="text" class="form-control" name="tags[]" placeholder="Masukkan tag">
                                    <div class="input-group-append">
                                        <button type="button" class="btn btn-danger btn-remove-tag">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                        <button type="button" class="btn btn-success btn-sm mt-2" id="btn-add-tag">
                            <i class="fas fa-plus"></i> Tambah Tag
                        </button>
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <!-- UMKM Selection -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">UMKM</h6>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="umkm_id">Pilih UMKM <span class="text-danger">*</span></label>
                            <select class="form-control <?php $__errorArgs = ['umkm_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    id="umkm_id" name="umkm_id" required>
                                <option value="">Pilih UMKM</option>
                                <?php $__currentLoopData = $umkmList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $umkm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($umkm->id); ?>" <?php echo e(old('umkm_id', $produk->umkm_id) == $umkm->id ? 'selected' : ''); ?>>
                                        <?php echo e($umkm->nama_umkm); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['umkm_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>

                <!-- Photos -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Foto Produk</h6>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="foto_utama">Foto Utama</label>
                            <input type="file" class="form-control-file <?php $__errorArgs = ['foto_utama'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="foto_utama" name="foto_utama" accept="image/*">
                            <small class="text-muted">Format: JPG, PNG, WebP. Maksimal 2MB</small>
                            <?php $__errorArgs = ['foto_utama'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            
                            <?php if($produk->foto_utama): ?>
                                <div class="mt-2">
                                    <label class="small text-muted">Foto saat ini:</label><br>
                                    <img src="<?php echo e(Storage::url($produk->foto_utama)); ?>" 
                                         alt="Current Photo" 
                                         class="img-thumbnail"
                                         style="max-width: 150px;">
                                </div>
                            <?php endif; ?>
                        </div>

                        <div class="form-group">
                            <label for="galeri_foto">Galeri Foto</label>
                            <input type="file" class="form-control-file <?php $__errorArgs = ['galeri_foto'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="galeri_foto" name="galeri_foto[]" accept="image/*" multiple>
                            <small class="text-muted">Pilih beberapa foto sekaligus. Maksimal 5 foto</small>
                            <?php $__errorArgs = ['galeri_foto'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            <?php if($produk->galeri_foto): ?>
                                <?php
                                    $galeri = is_array($produk->galeri_foto) ? $produk->galeri_foto : json_decode($produk->galeri_foto, true);
                                ?>
                                <?php if($galeri && count($galeri) > 0): ?>
                                    <div class="mt-2">
                                        <label class="small text-muted">Galeri saat ini:</label>
                                        <div class="row">
                                            <?php $__currentLoopData = $galeri; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $foto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="col-6 mb-2">
                                                    <img src="<?php echo e(Storage::url($foto)); ?>" 
                                                         alt="Gallery" 
                                                         class="img-thumbnail"
                                                         style="width: 100%; height: 80px; object-fit: cover;">
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Status -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Status</h6>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="status">Status Produk</label>
                            <select class="form-control <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    id="status" name="status">
                                <option value="aktif" <?php echo e(old('status', $produk->status) == 'aktif' ? 'selected' : ''); ?>>Aktif</option>
                                <option value="nonaktif" <?php echo e(old('status', $produk->status) == 'nonaktif' ? 'selected' : ''); ?>>Non-aktif</option>
                                <option value="pending" <?php echo e(old('status', $produk->status) == 'pending' ? 'selected' : ''); ?>>Pending</option>
                            </select>
                            <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="card shadow">
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Update Produk
                            </button>
                            <a href="<?php echo e(route('admin.produk-umkm.show', $produk->id)); ?>" 
                               class="btn btn-secondary">
                                <i class="fas fa-times"></i> Batal
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    let varianIndex = <?php echo e(count($varian ?? [])); ?>;

    // Add new varian
    $('#btn-add-varian').click(function() {
        var newItem = `
            <div class="row mb-2 varian-item">
                <div class="col-md-4">
                    <input type="text" class="form-control" name="varian[${varianIndex}][nama]" placeholder="Nama varian">
                </div>
                <div class="col-md-3">
                    <input type="number" class="form-control" name="varian[${varianIndex}][harga]" placeholder="Harga" min="0">
                </div>
                <div class="col-md-3">
                    <input type="number" class="form-control" name="varian[${varianIndex}][stok]" placeholder="Stok" min="0">
                </div>
                <div class="col-md-2">
                    <button type="button" class="btn btn-danger btn-sm btn-remove-varian">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
        `;
        $('#varian-container').append(newItem);
        varianIndex++;
    });

    // Remove varian
    $(document).on('click', '.btn-remove-varian', function() {
        if ($('.varian-item').length > 1) {
            $(this).closest('.varian-item').remove();
        }
    });

    // Add new tag
    $('#btn-add-tag').click(function() {
        var newItem = `
            <div class="input-group mb-2 tag-item">
                <input type="text" class="form-control" name="tags[]" placeholder="Masukkan tag">
                <div class="input-group-append">
                    <button type="button" class="btn btn-danger btn-remove-tag">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
        `;
        $('#tags-container').append(newItem);
    });

    // Remove tag
    $(document).on('click', '.btn-remove-tag', function() {
        if ($('.tag-item').length > 1) {
            $(this).closest('.tag-item').remove();
        }
    });
});
</script>
<?php $__env->stopPush(); ?> 

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/produk-umkm/edit.blade.php ENDPATH**/ ?>