

<?php $__env->startSection('title', 'Tambah Role'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="mb-2">
                <i class="fas fa-plus me-2 text-primary"></i>Tambah Role
            </h2>
            <p class="text-muted mb-0">Buat peran baru dengan hak akses yang sesuai</p>
        </div>
        <div>
            <a href="<?php echo e(route('admin.roles.index')); ?>" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-2"></i>Kembali
            </a>
        </div>
    </div>

    <form id="createRoleForm">
        <?php echo csrf_field(); ?>
        <div class="row">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="fas fa-user-shield me-2"></i>Informasi Role</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label required">Nama Role</label>
                            <input type="text" class="form-control" name="name" required
                                   placeholder="contoh: operator_desa" pattern="[a-z_]+"
                                   title="Gunakan huruf kecil dan underscore">
                            <div class="form-text">Gunakan huruf kecil dan underscore (tanpa spasi)</div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label required">Display Name</label>
                            <input type="text" class="form-control" name="display_name" required
                                   placeholder="contoh: Operator Desa">
                            <div class="form-text">Nama yang akan ditampilkan di aplikasi</div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Deskripsi</label>
                            <textarea class="form-control" name="description" rows="3"
                                      placeholder="Jelaskan fungsi dan tanggung jawab role ini"></textarea>
                        </div>
                        
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="is_active" id="isActive" checked>
                            <label class="form-check-label" for="isActive">
                                Role aktif
                            </label>
                        </div>
                    </div>
                </div>
                
                <!-- Permissions -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="fas fa-key me-2"></i>Hak Akses (Permissions)</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <button type="button" class="btn btn-sm btn-outline-primary me-2" onclick="selectAll()">
                                <i class="fas fa-check-square"></i> Pilih Semua
                            </button>
                            <button type="button" class="btn btn-sm btn-outline-secondary" onclick="deselectAll()">
                                <i class="fas fa-square"></i> Hapus Semua
                            </button>
                        </div>
                        
                        <div class="row">
                            <?php $__currentLoopData = $permissions ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $module = explode('.', $permission)[0];
                                $action = explode('.', $permission)[1] ?? '';
                            ?>
                            
                            <?php if($action === 'view' || $permission === 'dashboard'): ?>
                            <div class="col-md-6 mb-3">
                                <div class="card border">
                                    <div class="card-header py-2">
                                        <h6 class="mb-0 text-capitalize"><?php echo e(ucwords(str_replace(['_', '-'], ' ', $module))); ?></h6>
                                    </div>
                                    <div class="card-body py-2">
                                        <?php endif; ?>
                                        
                                        <div class="form-check">
                                            <input class="form-check-input permission-check" type="checkbox" 
                                                   name="permissions[]" value="<?php echo e($permission); ?>" 
                                                   id="permission_<?php echo e(str_replace('.', '_', $permission)); ?>">
                                            <label class="form-check-label small" 
                                                   for="permission_<?php echo e(str_replace('.', '_', $permission)); ?>">
                                                <?php echo e($label); ?>

                                            </label>
                                        </div>
                                        
                                        <?php
                                            $nextPermission = array_keys($permissions)[array_search($permission, array_keys($permissions)) + 1] ?? null;
                                            $nextModule = $nextPermission ? explode('.', $nextPermission)[0] : null;
                                            $isLastInModule = $nextModule !== $module;
                                        ?>
                                        
                                        <?php if($isLastInModule || $loop->last): ?>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header">
                        <h6 class="mb-0"><i class="fas fa-info-circle me-2"></i>Panduan</h6>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-info">
                            <h6 class="alert-heading">
                                <i class="fas fa-lightbulb me-2"></i>Tips Membuat Role
                            </h6>
                            <ul class="mb-0 small">
                                <li>Nama role harus unik dan menggunakan format snake_case</li>
                                <li>Berikan hak akses sesuai dengan kebutuhan pengguna</li>
                                <li>Role yang dibuat dapat diubah kapan saja</li>
                                <li>Pastikan memberikan akses dashboard untuk role aktif</li>
                            </ul>
                        </div>
                        
                        <div class="alert alert-warning">
                            <h6 class="alert-heading">
                                <i class="fas fa-exclamation-triangle me-2"></i>Perhatian
                            </h6>
                            <p class="mb-0 small">
                                Hati-hati dalam memberikan hak akses. Pastikan sesuai dengan tanggung jawab masing-masing role.
                            </p>
                        </div>
                    </div>
                </div>
                
                <div class="card mt-4">
                    <div class="card-body">
                        <div class="d-grid">
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-save me-2"></i>Simpan Role
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
.required::after {
    content: ' *';
    color: #dc3545;
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function selectAll() {
    document.querySelectorAll('.permission-check').forEach(checkbox => {
        checkbox.checked = true;
    });
}

function deselectAll() {
    document.querySelectorAll('.permission-check').forEach(checkbox => {
        checkbox.checked = false;
    });
}

document.getElementById('createRoleForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    showLoading();
    
    fetch('<?php echo e(route("admin.roles.store")); ?>', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showToast('Role berhasil ditambahkan', 'success');
            setTimeout(() => {
                window.location.href = '<?php echo e(route("admin.roles.index")); ?>';
            }, 1500);
        } else {
            showToast(data.message || 'Gagal menambahkan role', 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showToast('Terjadi kesalahan', 'error');
    })
    .finally(() => {
        hideLoading();
    });
});
</script>
<?php $__env->stopPush(); ?> 

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/roles/create.blade.php ENDPATH**/ ?>