

<?php $__env->startSection('title', 'Detail Transaksi PPOB'); ?>

<?php $__env->startSection('breadcrumb'); ?>
<li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
<li class="breadcrumb-item"><a href="<?php echo e(route('admin.ppob.index')); ?>">PPOB Management</a></li>
<li class="breadcrumb-item active">Detail Transaksi</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    
    <div class="row">
        <!-- Transaction Info -->
        <div class="col-lg-8 mb-4">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-receipt me-2"></i>
                            Detail Transaksi
                        </h5>
                        <div class="btn-group">
                            <?php if($transaction->status === 'failed'): ?>
                            <button class="btn btn-warning" onclick="retryTransaction()">
                                <i class="fas fa-redo me-1"></i>
                                Retry
                            </button>
                            <?php endif; ?>
                            <button class="btn btn-info" onclick="checkStatus()">
                                <i class="fas fa-sync me-1"></i>
                                Check Status
                            </button>
                            <button class="btn btn-primary" onclick="window.print()">
                                <i class="fas fa-print me-1"></i>
                                Print
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    
                    <!-- Transaction Header -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <h4 class="text-primary"><?php echo e($transaction->order_id); ?></h4>
                            <p class="text-muted mb-0">Order ID</p>
                        </div>
                        <div class="col-md-6 text-md-end">
                            <?php echo $transaction->status_badge; ?>

                            <p class="text-muted mb-0 mt-2">Status Transaksi</p>
                        </div>
                    </div>

                    <!-- Transaction Details -->
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td class="fw-bold">Produk:</td>
                                    <td><?php echo e(strtoupper($transaction->product_type)); ?></td>
                                </tr>
                                <?php if($transaction->provider): ?>
                                <tr>
                                    <td class="fw-bold">Provider:</td>
                                    <td><?php echo e($transaction->provider); ?></td>
                                </tr>
                                <?php endif; ?>
                                <tr>
                                    <td class="fw-bold">Target Number:</td>
                                    <td><code><?php echo e($transaction->target_number); ?></code></td>
                                </tr>
                                <tr>
                                    <td class="fw-bold">Amount:</td>
                                    <td>Rp <?php echo e(number_format($transaction->amount)); ?></td>
                                </tr>
                                <tr>
                                    <td class="fw-bold">Admin Fee:</td>
                                    <td>Rp <?php echo e(number_format($transaction->admin_fee)); ?></td>
                                </tr>
                                <tr class="table-primary">
                                    <td class="fw-bold">Total Amount:</td>
                                    <td class="fw-bold">Rp <?php echo e(number_format($transaction->total_amount)); ?></td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td class="fw-bold">Created:</td>
                                    <td><?php echo e($transaction->created_at->format('d/m/Y H:i:s')); ?></td>
                                </tr>
                                <tr>
                                    <td class="fw-bold">Updated:</td>
                                    <td><?php echo e($transaction->updated_at->format('d/m/Y H:i:s')); ?></td>
                                </tr>
                                <?php if($transaction->payment_url): ?>
                                <tr>
                                    <td class="fw-bold">Payment URL:</td>
                                    <td>
                                        <a href="<?php echo e($transaction->payment_url); ?>" target="_blank" class="btn btn-sm btn-outline-primary">
                                            <i class="fas fa-external-link-alt me-1"></i>
                                            Open
                                        </a>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </table>
                        </div>
                    </div>

                </div>
            </div>
        </div>

        <!-- User Info -->
        <div class="col-lg-4 mb-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-user me-2"></i>
                        Informasi Customer
                    </h5>
                </div>
                <div class="card-body">
                    <?php if($transaction->user): ?>
                    <div class="d-flex align-items-center mb-3">
                        <div class="avatar-lg me-3">
                            <div class="avatar-title bg-primary text-white rounded-circle">
                                <?php echo e(substr($transaction->user->name, 0, 2)); ?>

                            </div>
                        </div>
                        <div>
                            <h6 class="mb-0"><?php echo e($transaction->user->name); ?></h6>
                            <small class="text-muted"><?php echo e($transaction->user->email); ?></small>
                        </div>
                    </div>
                    
                    <table class="table table-borderless table-sm">
                        <tr>
                            <td class="fw-bold">User ID:</td>
                            <td><?php echo e($transaction->user->id); ?></td>
                        </tr>
                        <tr>
                            <td class="fw-bold">Role:</td>
                            <td>
                                <span class="badge bg-info"><?php echo e($transaction->user->role ?? 'User'); ?></span>
                            </td>
                        </tr>
                        <tr>
                            <td class="fw-bold">Joined:</td>
                            <td><?php echo e($transaction->user->created_at->format('d/m/Y')); ?></td>
                        </tr>
                    </table>
                    
                    <div class="mt-3">
                        <a href="<?php echo e(route('admin.users.show', $transaction->user->id)); ?>" class="btn btn-sm btn-outline-primary">
                            <i class="fas fa-eye me-1"></i>
                            View Profile
                        </a>
                    </div>
                    <?php else: ?>
                    <div class="text-center text-muted">
                        <i class="fas fa-user-slash fa-3x mb-3"></i>
                        <p>Guest Transaction</p>
                        <small>No user account associated</small>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Payment Data -->
    <?php if($transaction->payment_data): ?>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-code me-2"></i>
                        Payment Data
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-6">
                            <h6>Payment Request Data:</h6>
                            <pre class="bg-light p-3 rounded"><code><?php echo e(json_encode(json_decode($transaction->payment_data), JSON_PRETTY_PRINT)); ?></code></pre>
                        </div>
                        <?php if($transaction->payment_response): ?>
                        <div class="col-lg-6">
                            <h6>Payment Response Data:</h6>
                            <pre class="bg-light p-3 rounded"><code><?php echo e(json_encode(json_decode($transaction->payment_response), JSON_PRETTY_PRINT)); ?></code></pre>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Transaction History -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-history me-2"></i>
                        Transaction Timeline
                    </h5>
                </div>
                <div class="card-body">
                    <div class="timeline">
                        <div class="timeline-item">
                            <div class="timeline-marker bg-primary"></div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">Transaction Created</h6>
                                <p class="timeline-text">Order <?php echo e($transaction->order_id); ?> created</p>
                                <small class="text-muted"><?php echo e($transaction->created_at->format('d/m/Y H:i:s')); ?></small>
                            </div>
                        </div>
                        
                        <?php if($transaction->payment_url): ?>
                        <div class="timeline-item">
                            <div class="timeline-marker bg-info"></div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">Payment URL Generated</h6>
                                <p class="timeline-text">Payment gateway URL created</p>
                                <small class="text-muted"><?php echo e($transaction->created_at->format('d/m/Y H:i:s')); ?></small>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <?php if($transaction->status === 'success'): ?>
                        <div class="timeline-item">
                            <div class="timeline-marker bg-success"></div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">Payment Completed</h6>
                                <p class="timeline-text">Transaction successfully processed</p>
                                <small class="text-muted"><?php echo e($transaction->updated_at->format('d/m/Y H:i:s')); ?></small>
                            </div>
                        </div>
                        <?php elseif($transaction->status === 'failed'): ?>
                        <div class="timeline-item">
                            <div class="timeline-marker bg-danger"></div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">Payment Failed</h6>
                                <p class="timeline-text">Transaction failed or cancelled</p>
                                <small class="text-muted"><?php echo e($transaction->updated_at->format('d/m/Y H:i:s')); ?></small>
                            </div>
                        </div>
                        <?php else: ?>
                        <div class="timeline-item">
                            <div class="timeline-marker bg-warning"></div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">Waiting for Payment</h6>
                                <p class="timeline-text">Transaction pending customer payment</p>
                                <small class="text-muted">Current status</small>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

<style>
.avatar-lg {
    width: 48px;
    height: 48px;
}

.avatar-title {
    width: 100%;
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 16px;
    font-weight: 600;
}

.timeline {
    position: relative;
    padding-left: 30px;
}

.timeline::before {
    content: '';
    position: absolute;
    left: 15px;
    top: 0;
    bottom: 0;
    width: 2px;
    background: #e9ecef;
}

.timeline-item {
    position: relative;
    margin-bottom: 30px;
}

.timeline-marker {
    position: absolute;
    left: -22px;
    top: 5px;
    width: 12px;
    height: 12px;
    border-radius: 50%;
    border: 2px solid white;
    box-shadow: 0 0 0 2px #e9ecef;
}

.timeline-content {
    background: #f8f9fa;
    padding: 15px;
    border-radius: 8px;
    border-left: 3px solid #007bff;
}

.timeline-title {
    margin-bottom: 5px;
    font-weight: 600;
}

.timeline-text {
    margin-bottom: 5px;
    color: #6c757d;
}

pre code {
    font-size: 12px;
    max-height: 300px;
    overflow-y: auto;
}

@media print {
    .btn-group,
    .card-header .btn-group {
        display: none !important;
    }
}
</style>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function retryTransaction() {
    if (confirm('Retry transaksi ini? Status akan dicek ulang dari payment gateway.')) {
        const btn = event.target;
        const originalText = btn.innerHTML;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin me-1"></i>Processing...';
        btn.disabled = true;
        
        fetch(`<?php echo e(route('admin.ppob.transaction.retry', $transaction->id)); ?>`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Status transaksi berhasil diperbarui');
                location.reload();
            } else {
                alert('Error: ' + data.message);
                btn.innerHTML = originalText;
                btn.disabled = false;
            }
        })
        .catch(error => {
            alert('Error: ' + error.message);
            btn.innerHTML = originalText;
            btn.disabled = false;
        });
    }
}

function checkStatus() {
    const btn = event.target;
    const originalText = btn.innerHTML;
    btn.innerHTML = '<i class="fas fa-spinner fa-spin me-1"></i>Checking...';
    btn.disabled = true;
    
    fetch(`/ppob/status/<?php echo e($transaction->order_id); ?>`)
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('Status: ' + data.data.transaction.status);
            if (data.data.transaction.status !== '<?php echo e($transaction->status); ?>') {
                location.reload();
            }
        } else {
            alert('Error: ' + data.message);
        }
        
        btn.innerHTML = originalText;
        btn.disabled = false;
    })
    .catch(error => {
        alert('Error: ' + error.message);
        btn.innerHTML = originalText;
        btn.disabled = false;
    });
}
</script>
<?php $__env->stopPush(); ?> 
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/ppob/transaction-detail.blade.php ENDPATH**/ ?>