<?php $__env->startSection('title', 'PPOB Management'); ?>

<?php $__env->startSection('breadcrumb'); ?>
<li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
<li class="breadcrumb-item active">PPOB Management</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    
    <!-- Statistics Cards -->
    <div class="row mb-3">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card stats-card gradient-primary">
                <div class="card-body p-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="stats-content">
                            <div class="stats-number"><?php echo e(number_format($stats['total_transactions'])); ?></div>
                            <div class="stats-label">Total Transaksi</div>
                        </div>
                        <div class="stats-icon-wrapper">
                        <div class="stats-icon">
                                <i class="fas fa-credit-card"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card stats-card gradient-warning">
                <div class="card-body p-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="stats-content">
                            <div class="stats-number"><?php echo e(number_format($stats['pending_transactions'])); ?></div>
                            <div class="stats-label">Menunggu Pembayaran</div>
                        </div>
                        <div class="stats-icon-wrapper">
                        <div class="stats-icon">
                                <i class="fas fa-hourglass-half"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card stats-card gradient-success">
                <div class="card-body p-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="stats-content">
                            <div class="stats-number"><?php echo e(number_format($stats['success_transactions'])); ?></div>
                            <div class="stats-label">Transaksi Berhasil</div>
                        </div>
                        <div class="stats-icon-wrapper">
                        <div class="stats-icon">
                                <i class="fas fa-check-circle"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card stats-card gradient-danger">
                <div class="card-body p-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="stats-content">
                            <div class="stats-number"><?php echo e(number_format($stats['failed_transactions'])); ?></div>
                            <div class="stats-label">Transaksi Gagal</div>
                        </div>
                        <div class="stats-icon-wrapper">
                        <div class="stats-icon">
                                <i class="fas fa-exclamation-triangle"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Revenue Cards -->
    <div class="row mb-3">
        <div class="col-lg-6 mb-3">
            <div class="card revenue-card gradient-info">
                <div class="card-body p-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="revenue-content">
                            <div class="revenue-amount">Rp <?php echo e(number_format($stats['total_revenue'])); ?></div>
                            <div class="revenue-label">Total Pendapatan</div>
                        </div>
                        <div class="revenue-icon-wrapper">
                            <div class="revenue-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-6 mb-3">
            <div class="card revenue-card gradient-success">
                <div class="card-body p-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="revenue-content">
                            <div class="revenue-amount">Rp <?php echo e(number_format($stats['admin_fee_revenue'])); ?></div>
                            <div class="revenue-label">Pendapatan Admin Fee</div>
                        </div>
                        <div class="revenue-icon-wrapper">
                            <div class="revenue-icon">
                                <i class="fas fa-wallet"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row mb-3">
        <!-- Monthly Revenue Chart -->
        <div class="col-lg-8 mb-3">
            <div class="card modern-card">
                <div class="card-header modern-header py-2">
                    <div class="d-flex align-items-center">
                        <div class="header-icon-small">
                            <i class="fas fa-chart-area"></i>
                        </div>
                        <h6 class="card-title mb-0 ms-2">Grafik Pendapatan Bulanan</h6>
                    </div>
                </div>
                <div class="card-body p-3">
                    <canvas id="revenueChart" height="200"></canvas>
                </div>
            </div>
        </div>

        <!-- Product Statistics -->
        <div class="col-lg-4 mb-3">
            <div class="card modern-card">
                <div class="card-header modern-header py-2">
                    <div class="d-flex align-items-center">
                        <div class="header-icon-small">
                            <i class="fas fa-chart-pie"></i>
                        </div>
                        <h6 class="card-title mb-0 ms-2">Statistik Produk</h6>
                    </div>
                </div>
                <div class="card-body p-3">
                    <canvas id="productChart" height="200"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="row mb-3">
        <div class="col-12">
            <div class="card modern-card">
                <div class="card-header modern-header py-2">
                    <div class="d-flex align-items-center">
                        <div class="header-icon-small">
                            <i class="fas fa-tools"></i>
                        </div>
                        <h6 class="card-title mb-0 ms-2">Quick Actions</h6>
                    </div>
                </div>
                <div class="card-body p-3">
                    <div class="row g-2">
                        <div class="col-lg-3 col-md-6">
                            <div class="action-card-small action-primary">
                                <a href="<?php echo e(route('admin.ppob.settings')); ?>" class="action-link-small">
                                    <div class="action-icon-small">
                                        <i class="fas fa-cog"></i>
                                    </div>
                                    <div class="action-content-small">
                                        <span>Pengaturan PPOB</span>
                                    </div>
                            </a>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6">
                            <div class="action-card-small action-success">
                                <a href="<?php echo e(route('admin.ppob.export')); ?>" class="action-link-small">
                                    <div class="action-icon-small">
                                        <i class="fas fa-download"></i>
                                    </div>
                                    <div class="action-content-small">
                                        <span>Export Data</span>
                                    </div>
                            </a>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6">
                            <div class="action-card-small action-info">
                                <button class="action-link-small" onclick="syncTransactions()">
                                    <div class="action-icon-small">
                                        <i class="fas fa-sync"></i>
                                    </div>
                                    <div class="action-content-small">
                                        <span>Sync Transaksi</span>
                                    </div>
                            </button>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6">
                            <div class="action-card-small action-warning">
                                <button class="action-link-small" onclick="generateReport()">
                                    <div class="action-icon-small">
                                        <i class="fas fa-file-pdf"></i>
                                    </div>
                                    <div class="action-content-small">
                                        <span>Generate Report</span>
                                    </div>
                            </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Transactions -->
    <div class="row">
        <div class="col-12">
            <div class="card modern-card">
                <div class="card-header modern-header py-2">
                    <div class="d-flex justify-content-between align-items-center w-100">
                        <div class="d-flex align-items-center">
                            <div class="header-icon-small">
                                <i class="fas fa-list"></i>
                            </div>
                            <h6 class="card-title mb-0 ms-2">Transaksi Terbaru</h6>
                        </div>
                    <div class="btn-group">
                            <button class="btn btn-xs btn-outline-primary rounded-pill" onclick="refreshTransactions()">
                            <i class="fas fa-refresh me-1"></i>
                            Refresh
                        </button>
                            <a href="<?php echo e(route('admin.transaksi.index')); ?>" class="btn btn-xs btn-primary rounded-pill ms-2">
                            <i class="fas fa-eye me-1"></i>
                            Lihat Semua
                        </a>
                        </div>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead>
                                <tr>
                                    <th>Order ID</th>
                                    <th>User</th>
                                    <th>Produk</th>
                                    <th>Target</th>
                                    <th>Amount</th>
                                    <th>Status</th>
                                    <th>Tanggal</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $recentTransactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <code><?php echo e($transaction->order_id); ?></code>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="avatar-sm me-2">
                                                <div class="avatar-title bg-soft-primary text-primary rounded-circle">
                                                    <?php echo e(substr($transaction->user->name ?? 'G', 0, 1)); ?>

                                                </div>
                                            </div>
                                            <div>
                                                <h6 class="mb-0"><?php echo e($transaction->user->name ?? 'Guest'); ?></h6>
                                                <small class="text-muted"><?php echo e($transaction->user->email ?? '-'); ?></small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div>
                                            <strong><?php echo e(strtoupper($transaction->product_type)); ?></strong>
                                            <?php if($transaction->provider): ?>
                                                <br><small class="text-muted"><?php echo e($transaction->provider); ?></small>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <code><?php echo e($transaction->target_number); ?></code>
                                    </td>
                                    <td>
                                        <div>
                                            <strong>Rp <?php echo e(number_format($transaction->total_amount)); ?></strong>
                                            <br><small class="text-muted">Admin: Rp <?php echo e(number_format($transaction->admin_fee)); ?></small>
                                        </div>
                                    </td>
                                    <td>
                                        <?php echo $transaction->status_badge; ?>

                                    </td>
                                    <td>
                                        <div>
                                            <?php echo e($transaction->created_at->format('d/m/Y')); ?>

                                            <br><small class="text-muted"><?php echo e($transaction->created_at->format('H:i')); ?></small>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <a href="<?php echo e(route('admin.ppob.transaction.show', $transaction->id)); ?>" 
                                               class="btn btn-outline-primary" title="Detail">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <?php if($transaction->status === 'failed'): ?>
                                            <button class="btn btn-outline-warning" 
                                                    onclick="retryTransaction(<?php echo e($transaction->id); ?>)" 
                                                    title="Retry">
                                                <i class="fas fa-redo"></i>
                                            </button>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="8" class="text-center py-4">
                                        <div class="text-muted">
                                            <i class="fas fa-inbox fa-3x mb-3"></i>
                                            <p>Belum ada transaksi PPOB</p>
                                        </div>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

<style>
/* Modern Card Styles */
.stats-card, .revenue-card, .modern-card {
    border: none;
    border-radius: 20px;
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.08);
    transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    overflow: hidden;
    position: relative;
}

.stats-card:hover, .revenue-card:hover {
    transform: translateY(-8px);
    box-shadow: 0 15px 35px rgba(0, 0, 0, 0.15);
}

/* Gradient Backgrounds */
.gradient-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.gradient-warning {
    background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
    color: white;
}

.gradient-success {
    background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
    color: white;
}

.gradient-danger {
    background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);
    color: white;
}

.gradient-info {
    background: linear-gradient(135deg, #a8edea 0%, #fed6e3 100%);
    color: #2c3e50;
}

/* Stats Content */
.stats-content, .revenue-content {
    flex: 1;
}

.stats-number, .revenue-amount {
    font-size: 1.8rem;
    font-weight: 700;
    line-height: 1.2;
    margin-bottom: 0.25rem;
}

.stats-label, .revenue-label {
    font-size: 0.875rem;
    font-weight: 500;
    opacity: 0.9;
    margin-bottom: 0;
}

.stats-trend, .revenue-period {
    font-size: 0.75rem;
    opacity: 0.8;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

/* Icon Wrapper */
.stats-icon-wrapper, .revenue-icon-wrapper {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.2);
    display: flex;
    align-items: center;
    justify-content: center;
    backdrop-filter: blur(10px);
}

.stats-icon, .revenue-icon {
    font-size: 1.3rem;
    color: rgba(255, 255, 255, 0.9);
}

/* Revenue Progress */
.revenue-progress {
    margin-top: 1rem;
}

.progress-bar-custom {
    height: 6px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 3px;
    overflow: hidden;
}

.progress-fill {
    height: 100%;
    background: rgba(255, 255, 255, 0.8);
    border-radius: 3px;
    transition: width 0.8s ease;
}

/* Modern Card Header */
.modern-header {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    border-bottom: 1px solid rgba(0, 0, 0, 0.05);
    padding: 1rem;
}

.header-icon {
    width: 50px;
    height: 50px;
    border-radius: 12px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.2rem;
}

.header-icon-small {
    width: 35px;
    height: 35px;
    border-radius: 8px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 0.9rem;
}

/* Action Cards */
.action-card {
    height: 100%;
    border-radius: 16px;
    overflow: hidden;
    transition: all 0.3s ease;
    border: 2px solid transparent;
}

.action-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 12px 25px rgba(0, 0, 0, 0.1);
}

.action-card-small {
    height: 100%;
    border-radius: 12px;
    overflow: hidden;
    transition: all 0.3s ease;
    border: 1px solid transparent;
}

.action-card-small:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 15px rgba(0, 0, 0, 0.1);
}

.action-primary { border-color: #667eea; }
.action-success { border-color: #4facfe; }
.action-info { border-color: #17a2b8; }
.action-warning { border-color: #f093fb; }

.action-link {
    display: flex;
    align-items: center;
    padding: 1.5rem;
    text-decoration: none;
    color: inherit;
    background: none;
    border: none;
    width: 100%;
    height: 100%;
    transition: all 0.3s ease;
}

.action-link-small {
    display: flex;
    align-items: center;
    padding: 0.75rem;
    text-decoration: none;
    color: inherit;
    background: none;
    border: none;
    width: 100%;
    height: 100%;
    transition: all 0.3s ease;
}

.action-link:hover, .action-link-small:hover {
    color: inherit;
    text-decoration: none;
}

.action-icon {
    width: 50px;
    height: 50px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.3rem;
    margin-right: 1rem;
    flex-shrink: 0;
}

.action-icon-small {
    width: 35px;
    height: 35px;
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1rem;
    margin-right: 0.75rem;
    flex-shrink: 0;
}

.action-primary .action-icon, .action-primary .action-icon-small {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.action-success .action-icon, .action-success .action-icon-small {
    background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
    color: white;
}

.action-info .action-icon, .action-info .action-icon-small {
    background: linear-gradient(135deg, #17a2b8 0%, #20c997 100%);
    color: white;
}

.action-warning .action-icon, .action-warning .action-icon-small {
    background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
    color: white;
}

.action-content h6 {
    margin-bottom: 0.25rem;
    font-weight: 600;
    font-size: 1rem;
}

.action-content small {
    color: #6c757d;
    font-size: 0.875rem;
}

.action-content-small span {
    font-weight: 500;
    font-size: 0.875rem;
    color: #495057;
}

/* Button Sizes */
.btn-xs {
    padding: 0.25rem 0.75rem;
    font-size: 0.75rem;
    line-height: 1.4;
    border-radius: 0.375rem;
}

/* Table Improvements */
.table-responsive {
    border-radius: 12px;
    overflow: hidden;
}

.table th {
    background: #f8f9fa;
    border: none;
    font-weight: 600;
    color: #495057;
    padding: 0.75rem;
    font-size: 0.875rem;
}

.table td {
    padding: 0.75rem;
    border-color: #f1f3f4;
    vertical-align: middle;
    font-size: 0.875rem;
}

.table tbody tr:hover {
    background-color: #f8f9fa;
}

/* Avatar Styles */
.avatar-sm {
    width: 32px;
    height: 32px;
}

.avatar-title {
    width: 100%;
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 14px;
    font-weight: 600;
}

.bg-soft-primary {
    background-color: rgba(13, 110, 253, 0.1);
}

/* Responsive Improvements */
@media (max-width: 768px) {
    .stats-number, .revenue-amount {
        font-size: 1.5rem;
    }
    
    .stats-icon-wrapper, .revenue-icon-wrapper {
        width: 45px;
        height: 45px;
    }
    
    .stats-icon, .revenue-icon {
        font-size: 1.1rem;
    }
    
    .action-icon {
        width: 40px;
        height: 40px;
        font-size: 1.1rem;
    }
    
    .action-icon-small {
        width: 30px;
        height: 30px;
        font-size: 0.9rem;
    }
    
    .header-icon-small {
        width: 30px;
        height: 30px;
        font-size: 0.8rem;
    }
    
    .table th, .table td {
        padding: 0.5rem;
        font-size: 0.8rem;
    }
}
</style>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Revenue Chart
const revenueCtx = document.getElementById('revenueChart').getContext('2d');
const revenueChart = new Chart(revenueCtx, {
    type: 'line',
    data: {
        labels: [
            <?php $__currentLoopData = $monthlyRevenue; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                '<?php echo e(date("M Y", mktime(0, 0, 0, $month->month, 1, $month->year))); ?>',
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        ],
        datasets: [{
            label: 'Total Pendapatan',
            data: [
                <?php $__currentLoopData = $monthlyRevenue; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($month->total); ?>,
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            ],
            borderColor: 'rgb(75, 192, 192)',
            backgroundColor: 'rgba(75, 192, 192, 0.1)',
            tension: 0.4,
            fill: true
        }, {
            label: 'Admin Fee',
            data: [
                <?php $__currentLoopData = $monthlyRevenue; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($month->admin_fee); ?>,
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            ],
            borderColor: 'rgb(255, 99, 132)',
            backgroundColor: 'rgba(255, 99, 132, 0.1)',
            tension: 0.4,
            fill: true
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                position: 'top',
            },
            title: {
                display: true,
                text: 'Pendapatan PPOB per Bulan'
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    callback: function(value) {
                        return 'Rp ' + value.toLocaleString('id-ID');
                    }
                }
            }
        }
    }
});

// Product Chart
const productCtx = document.getElementById('productChart').getContext('2d');
const productChart = new Chart(productCtx, {
    type: 'doughnut',
    data: {
        labels: [
            <?php $__currentLoopData = $productStats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                '<?php echo e(strtoupper($stat->product_type)); ?>',
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        ],
        datasets: [{
            data: [
                <?php $__currentLoopData = $productStats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($stat->count); ?>,
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            ],
            backgroundColor: [
                '#FF6384',
                '#36A2EB',
                '#FFCE56',
                '#4BC0C0',
                '#9966FF',
                '#FF9F40',
                '#FF6384',
                '#C9CBCF'
            ]
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                position: 'bottom',
            },
            title: {
                display: true,
                text: 'Distribusi Produk PPOB'
            }
        }
    }
});

// Functions
function refreshTransactions() {
    location.reload();
}

function syncTransactions() {
    if (confirm('Sinkronisasi semua transaksi dengan payment gateway?')) {
        const btn = event.target;
        const originalText = btn.innerHTML;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Syncing...';
        btn.disabled = true;
        
        setTimeout(() => {
            btn.innerHTML = originalText;
            btn.disabled = false;
            alert('Sinkronisasi selesai');
        }, 3000);
    }
}

function generateReport() {
    const startDate = prompt('Tanggal mulai (YYYY-MM-DD):');
    const endDate = prompt('Tanggal akhir (YYYY-MM-DD):');
    
    if (startDate && endDate) {
        window.open(`<?php echo e(route('admin.ppob.export')); ?>?start_date=${startDate}&end_date=${endDate}`);
    }
}

function retryTransaction(id) {
    if (confirm('Retry transaksi ini?')) {
        fetch(`<?php echo e(url('admin/ppob/transaction')); ?>/${id}/retry`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Transaksi berhasil diperbarui');
                location.reload();
            } else {
                alert('Error: ' + data.message);
            }
        })
        .catch(error => {
            alert('Error: ' + error.message);
        });
    }
}
</script>
<?php $__env->stopPush(); ?> 
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/ppob/index.blade.php ENDPATH**/ ?>