

<?php $__env->startSection('title', 'Kegiatan Pembangunan'); ?>

<?php $__env->startSection('breadcrumb'); ?>
<li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
<li class="breadcrumb-item active">Kegiatan Pembangunan</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="card-title mb-0">
                        <i class="fas fa-building text-primary me-2"></i>
                        Kegiatan Pembangunan Desa
                    </h4>
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addModal">
                        <i class="fas fa-plus me-1"></i>
                        Tambah Kegiatan
                    </button>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped" id="kegiatanTable">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Nama Kegiatan</th>
                                    <th>Lokasi</th>
                                    <th>Anggaran</th>
                                    <th>Progress</th>
                                    <th>Status</th>
                                    <th>Tahun</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $kegiatan ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($index + 1); ?></td>
                                    <td>
                                        <div>
                                            <strong><?php echo e($item->nama_kegiatan); ?></strong><br>
                                            <small class="text-muted"><?php echo e($item->jenis_kegiatan); ?></small>
                                        </div>
                                    </td>
                                    <td><?php echo e($item->lokasi); ?></td>
                                    <td>Rp <?php echo e(number_format($item->anggaran, 0, ',', '.')); ?></td>
                                    <td>
                                        <div class="progress" style="height: 20px;">
                                            <div class="progress-bar bg-<?php echo e($item->progress >= 100 ? 'success' : ($item->progress >= 50 ? 'warning' : 'danger')); ?>" 
                                                 style="width: <?php echo e($item->progress); ?>%">
                                                <?php echo e($item->progress); ?>%
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <?php if($item->status == 'perencanaan'): ?>
                                            <span class="badge bg-info">Perencanaan</span>
                                        <?php elseif($item->status == 'pelaksanaan'): ?>
                                            <span class="badge bg-warning">Pelaksanaan</span>
                                        <?php elseif($item->status == 'selesai'): ?>
                                            <span class="badge bg-success">Selesai</span>
                                        <?php else: ?>
                                            <span class="badge bg-danger">Ditunda</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($item->tahun_pelaksanaan); ?></td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <button class="btn btn-sm btn-info" onclick="showDetail(<?php echo e($item->id); ?>)">
                                                <i class="fas fa-eye"></i>
                                            </button>
                                            <button class="btn btn-sm btn-warning" onclick="editKegiatan(<?php echo e($item->id); ?>)">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <button class="btn btn-sm btn-success" onclick="updateProgress(<?php echo e($item->id); ?>)">
                                                <i class="fas fa-chart-line"></i>
                                            </button>
                                            <button class="btn btn-sm btn-danger" onclick="deleteKegiatan(<?php echo e($item->id); ?>)">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="8" class="text-center py-4">
                                        <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                        <p class="text-muted">Belum ada data kegiatan pembangunan</p>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Modal -->
<div class="modal fade" id="addModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Tambah Kegiatan Pembangunan</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="<?php echo e(route('admin.kegiatan-pembangunan.store')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Nama Kegiatan</label>
                                <input type="text" class="form-control" name="nama_kegiatan" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Jenis Kegiatan</label>
                                <select class="form-select" name="jenis_kegiatan" required>
                                    <option value="">Pilih Jenis</option>
                                    <option value="infrastruktur">Infrastruktur</option>
                                    <option value="fasilitas_umum">Fasilitas Umum</option>
                                    <option value="lingkungan">Lingkungan</option>
                                    <option value="ekonomi">Ekonomi</option>
                                    <option value="sosial">Sosial</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Deskripsi</label>
                        <textarea class="form-control" name="deskripsi" rows="3" required></textarea>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Lokasi</label>
                                <input type="text" class="form-control" name="lokasi" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Anggaran</label>
                                <input type="number" class="form-control" name="anggaran" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label class="form-label">Tahun Pelaksanaan</label>
                                <input type="number" class="form-control" name="tahun_pelaksanaan" value="<?php echo e(date('Y')); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label class="form-label">Tanggal Mulai</label>
                                <input type="date" class="form-control" name="tanggal_mulai" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label class="form-label">Tanggal Target Selesai</label>
                                <input type="date" class="form-control" name="tanggal_selesai">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Latitude</label>
                                <input type="number" step="any" class="form-control" name="latitude" placeholder="Contoh: -6.2088">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Longitude</label>
                                <input type="number" step="any" class="form-control" name="longitude" placeholder="Contoh: 106.8456">
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Foto Kegiatan</label>
                        <input type="file" class="form-control" name="foto[]" multiple accept=".jpg,.jpeg,.png">
                        <small class="text-muted">Format: JPG, PNG (Max: 5 foto, 2MB per foto)</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Progress Update Modal -->
<div class="modal fade" id="progressModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Update Progress Kegiatan</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="progressForm" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Progress (%)</label>
                        <input type="range" class="form-range" name="progress" id="progressRange" min="0" max="100" value="0" oninput="updateProgressValue(this.value)">
                        <div class="d-flex justify-content-between">
                            <span>0%</span>
                            <span id="progressValue">0%</span>
                            <span>100%</span>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Status</label>
                        <select class="form-select" name="status" id="progressStatus" required>
                            <option value="perencanaan">Perencanaan</option>
                            <option value="pelaksanaan">Pelaksanaan</option>
                            <option value="selesai">Selesai</option>
                            <option value="ditunda">Ditunda</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Keterangan Progress</label>
                        <textarea class="form-control" name="keterangan_progress" rows="3"></textarea>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Foto Progress</label>
                        <input type="file" class="form-control" name="foto_progress[]" multiple accept=".jpg,.jpeg,.png">
                        <small class="text-muted">Upload foto terbaru dari kegiatan</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Update Progress</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function updateProgress(id) {
    fetch(`<?php echo e(route('admin.kegiatan-pembangunan.index')); ?>/${id}`)
        .then(response => response.json())
        .then(data => {
            document.getElementById('progressRange').value = data.progress;
            document.getElementById('progressValue').textContent = data.progress + '%';
            document.getElementById('progressStatus').value = data.status;
            
            document.getElementById('progressForm').action = `<?php echo e(route('admin.kegiatan-pembangunan.index')); ?>/${id}`;
            
            new bootstrap.Modal(document.getElementById('progressModal')).show();
        });
}

function updateProgressValue(value) {
    document.getElementById('progressValue').textContent = value + '%';
    
    // Auto-update status based on progress
    const statusSelect = document.getElementById('progressStatus');
    if (value == 0) {
        statusSelect.value = 'perencanaan';
    } else if (value > 0 && value < 100) {
        statusSelect.value = 'pelaksanaan';
    } else if (value == 100) {
        statusSelect.value = 'selesai';
    }
}

function editKegiatan(id) {
    fetch(`<?php echo e(route('admin.kegiatan-pembangunan.index')); ?>/${id}`)
        .then(response => response.json())
        .then(data => {
            // Populate edit form (you can create similar edit modal as add modal)
            console.log('Edit data:', data);
            alert('Edit functionality will be implemented');
        });
}

function deleteKegiatan(id) {
    if (confirm('Apakah Anda yakin ingin menghapus kegiatan ini?')) {
        fetch(`<?php echo e(route('admin.kegiatan-pembangunan.index')); ?>/${id}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert('Error: ' + data.message);
            }
        });
    }
}

function showDetail(id) {
    fetch(`<?php echo e(route('admin.kegiatan-pembangunan.index')); ?>/${id}`)
        .then(response => response.json())
        .then(data => {
            let photos = '';
            if (data.foto && data.foto.length > 0) {
                photos = data.foto.map(foto => `<img src="${foto}" class="img-thumbnail me-2" style="height: 100px;">`).join('');
            }
            
            let content = `
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>Nama:</strong> ${data.nama_kegiatan}</p>
                        <p><strong>Jenis:</strong> ${data.jenis_kegiatan}</p>
                        <p><strong>Lokasi:</strong> ${data.lokasi}</p>
                        <p><strong>Anggaran:</strong> Rp ${new Intl.NumberFormat('id-ID').format(data.anggaran)}</p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>Progress:</strong> ${data.progress}%</p>
                        <p><strong>Status:</strong> ${data.status}</p>
                        <p><strong>Tahun:</strong> ${data.tahun_pelaksanaan}</p>
                        <p><strong>Koordinat:</strong> ${data.latitude || '-'}, ${data.longitude || '-'}</p>
                    </div>
                </div>
                <p><strong>Deskripsi:</strong> ${data.deskripsi}</p>
                ${photos ? '<p><strong>Foto:</strong></p>' + photos : ''}
            `;
            
            Swal.fire({
                title: 'Detail Kegiatan Pembangunan',
                html: content,
                icon: 'info',
                confirmButtonText: 'Tutup',
                width: '80%'
            });
        });
}
</script>
<?php $__env->stopPush(); ?> 

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/kegiatan-pembangunan/index.blade.php ENDPATH**/ ?>