

<?php $__env->startSection('title', 'Detail Keluarga'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="mb-2">
                <i class="fas fa-users me-2 text-primary"></i>
                Detail Keluarga
            </h2>
            <p class="text-muted mb-0">Informasi lengkap keluarga <?php echo e($keluarga->no_kk ?? 'KK123456789'); ?></p>
        </div>
        <div>
            <a href="<?php echo e(route('admin.keluarga.index')); ?>" class="btn btn-outline-secondary me-2">
                <i class="fas fa-arrow-left me-2"></i>Kembali
            </a>
            <a href="<?php echo e(route('admin.keluarga.edit', $keluarga->id ?? 1)); ?>" class="btn btn-warning">
                <i class="fas fa-edit me-2"></i>Edit
            </a>
        </div>
    </div>

    <div class="row">
        <!-- Informasi Keluarga -->
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-home me-2"></i>Informasi Keluarga
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted">Nomor KK</label>
                                <div class="fw-bold fs-5"><?php echo e($keluarga->no_kk ?? '1234567890123456'); ?></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted">Kepala Keluarga</label>
                                            <div class="fw-bold"><?php echo e(optional($keluarga->kepalaKeluarga)->nama ?? 'Ahmad Sulaiman'); ?></div>
            <?php if(optional($keluarga->kepalaKeluarga)->nik): ?>
            <small class="text-muted">NIK: <?php echo e(optional($keluarga->kepalaKeluarga)->nik ?? '1234567890123456'); ?></small>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label text-muted">Alamat Lengkap</label>
                        <div class="fw-medium"><?php echo e($keluarga->alamat ?? 'Jl. Mawar No. 15, RT 001 RW 002'); ?></div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-3">
                            <div class="mb-3">
                                <label class="form-label text-muted">Dusun</label>
                                <div class="fw-medium"><?php echo e($keluarga->dusun ?? 'Dusun 1'); ?></div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="mb-3">
                                <label class="form-label text-muted">RT</label>
                                <div class="fw-medium"><?php echo e($keluarga->rt ?? '001'); ?></div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="mb-3">
                                <label class="form-label text-muted">RW</label>
                                <div class="fw-medium"><?php echo e($keluarga->rw ?? '002'); ?></div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="mb-3">
                                <label class="form-label text-muted">Kode Pos</label>
                                <div class="fw-medium"><?php echo e($keluarga->kode_pos ?? '12345'); ?></div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted">Status Ekonomi</label>
                                <div>
                                    <?php if($keluarga->status_ekonomi ?? 'sejahtera_1'): ?>
                                    <span class="badge bg-info">
                                        <?php echo e(ucwords(str_replace('_', ' ', $keluarga->status_ekonomi ?? 'Sejahtera I'))); ?>

                                    </span>
                                    <?php else: ?>
                                    <span class="text-muted">Belum diset</span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted">Jenis Rumah</label>
                                <div>
                                    <?php if($keluarga->jenis_rumah ?? 'permanen'): ?>
                                    <span class="badge bg-secondary">
                                        <?php echo e(ucwords(str_replace('_', ' ', $keluarga->jenis_rumah ?? 'Permanen'))); ?>

                                    </span>
                                    <?php else: ?>
                                    <span class="text-muted">Belum diset</span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <?php if($keluarga->catatan ?? false): ?>
                    <div class="mb-3">
                        <label class="form-label text-muted">Catatan</label>
                        <div class="fw-medium"><?php echo e($keluarga->catatan); ?></div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            
            <!-- Anggota Keluarga -->
            <div class="card mt-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-users me-2"></i>Anggota Keluarga
                    </h5>
                                            <span class="badge bg-primary"><?php echo e($keluarga->anggotaKeluarga ? $keluarga->anggotaKeluarga->count() : 0); ?> Orang</span>
                </div>
                <div class="card-body">
                                            <?php if($keluarga->anggotaKeluarga && $keluarga->anggotaKeluarga->count() > 0): ?>
                    <div class="row">
                        <?php
                            $anggota_dummy = [
                                ['id' => 1, 'nama' => 'Ahmad Sulaiman', 'nik' => '1234567890123456', 'jk' => 'L', 'hubungan' => 'Kepala Keluarga'],
                                ['id' => 2, 'nama' => 'Siti Aminah', 'nik' => '1234567890123457', 'jk' => 'P', 'hubungan' => 'Istri'],
                                ['id' => 3, 'nama' => 'Budi Santoso', 'nik' => '1234567890123458', 'jk' => 'L', 'hubungan' => 'Anak'],
                                ['id' => 4, 'nama' => 'Ani Sulistia', 'nik' => '1234567890123459', 'jk' => 'P', 'hubungan' => 'Anak']
                            ];
                        ?>
                        
                        <?php $__currentLoopData = $keluarga->anggotaKeluarga ?? $anggota_dummy; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $anggota): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-6 mb-3">
                            <div class="card border">
                                <div class="card-body p-3">
                                    <div class="d-flex align-items-center">
                                        <div class="avatar bg-<?php echo e((is_array($anggota) ? $anggota['jk'] : ($anggota->penduduk->jenis_kelamin ?? 'L')) === 'L' ? 'primary' : 'danger'); ?> text-white me-3" 
                                             style="width: 40px; height: 40px; border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                                            <i class="fas fa-user"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <h6 class="mb-1"><?php echo e(is_array($anggota) ? $anggota['nama'] : ($anggota->penduduk->nama ?? 'Nama Tidak Diketahui')); ?></h6>
                                            <small class="text-muted"><?php echo e(is_array($anggota) ? $anggota['nik'] : ($anggota->nik ?? 'NIK Tidak Diketahui')); ?></small>
                                            <div class="mt-1">
                                                <span class="badge bg-<?php echo e((is_array($anggota) ? $anggota['hubungan'] : ($anggota->status_keluarga ?? 'Anggota')) === 'Kepala Keluarga' ? 'success' : 'secondary'); ?> small">
                                                    <?php echo e(is_array($anggota) ? $anggota['hubungan'] : ($anggota->status_keluarga ?? 'Anggota')); ?>

                                                </span>
                                            </div>
                                        </div>
                                        <div>
                                            <a href="<?php echo e(route('admin.penduduk.show', is_array($anggota) ? $anggota['id'] : ($anggota->penduduk->id ?? 1))); ?>" 
                                               class="btn btn-sm btn-outline-primary" title="Lihat Detail">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php else: ?>
                    <div class="text-center text-muted py-4">
                        <i class="fas fa-users fa-3x mb-3"></i>
                        <p>Belum ada anggota keluarga</p>
                        <a href="<?php echo e(route('admin.keluarga.edit', $keluarga->id ?? 1)); ?>" class="btn btn-primary">
                            <i class="fas fa-plus me-2"></i>Tambah Anggota
                        </a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Statistik -->
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-chart-bar me-2"></i>Statistik Keluarga
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-6">
                            <div class="border-end">
                                <h4 class="text-primary mb-1"><?php echo e($stats['laki_laki'] ?? 2); ?></h4>
                                <small class="text-muted">Laki-laki</small>
                            </div>
                        </div>
                        <div class="col-6">
                            <h4 class="text-danger mb-1"><?php echo e($stats['perempuan'] ?? 2); ?></h4>
                            <small class="text-muted">Perempuan</small>
                        </div>
                    </div>
                    
                    <hr>
                    
                    <div class="small">
                        <div class="d-flex justify-content-between mb-2">
                            <span>Dewasa (≥18 tahun)</span>
                            <span class="fw-bold"><?php echo e($stats['dewasa'] ?? 2); ?></span>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span>Anak (< 18 tahun)</span>
                            <span class="fw-bold"><?php echo e($stats['anak'] ?? 2); ?></span>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Informasi Sistem -->
            <div class="card mt-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-info-circle me-2"></i>Informasi Sistem
                    </h6>
                </div>
                <div class="card-body">
                    <div class="small">
                        <div class="d-flex justify-content-between mb-2">
                            <span>ID Keluarga</span>
                            <span class="fw-bold">#<?php echo e($keluarga->id ?? 1); ?></span>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span>Dibuat</span>
                            <span class="fw-bold"><?php echo e($keluarga->created_at->format('d/m/Y H:i') ?? '01/11/2024 08:00'); ?></span>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span>Diperbarui</span>
                            <span class="fw-bold"><?php echo e($keluarga->updated_at->format('d/m/Y H:i') ?? '15/11/2024 14:30'); ?></span>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Aksi -->
            <div class="card mt-4">
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="<?php echo e(route('admin.keluarga.edit', $keluarga->id ?? 1)); ?>" class="btn btn-warning">
                            <i class="fas fa-edit me-2"></i>Edit Keluarga
                        </a>
                        <button type="button" class="btn btn-outline-primary" onclick="printKeluarga()">
                            <i class="fas fa-print me-2"></i>Cetak Data
                        </button>
                        <button type="button" class="btn btn-outline-info" onclick="exportKeluarga()">
                            <i class="fas fa-download me-2"></i>Export PDF
                        </button>
                    </div>
                </div>
            </div>
            
            <!-- Danger Zone -->
            <div class="card mt-4 border-danger">
                <div class="card-body">
                    <h6 class="text-danger">
                        <i class="fas fa-exclamation-triangle me-2"></i>Zona Bahaya
                    </h6>
                    <p class="text-muted mb-3">Hapus data keluarga secara permanen.</p>
                    <button type="button" class="btn btn-danger btn-sm" onclick="deleteKeluarga()">
                        <i class="fas fa-trash me-2"></i>Hapus Keluarga
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function printKeluarga() {
    window.print();
}

function exportKeluarga() {
    window.open(`/admin/keluarga/<?php echo e($keluarga->id ?? 1); ?>/export-pdf`, '_blank');
}

function deleteKeluarga() {
    if (confirm('Apakah Anda yakin ingin menghapus data keluarga ini?\n\nSemua anggota keluarga akan kehilangan keterkaitan dengan keluarga ini.')) {
        fetch(`/admin/keluarga/<?php echo e($keluarga->id ?? 1); ?>`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showToast('Data keluarga berhasil dihapus', 'success');
                setTimeout(() => {
                    window.location.href = '<?php echo e(route("admin.keluarga.index")); ?>';
                }, 1500);
            } else {
                showToast(data.message || 'Gagal menghapus data', 'error');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showToast('Terjadi kesalahan', 'error');
        });
    }
}
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
@media print {
    .btn, .card-header .badge {
        display: none !important;
    }
}
</style>
<?php $__env->stopPush(); ?> 

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/keluarga/show.blade.php ENDPATH**/ ?>