

<?php $__env->startSection('title', 'Manajemen PBB'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Data PBB (Pajak Bumi dan Bangunan)</h3>
                    <div class="card-tools">
                        <a href="<?php echo e(route('admin.pbb.create')); ?>" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> Tambah Data PBB
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Statistik -->
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-info"><i class="fas fa-home"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Total Objek PBB</span>
                                    <span class="info-box-number"><?php echo e(number_format($statistik['total_pbb'])); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-success"><i class="fas fa-check-circle"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Lunas</span>
                                    <span class="info-box-number"><?php echo e(number_format($statistik['lunas'])); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-warning"><i class="fas fa-exclamation-circle"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Belum Lunas</span>
                                    <span class="info-box-number"><?php echo e(number_format($statistik['belum_lunas'])); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-danger"><i class="fas fa-money-bill-wave"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Total Tagihan</span>
                                    <span class="info-box-number">Rp <?php echo e(number_format($statistik['total_tagihan'], 0, ',', '.')); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Filter -->
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <form method="GET" action="<?php echo e(route('admin.pbb.index')); ?>">
                                <div class="input-group">
                                    <input type="text" name="search" class="form-control" placeholder="Cari NOP, Nama Pemilik, atau Alamat..." value="<?php echo e(request('search')); ?>">
                                    <div class="input-group-append">
                                        <button class="btn btn-outline-secondary" type="submit">
                                            <i class="fas fa-search"></i>
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-md-6">
                            <form method="GET" action="<?php echo e(route('admin.pbb.index')); ?>">
                                <div class="input-group">
                                    <select name="status" class="form-control">
                                        <option value="">Semua Status</option>
                                        <option value="Lunas" <?php echo e(request('status') == 'Lunas' ? 'selected' : ''); ?>>Lunas</option>
                                        <option value="Belum Lunas" <?php echo e(request('status') == 'Belum Lunas' ? 'selected' : ''); ?>>Belum Lunas</option>
                                        <option value="Dicicil" <?php echo e(request('status') == 'Dicicil' ? 'selected' : ''); ?>>Dicicil</option>
                                    </select>
                                    <div class="input-group-append">
                                        <button class="btn btn-outline-secondary" type="submit">Filter</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- Tabel Data -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>NOP</th>
                                    <th>Nama Pemilik</th>
                                    <th>Alamat Objek</th>
                                    <th>Luas Tanah</th>
                                    <th>Luas Bangunan</th>
                                    <th>PBB Terhutang</th>
                                    <th>Status Tahun Ini</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $pbbList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $pbb): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($pbbList->firstItem() + $index); ?></td>
                                        <td><?php echo e($pbb->formatted_nop); ?></td>
                                        <td><?php echo e($pbb->nama_pemilik); ?></td>
                                        <td><?php echo e($pbb->alamat_objek); ?></td>
                                        <td><?php echo e(number_format($pbb->luas_tanah, 0, ',', '.')); ?> m²</td>
                                        <td><?php echo e(number_format($pbb->luas_bangunan, 0, ',', '.')); ?> m²</td>
                                        <td>Rp <?php echo e(number_format($pbb->pbb_terhutang, 0, ',', '.')); ?></td>
                                        <td>
                                            <?php
                                                $statusTerkini = $pbb->getStatusPembayaranTerkini();
                                            ?>
                                            <?php if($statusTerkini == 'Lunas'): ?>
                                                <span class="badge badge-success"><?php echo e($statusTerkini); ?></span>
                                            <?php elseif($statusTerkini == 'Dicicil'): ?>
                                                <span class="badge badge-warning"><?php echo e($statusTerkini); ?></span>
                                            <?php elseif($statusTerkini == 'Belum Lunas'): ?>
                                                <span class="badge badge-danger"><?php echo e($statusTerkini); ?></span>
                                            <?php else: ?>
                                                <span class="badge badge-secondary"><?php echo e($statusTerkini); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="<?php echo e(route('admin.pbb.show', $pbb)); ?>" class="btn btn-info btn-sm" title="Detail">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="<?php echo e(route('admin.pbb.edit', $pbb)); ?>" class="btn btn-warning btn-sm" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form method="POST" action="<?php echo e(route('admin.pbb.destroy', $pbb)); ?>" style="display:inline;" onsubmit="return confirm('Yakin ingin menghapus data ini?')">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-danger btn-sm" title="Hapus">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="9" class="text-center">Tidak ada data PBB</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-center">
                        <?php echo e($pbbList->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/pbb/index.blade.php ENDPATH**/ ?>